/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin.workstation;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.item.ItemEngine;
import com.ocelot.vehicle.jei.VehicleModJei;
import com.ocelot.vehicle.jei.plugin.workstation.VehicleIngredient;
import com.ocelot.vehicle.jei.plugin.workstation.VehicleRecipeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class VehicleRecipeMaker {
    private VehicleRecipeMaker() {
    }

    public static List<VehicleRecipeWrapper> getRecipes(IJeiHelpers jeiHelpers) {
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        ImmutableMap vehicleRecipes = VehicleRecipes.RECIPES;
        ArrayList<VehicleRecipeWrapper> recipes = new ArrayList<VehicleRecipeWrapper>();
        WorldClient fakeWorld = new WorldClient(null, new WorldSettings(0L, GameType.NOT_SET, false, false, WorldType.field_77137_b), 0, EnumDifficulty.PEACEFUL, null);
        vehicleRecipes.forEach((arg_0, arg_1) -> VehicleRecipeMaker.lambda$getRecipes$2((World)fakeWorld, stackHelper, recipes, jeiHelpers, arg_0, arg_1));
        return recipes;
    }

    private static /* synthetic */ void lambda$getRecipes$2(World fakeWorld, IStackHelper stackHelper, List recipes, IJeiHelpers jeiHelpers, Class vehicleClass, VehicleRecipes.VehicleRecipe vehicleRecipe) {
        EntityEntry vehicleEntry = EntityRegistry.getEntry((Class)vehicleClass);
        if (vehicleEntry == null) {
            VehicleModJei.LOGGER.warn("Vehicle class {} is not a registered vehicle entity. Skipping!", (Object)vehicleClass);
            return;
        }
        Entity vehicleEntity = vehicleEntry.newInstance(fakeWorld);
        if (!(vehicleEntity instanceof EntityVehicle)) {
            VehicleModJei.LOGGER.warn("Vehicle {} does not extend EntityVehicle. Skipping!", (Object)vehicleEntity);
            return;
        }
        ArrayList<List<ItemStack>> itemInputs = new ArrayList<List<ItemStack>>();
        VehicleIngredient vehicleOutput = new VehicleIngredient((EntityVehicle)vehicleEntity, vehicleEntry);
        if (vehicleEntity instanceof EntityPoweredVehicle) {
            EntityPoweredVehicle poweredVehicle = (EntityPoweredVehicle)vehicleEntity;
            poweredVehicle.setEngine(true);
            poweredVehicle.setWheels(true);
            if (poweredVehicle.getEngineType() != EngineType.NONE) {
                ForgeRegistries.ITEMS.forEach(item -> {
                    if (item instanceof ItemEngine && ((ItemEngine)item).getEngineType() == poweredVehicle.getEngineType()) {
                        itemInputs.add(stackHelper.getSubtypes(new ItemStack(item, 1, Short.MAX_VALUE)));
                    }
                });
            } else {
                itemInputs.add(Collections.singletonList(ItemStack.field_190927_a));
            }
            if (poweredVehicle.canChangeWheels()) {
                itemInputs.add(stackHelper.getSubtypes(new ItemStack(ModItems.WHEEL, 1, Short.MAX_VALUE)));
            } else {
                itemInputs.add(Collections.singletonList(ItemStack.field_190927_a));
            }
        } else {
            itemInputs.add(Collections.singletonList(ItemStack.field_190927_a));
            itemInputs.add(Collections.singletonList(ItemStack.field_190927_a));
        }
        vehicleRecipe.getMaterials().forEach(material -> itemInputs.add(stackHelper.getSubtypes(material.func_77946_l())));
        recipes.add(new VehicleRecipeWrapper(jeiHelpers.getGuiHelper(), itemInputs, vehicleOutput));
    }
}

