/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin.fluidmixer;

import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import com.ocelot.vehicle.jei.VehicleModJei;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidMixerRecipeWrapper
implements IRecipeWrapper {
    public static final int BAR_HORIZONTAL = 12;
    public static final int BAR_VERTICAL = 8;
    public static final int MIX_HORIZONTAL = 76;
    public static final int JUNCTION_SIZE = 10;
    public static final int SUM_LENGTH = 116;
    public static final int FLUID_ALPHA = 130;
    private final IDrawableStatic progressBackgroundMask;
    private final IDrawableStatic progressMask;
    private final ITickTimer progress;
    private final int fluidInput1Color;
    private final int fluidInput2Color;
    private final int fluidOutputColor;
    private final int startColor;
    private final List<ItemStack> itemInput;
    private final FluidStack fluidInput1;
    private final FluidStack fluidInput2;
    private final FluidStack fluidOutput;

    FluidMixerRecipeWrapper(IGuiHelper guiHelper, List<ItemStack> itemInput, FluidStack fluidInput1, FluidStack fluidInput2, FluidStack fluidOutput) {
        this.progressBackgroundMask = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 176, 17, 76, 26);
        this.progressMask = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 65, 20, 76, 26);
        this.progress = guiHelper.createTickTimer(100, 100, false);
        this.fluidInput1Color = FluidUtils.getAverageFluidColor((Fluid)fluidInput1.getFluid());
        this.fluidInput2Color = FluidUtils.getAverageFluidColor((Fluid)fluidInput2.getFluid());
        this.fluidOutputColor = FluidUtils.getAverageFluidColor((Fluid)fluidOutput.getFluid());
        this.startColor = FluidMixerRecipeWrapper.averageColor(this.fluidInput1Color, this.fluidInput2Color);
        this.itemInput = itemInput;
        this.fluidInput1 = fluidInput1;
        this.fluidInput2 = fluidInput2;
        this.fluidOutput = fluidOutput;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.itemInput));
        ingredients.setInputs(VanillaTypes.FLUID, Arrays.asList(this.fluidInput1, this.fluidInput2));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)this.fluidOutput);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int alpha;
        double percentageJunction;
        double progressPercentage = (double)this.progress.getValue() / (double)this.progress.getMaxValue();
        double percentagePrevious = 0.0;
        double percentageBarHorizontal = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.10344827586206896), (double)0.0, (double)1.0);
        percentagePrevious += 0.10344827586206896;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Gui.func_73734_a((int)43, (int)11, (int)(43 + (int)(percentageBarHorizontal * 12.0)), (int)19, (int)(0x82000000 | this.fluidInput1Color));
        Gui.func_73734_a((int)43, (int)47, (int)(43 + (int)(percentageBarHorizontal * 12.0)), (int)55, (int)(0x82000000 | this.fluidInput2Color));
        if (progressPercentage >= percentagePrevious) {
            percentageJunction = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.08620689655172414), (double)0.0, (double)1.0);
            percentagePrevious += 0.08620689655172414;
            alpha = (int)(130.0 * percentageJunction);
            int fluidInput1JunctionColor = alpha << 24 | this.fluidInput1Color;
            int fluidInput2JunctionColor = alpha << 24 | this.fluidInput2Color;
            Gui.func_73734_a((int)55, (int)10, (int)65, (int)20, (int)fluidInput1JunctionColor);
            Gui.func_73734_a((int)55, (int)46, (int)65, (int)56, (int)fluidInput2JunctionColor);
        }
        if (progressPercentage >= percentagePrevious) {
            double percentageBarVertical = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.06896551724137931), (double)0.0, (double)1.0);
            percentagePrevious += 0.06896551724137931;
            Gui.func_73734_a((int)56, (int)20, (int)64, (int)(20 + (int)(percentageBarVertical * 8.0)), (int)(0x82000000 | this.fluidInput1Color));
            Gui.func_73734_a((int)56, (int)(46 - (int)(percentageBarVertical * 8.0)), (int)64, (int)46, (int)(0x82000000 | this.fluidInput2Color));
        }
        if (progressPercentage >= percentagePrevious) {
            percentageJunction = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.08620689655172414), (double)0.0, (double)1.0);
            percentagePrevious += 0.08620689655172414;
            alpha = (int)(130.0 * percentageJunction);
            int color = alpha << 24 | this.startColor;
            Gui.func_73734_a((int)55, (int)28, (int)65, (int)38, (int)color);
        }
        if (progressPercentage >= percentagePrevious) {
            double percentageMix = MathHelper.func_151237_a((double)((progressPercentage - percentagePrevious) / 0.6551724137931034), (double)0.0, (double)1.0);
            GlStateManager.func_179097_i();
            RenderUtil.drawGradientRectHorizontal((int)65, (int)20, (int)141, (int)46, (int)(0x82000000 | this.startColor), (int)(0x82000000 | this.fluidOutputColor), (double)0.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.progressBackgroundMask.draw(minecraft, 65, 20);
            this.progressMask.draw(minecraft, 65, 20, 0, 0, (int)(percentageMix * 76.0), 0);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179084_k();
    }

    private static int averageColor(int color1, int color2) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return (a1 + a2) / 2 << 24 | (r1 + r2) / 2 << 16 | (g1 + g2) / 2 << 8 | (b1 + b2) / 2;
    }
}

