/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin.fluidextractor;

import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import com.ocelot.vehicle.jei.VehicleModJei;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidExtractorRecipeWrapper
implements IRecipeWrapper {
    private final IDrawableStatic progressOverlayStatic;
    private final IDrawableStatic progressOverlay;
    private final ITickTimer progress;
    private final List<ItemStack> itemInput;
    private final FluidStack fluidOutput;

    FluidExtractorRecipeWrapper(IGuiHelper guiHelper, List<ItemStack> itemInput, FluidStack fluidOutput) {
        this.progressOverlayStatic = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 176, 0, 24, 17);
        this.progressOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 200, 0, 24, 17);
        this.progress = guiHelper.createTickTimer(600, 600, false);
        this.itemInput = itemInput;
        this.fluidOutput = fluidOutput;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.itemInput));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)this.fluidOutput);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderUtil.drawGradientRectHorizontal((int)61, (int)22, (int)(60 + this.progressOverlay.getWidth()), (int)(21 + this.progressOverlay.getHeight()), (int)-1, (int)(0xFF000000 | FluidUtils.getAverageFluidColor((Fluid)this.fluidOutput.getFluid())), (double)0.0);
        this.progressOverlayStatic.draw(minecraft, 61, 22);
        this.progressOverlay.draw(minecraft, 61, 22, 0, 0, (int)(22.0 * ((double)this.progress.getValue() / (double)this.progress.getMaxValue()) + 1.0), 0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
    }
}

