/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin;

import com.mrcrayfish.vehicle.client.gui.GuiFluidExtractor;
import com.mrcrayfish.vehicle.client.gui.GuiFluidMixer;
import com.mrcrayfish.vehicle.common.container.ContainerFluidExtractor;
import com.mrcrayfish.vehicle.common.container.ContainerFluidMixer;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.ocelot.vehicle.jei.plugin.fluidextractor.FluidExtractorCategory;
import com.ocelot.vehicle.jei.plugin.fluidextractor.FluidExtractorRecipeMaker;
import com.ocelot.vehicle.jei.plugin.fluidmixer.FluidMixerCategory;
import com.ocelot.vehicle.jei.plugin.fluidmixer.FluidMixerRecipeMaker;
import com.ocelot.vehicle.jei.plugin.workstation.VehicleCategory;
import com.ocelot.vehicle.jei.plugin.workstation.VehicleRecipeMaker;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@JEIPlugin
public class VehicleModJeiPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)ModBlocks.VEHICLE_CRATE), stack -> {
            if (stack.func_179543_a("BlockEntityTag") != null) {
                NBTTagCompound blockEntityTag = stack.func_179543_a("BlockEntityTag");
                return blockEntityTag != null ? blockEntityTag.func_74779_i("vehicle") : "";
            }
            return "";
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidExtractorCategory(guiHelper), new FluidMixerCategory(guiHelper), new VehicleCategory(guiHelper)});
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipes(FluidExtractorRecipeMaker.getRecipes(jeiHelpers), "jev:fluid_extractor");
        registry.addRecipes(FluidMixerRecipeMaker.getRecipes(jeiHelpers), "jev:fluid_mixer");
        registry.addRecipes(VehicleRecipeMaker.getRecipes(jeiHelpers), "jev:vehicle");
        registry.addRecipeClickArea(GuiFluidExtractor.class, 93, 35, 24, 17, new String[]{"jev:fluid_extractor", "minecraft.fuel"});
        registry.addRecipeClickArea(GuiFluidMixer.class, 51, 26, 47, 46, new String[]{"jev:fluid_mixer", "minecraft.fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.FLUID_EXTRACTOR), new String[]{"jev:fluid_extractor", "minecraft.fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.FLUID_MIXER), new String[]{"jev:fluid_mixer", "minecraft.fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.WORKSTATION), new String[]{"jev:vehicle"});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFluidExtractor.class, "jev:fluid_extractor", 1, 1, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFluidMixer.class, "jev:fluid_mixer", 1, 1, 2, 36);
        IIngredientBlacklist ingredientBlacklist = jeiHelpers.getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack(ModItems.MODELS));
    }
}

