/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.image.ITooltipProvider;
import net.blay09.mods.chattweaks.image.renderable.ImageLoader;
import net.blay09.mods.twitchintegration.TwitchIntegration;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.gui.GuiTwitchWaitingForUsername;
import net.blay09.mods.twitchintegration.handler.TwitchBadge;
import net.blay09.mods.twitchintegration.handler.TwitchChannel;
import net.blay09.mods.twitchintegration.util.CachedAPI;
import net.blay09.mods.twitchintegration.util.TokenReceiver;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class TwitchAPI {
    public static final String CLIENT_ID = "10napoemcms7qf9j0dxf28ndl2ltc3";
    public static final String OAUTH_REDIRECT_URI = "http://localhost:61324/token/";
    public static final String SCOPES = "chat:read+chat:edit";
    private static final String API_BASE_URL = "https://api.twitch.tv/helix/";
    private static final String TWITCH_AUTHORIZE = "https://id.twitch.tv/oauth2/authorize?response_type=token&client_id={{CLIENT_ID}}&redirect_uri={{REDIRECT_URI}}&scope={{SCOPES}}&force_verify=true";
    private static TokenReceiver tokenReceiver;
    private static Map<String, TwitchBadge> defaultBadges;

    public static int loadChannelId(String name) {
        try {
            JsonObject userObject;
            JsonArray array;
            HttpGet request = new HttpGet("https://api.twitch.tv/helix/users?login=" + name);
            request.addHeader("Client-ID", CLIENT_ID);
            JsonObject object = CachedAPI.loadCachedAPI(request, "twitch_" + name + "_data");
            if (object != null && object.has("data") && (array = object.getAsJsonArray("data")).size() > 0 && (userObject = array.get(0).getAsJsonObject()).has("_id")) {
                return userObject.get("_id").getAsInt();
            }
        }
        catch (Exception e) {
            TwitchIntegration.logger.error("Unexpected error when retrieving channel id for {}: ", (Object)name, (Object)e);
        }
        return -1;
    }

    public static Map<String, TwitchBadge> loadGlobalBadges() {
        HashMap result;
        block6: {
            result = Maps.newHashMap();
            try {
                JsonObject object = CachedAPI.loadCachedAPI("https://badges.twitch.tv/v1/badges/global/display", "twitch_badges");
                if (object == null || !object.has("badge_sets")) break block6;
                JsonObject badgeSets = object.getAsJsonObject("badge_sets");
                for (Map.Entry entry : badgeSets.entrySet()) {
                    String badgeName = (String)entry.getKey();
                    JsonObject badgeObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                    JsonObject badgeVersions = badgeObject.getAsJsonObject("versions");
                    for (Map.Entry version : badgeVersions.entrySet()) {
                        String slashVal = (String)version.getKey();
                        String imageUri = ((JsonElement)version.getValue()).getAsJsonObject().get("image_url_1x").getAsString();
                        TwitchBadge badge = null;
                        try {
                            badge = new TwitchBadge(ImageLoader.loadImage((URI)new URI(imageUri), (String)("twitch_" + badgeName + "_" + slashVal)), (ITooltipProvider)ITooltipProvider.EMPTY);
                        }
                        catch (IOException | URISyntaxException e) {
                            TwitchIntegration.logger.error("Could not load global chat badge {}: ", (Object)badgeName, (Object)e);
                        }
                        result.put(badgeName + "/" + (String)version.getKey(), badge);
                    }
                }
            }
            catch (Exception e) {
                TwitchIntegration.logger.error("Unexpected error when loading global chat badges: ", (Throwable)e);
            }
        }
        return result;
    }

    public static Map<String, TwitchBadge> loadChannelSpecificBadges(TwitchChannel channel) {
        HashMap result;
        block6: {
            result = Maps.newHashMap();
            try {
                JsonObject object = CachedAPI.loadCachedAPI("https://badges.twitch.tv/v1/badges/channels/" + channel.getId() + "/display", "twitch_" + channel.getName() + "_badges");
                if (object == null || !object.has("badge_sets")) break block6;
                JsonObject badgeSets = object.getAsJsonObject("badge_sets");
                for (Map.Entry entry : badgeSets.entrySet()) {
                    String badgeName = (String)entry.getKey();
                    JsonObject badgeObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                    JsonObject badgeVersions = badgeObject.getAsJsonObject("versions");
                    for (Map.Entry version : badgeVersions.entrySet()) {
                        String slashVal = (String)version.getKey();
                        String imageUri = ((JsonElement)version.getValue()).getAsJsonObject().get("image_url_1x").getAsString();
                        TwitchBadge badge = null;
                        try {
                            badge = new TwitchBadge(ImageLoader.loadImage((URI)new URI(imageUri), (String)("twitch_" + channel.getName() + "_" + badgeName + "_" + slashVal)), (ITooltipProvider)ITooltipProvider.EMPTY);
                        }
                        catch (IOException | URISyntaxException e) {
                            TwitchIntegration.logger.error("Could not load chat badge {} for channel {}: ", (Object)badgeName, (Object)channel.getName(), (Object)e);
                        }
                        result.put(badgeName + "/" + (String)version.getKey(), badge);
                    }
                }
            }
            catch (Exception e) {
                TwitchIntegration.logger.error("Unexpected error when loading chat badges for channel {}: ", (Object)channel.getName(), (Object)e);
            }
        }
        return result;
    }

    public static String getAuthenticationURL() {
        return TWITCH_AUTHORIZE.replace("{{CLIENT_ID}}", CLIENT_ID).replace("{{REDIRECT_URI}}", OAUTH_REDIRECT_URI).replace("{{SCOPES}}", SCOPES);
    }

    public static boolean listenForToken(final Runnable callback) {
        if (tokenReceiver == null) {
            tokenReceiver = new TokenReceiver(){

                @Override
                public void onTokenReceived(String token) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTwitchWaitingForUsername());
                        TwitchAPI.requestUsername(token, callback);
                    });
                }
            };
            tokenReceiver.start();
        }
        String uri = TwitchAPI.getAuthenticationURL();
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object desktop = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(desktop, new URI(uri));
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | URISyntaxException e) {
            TwitchIntegration.logger.error("Could not open your browser - please copy the link into your browser manually: {}", (Object)uri);
            return false;
        }
    }

    public static void requestUsername(String token, Runnable callback) {
        new Thread(() -> {
            try {
                Gson gson = new Gson();
                CloseableHttpClient httpClient = HttpClients.createDefault();
                HttpGet request = new HttpGet("https://api.twitch.tv/helix/users");
                request.addHeader("Authorization", "Bearer " + token);
                request.addHeader("Client-ID", CLIENT_ID);
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                String jsonString = EntityUtils.toString((HttpEntity)response.getEntity());
                JsonObject root = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
                String username = root.getAsJsonArray("data").get(0).getAsJsonObject().get("login").getAsString();
                ChatTweaks.getAuthManager().storeToken("twitchintegration", username, token, TwitchIntegrationConfig.doNotStoreToken);
                Minecraft.func_71410_x().func_152344_a(callback);
            }
            catch (Exception e) {
                String exceptionMessage = e.getMessage().replace(token, "<token>");
                TwitchIntegration.logger.error("Failed to retrieve your username from the token. Please try again. {}", (Object)exceptionMessage);
            }
        }).start();
    }

    public static Map<String, TwitchBadge> getDefaultBadges() {
        if (defaultBadges == null) {
            defaultBadges = TwitchAPI.loadGlobalBadges();
        }
        return Maps.newHashMap(defaultBadges);
    }
}

