/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.tmi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.twitchintegration.irc.IRCMessage;
import net.blay09.mods.twitchintegration.irc.IRCUser;
import net.blay09.mods.twitchintegration.tmi.TwitchEmote;
import net.blay09.mods.twitchintegration.tmi.UserType;

public class TwitchUser {
    private final IRCUser user;
    private String[] badges;
    private List<TwitchEmote> emotes;
    private String color;
    private String displayName;
    private int userId;
    private UserType userType;
    private boolean mod;
    private boolean subscriber;
    private int subscribedMonths = 0;
    private int cheeredBits = 0;
    private boolean turbo;

    public TwitchUser(IRCUser user) {
        this.user = user;
    }

    public boolean hasColor() {
        return this.color != null && !this.color.isEmpty();
    }

    public boolean hasEmotes() {
        return this.emotes != null;
    }

    public boolean hasBadges() {
        return this.badges != null;
    }

    public String getDisplayName() {
        return this.displayName != null && !this.displayName.isEmpty() ? this.displayName : this.user.getNick();
    }

    public String getNick() {
        return this.user.getNick();
    }

    public static TwitchUser fromMessage(IRCMessage message) {
        return TwitchUser.parseMessageTags(new TwitchUser(message.parseSender()), message);
    }

    public static TwitchUser fromMessageTags(IRCMessage message, String nick) {
        return TwitchUser.parseMessageTags(new TwitchUser(new IRCUser(nick, null, null)), message);
    }

    private static TwitchUser parseMessageTags(TwitchUser twitchUser, IRCMessage message) {
        String emotesTag;
        String badgesTag = message.getTagByKey("badges");
        if (badgesTag != null) {
            for (String s : twitchUser.badges = badgesTag.split(",")) {
                if (s.startsWith("subscriber")) {
                    twitchUser.subscribedMonths = Integer.parseInt(s.split("/")[1]);
                    continue;
                }
                if (!s.startsWith("bits")) continue;
                twitchUser.cheeredBits = Integer.parseInt(s.split("/")[1]);
            }
        }
        if ((emotesTag = message.getTagByKey("emotes")) != null) {
            String[] emotes;
            for (String emoteData : emotes = emotesTag.split("/")) {
                String[] occurences;
                int colonIdx;
                if (twitchUser.emotes == null) {
                    twitchUser.emotes = new ArrayList<TwitchEmote>();
                }
                if ((colonIdx = emoteData.indexOf(58)) == -1) continue;
                String emoteId = emoteData.substring(0, colonIdx);
                for (String occurenceData : occurences = emoteData.substring(colonIdx + 1).split(",")) {
                    int dashIdx = occurenceData.indexOf(45);
                    if (dashIdx == -1) continue;
                    int start = Integer.parseInt(occurenceData.substring(0, dashIdx));
                    int end = Integer.parseInt(occurenceData.substring(dashIdx + 1));
                    twitchUser.emotes.add(new TwitchEmote(emoteId, start, end));
                }
            }
        }
        twitchUser.color = message.getTagByKey("color");
        twitchUser.displayName = message.getTagByKey("display-name");
        twitchUser.mod = Objects.equals(message.getTagByKey("mod"), "1");
        twitchUser.subscriber = Objects.equals(message.getTagByKey("subscriber"), "1");
        twitchUser.turbo = Objects.equals(message.getTagByKey("turbo"), "1");
        try {
            twitchUser.userId = Integer.parseInt(message.getTagByKey("user-id"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        twitchUser.userType = UserType.fromTag(message.getTagByKey("user-type"));
        return twitchUser;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(boolean subscriber) {
        this.subscriber = subscriber;
    }

    public int getSubscribedMonths() {
        return this.subscribedMonths;
    }

    public void setSubscribedMonths(int subscribedMonths) {
        this.subscribedMonths = subscribedMonths;
    }

    public boolean isTurbo() {
        return this.turbo;
    }

    public boolean isMod() {
        return this.mod;
    }

    public void setMod(boolean mod) {
        this.mod = mod;
    }

    public int getCheeredBits() {
        return this.cheeredBits;
    }

    public void setCheeredBits(int cheeredBits) {
        this.cheeredBits = cheeredBits;
    }

    public void setTurbo(boolean turbo) {
        this.turbo = turbo;
    }

    public List<TwitchEmote> getEmotes() {
        return this.emotes;
    }

    public String[] getBadges() {
        return this.badges;
    }

    public void setBadges(String[] badges) {
        this.badges = badges;
    }
}

