/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.irc;

import java.util.LinkedList;
import net.blay09.mods.twitchintegration.irc.IRCConnection;

public class IRCSender
implements Runnable {
    private final LinkedList<String> queue = new LinkedList();
    private final Thread thread;
    private final IRCConnection connection;
    private int messageDelay;
    private boolean running;

    public IRCSender(IRCConnection connection, int messageDelay) {
        this.connection = connection;
        this.thread = new Thread((Runnable)this, "IRCSender (" + connection.getServer() + ")");
        this.messageDelay = messageDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToSendQueue(String message) {
        LinkedList<String> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(message);
        }
        return true;
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (this.running) {
                    boolean messageSent = false;
                    LinkedList<String> linkedList = this.queue;
                    synchronized (linkedList) {
                        if (!this.queue.isEmpty()) {
                            this.connection.sendRawNow(this.queue.pop());
                            messageSent = true;
                        }
                    }
                    try {
                        Thread.sleep(messageSent ? (long)this.messageDelay : 100L);
                        continue block7;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Exception e) {
                this.connection.unhandledException(e);
                break;
            }
        }
        this.running = false;
    }

    public void stop() {
        try {
            this.running = false;
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

