/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.irc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.blay09.mods.twitchintegration.irc.IRCMessage;

public class IRCParser {
    private final List<String> args = new ArrayList<String>();
    private String data;
    private int idx;

    public IRCMessage parse(String data) {
        String arg;
        String prefix;
        this.reset(data);
        HashMap<String, String> tagMap = null;
        if (data.startsWith("@")) {
            ++this.idx;
            String tags = this.nextToken();
            String[] splitTags = tags.split(";");
            tagMap = new HashMap<String, String>(splitTags.length);
            for (String tagPair : splitTags) {
                int eqIdx = tagPair.indexOf(61);
                if (eqIdx != -1) {
                    String value = tagPair.substring(eqIdx + 1);
                    value = value.replace("\\s", " ");
                    value = value.replace("\\:", ";");
                    value = value.replace("\\n", "\n");
                    value = value.replace("\\r", "\r");
                    value = value.replace("\\\\", "\\");
                    tagMap.put(tagPair.substring(0, eqIdx), value);
                    continue;
                }
                tagMap.put(tagPair, "");
            }
        }
        if (data.startsWith(":", this.idx)) {
            ++this.idx;
            prefix = this.nextToken();
        } else {
            prefix = "";
        }
        String cmd = this.nextToken();
        while ((arg = this.nextToken()) != null) {
            this.args.add(arg);
        }
        return new IRCMessage(tagMap, prefix, cmd, this.args.toArray(new String[0]));
    }

    public void reset(String data) {
        this.data = data;
        this.idx = 0;
        this.args.clear();
    }

    public String nextToken() {
        int nextIdx;
        if (this.idx >= this.data.length() - 1) {
            return null;
        }
        if (this.data.charAt(this.idx) == ':') {
            ++this.idx;
            nextIdx = this.data.length();
        } else {
            nextIdx = this.data.indexOf(32, this.idx);
            if (nextIdx == -1) {
                nextIdx = this.data.length();
            }
        }
        String token = this.data.substring(this.idx, nextIdx);
        this.idx = nextIdx + 1;
        return token;
    }
}

