/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.irc;

import java.util.Arrays;
import java.util.Map;
import net.blay09.mods.twitchintegration.irc.IRCUser;

public class IRCMessage {
    private final Map<String, String> tags;
    private final String[] args;
    private String prefix;
    private String command;

    public IRCMessage(Map<String, String> tags, String prefix, String command, String[] args) {
        this.tags = tags;
        this.prefix = prefix;
        this.command = command;
        this.args = args;
    }

    public int getNumericCommand() {
        try {
            return Integer.parseInt(this.command);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getHostname() {
        int idx = this.prefix.indexOf("@");
        if (idx != -1 && idx + 1 < this.prefix.length()) {
            return this.prefix.substring(idx + 1);
        }
        return null;
    }

    public String getUsername() {
        int start = this.prefix.indexOf(33);
        int end = this.prefix.indexOf(64);
        if (end == -1) {
            end = this.prefix.length() - 1;
        }
        if (start != -1 && start + 1 < this.prefix.length()) {
            return this.prefix.substring(start + 1, end);
        }
        return null;
    }

    public String getNick() {
        int end = this.prefix.indexOf(33);
        if (end != -1) {
            return this.prefix.substring(0, end);
        }
        return this.prefix;
    }

    public IRCUser parseSender() {
        return new IRCUser(this.getNick(), this.getUsername(), this.getHostname());
    }

    public String arg(int idx) {
        if (idx >= this.args.length) {
            return null;
        }
        return this.args[idx];
    }

    public String[] subargs(int idx) {
        return Arrays.copyOfRange(this.args, idx, this.args.length);
    }

    public int argCount() {
        return this.args.length;
    }

    public String getTagByKey(String key) {
        return this.tags != null ? this.tags.get(key) : null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCommand() {
        return this.command;
    }
}

