/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.irc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.blay09.mods.twitchintegration.irc.IRCConfiguration;
import net.blay09.mods.twitchintegration.irc.IRCListener;
import net.blay09.mods.twitchintegration.irc.IRCMessage;
import net.blay09.mods.twitchintegration.irc.IRCParser;
import net.blay09.mods.twitchintegration.irc.IRCSender;
import net.blay09.mods.twitchintegration.irc.NaiveTrustManager;
import net.blay09.mods.twitchintegration.irc.NotConnectedException;
import net.blay09.mods.twitchintegration.irc.snapshot.ChannelSnapshot;
import net.blay09.mods.twitchintegration.irc.snapshot.SnapshotWrapper;
import net.blay09.mods.twitchintegration.irc.snapshot.UserSnapshot;

public class IRCConnection
implements Runnable {
    private static final Logger log = Logger.getLogger(IRCConnection.class.getName());
    private static final String LINE_FEED = "\r\n";
    private final IRCListener listener;
    private final IRCConfiguration configuration;
    private final Thread thread;
    private final IRCParser parser;
    private final IRCSender sender;
    private final Map<String, ChannelSnapshot> channelSnapshots;
    private final Map<String, UserSnapshot> userSnapshots;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private boolean running;
    private boolean connected;
    private String nick;
    private String serverType;
    private String channelTypes = "#&";
    private String channelUserModes = "ov";
    private String channelUserModePrefixes = "@+";

    public IRCConnection(final IRCConfiguration configuration, IRCListener listener) {
        if (configuration.isKeepingSnapshots()) {
            this.channelSnapshots = new HashMap<String, ChannelSnapshot>();
            this.userSnapshots = new HashMap<String, UserSnapshot>();
            this.listener = new SnapshotWrapper(listener, this.channelSnapshots, this.userSnapshots);
        } else {
            this.channelSnapshots = null;
            this.userSnapshots = null;
            this.listener = listener;
        }
        this.configuration = configuration;
        this.nick = configuration.getNick();
        this.parser = new IRCParser();
        this.sender = new IRCSender(this, configuration.getMessageDelay());
        this.thread = new Thread((Runnable)this, "IRCConnection (" + configuration.getServer() + ")");
        log.setUseParentHandlers(false);
        ConsoleHandler logHandler = new ConsoleHandler();
        logHandler.setFormatter(new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord record) {
                return "[" + configuration.getServer() + "] " + record.getMessage() + "\n";
            }
        });
        log.addHandler(logHandler);
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    private boolean connect() {
        try {
            if (this.configuration.isSecure()) {
                try {
                    SSLSocketFactory socketFactory;
                    if (this.configuration.isTrustingSelfSigned()) {
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(null, new TrustManager[]{new NaiveTrustManager()}, null);
                        socketFactory = context.getSocketFactory();
                    } else {
                        socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    }
                    SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(this.configuration.getServer(), this.configuration.getPort());
                    if (this.configuration.getLocalAddress() != null && !this.configuration.getLocalAddress().isEmpty()) {
                        sslSocket.bind(new InetSocketAddress(this.configuration.getLocalAddress(), this.configuration.getPort()));
                    }
                    if (this.configuration.isDiffieHellmanDisabled()) {
                        ArrayList<String> cipherSuites = new ArrayList<String>();
                        for (String suite : sslSocket.getEnabledCipherSuites()) {
                            if (suite.contains("_DHE_")) continue;
                            cipherSuites.add(suite);
                        }
                        sslSocket.setEnabledCipherSuites(cipherSuites.toArray(new String[0]));
                    }
                    sslSocket.startHandshake();
                    this.socket = sslSocket;
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    this.listener.onConnectionFailed(this, e);
                }
            } else {
                InetSocketAddress targetAddr = new InetSocketAddress(this.configuration.getServer(), this.configuration.getPort());
                this.socket = new Socket();
                if (this.configuration.getLocalAddress() != null && !this.configuration.getLocalAddress().isEmpty()) {
                    this.socket.bind(new InetSocketAddress(this.configuration.getLocalAddress(), this.configuration.getPort()));
                }
                this.socket.connect(targetAddr);
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.configuration.getEncoding()));
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.configuration.getEncoding()));
            this.connected = true;
            return true;
        }
        catch (IOException e) {
            this.listener.onConnectionFailed(this, e);
            return false;
        }
    }

    @Override
    public void run() {
        if (!this.connect()) {
            this.running = false;
            return;
        }
        if (this.configuration.getPassword() != null) {
            this.sender.addToSendQueue("PASS " + this.configuration.getPassword());
            if (this.configuration.isDebug()) {
                log.info("> PASS **********");
            }
        }
        this.sendRaw("NICK " + this.nick);
        this.sendRaw("USER " + (this.configuration.getUsername() != null ? this.configuration.getUsername() : this.nick) + " \"\" \"\" " + (this.configuration.getRealName() != null ? this.configuration.getRealName() : this.nick));
        this.sender.start();
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (this.configuration.isDebug()) {
                    log.info("< " + line);
                }
                if (line.isEmpty()) continue;
                this.handleMessage(this.parser.parse(line));
            }
            this.stop();
        }
        catch (IOException e) {
            if (!e.getMessage().equals("Socket closed")) {
                this.unhandledException(e);
            } else {
                this.stop();
            }
        }
        catch (Exception e) {
            this.unhandledException(e);
        }
    }

    private void handleMessage(IRCMessage message) {
        String command;
        if (!this.listener.onRawMessage(this, message)) {
            return;
        }
        int numeric = message.getNumericCommand();
        if (numeric > 0) {
            this.handleMessageNumeric(numeric, message);
            return;
        }
        switch (command = message.getCommand()) {
            case "PING": {
                this.sendRaw("PONG " + message.arg(0));
                break;
            }
            case "NOTICE": {
                if (this.channelTypes.indexOf(message.arg(0).charAt(0)) != -1) {
                    this.listener.onChannelNotice(this, message, message.parseSender(), message.arg(0), message.arg(1));
                    break;
                }
                this.listener.onUserNotice(this, message, message.parseSender(), message.arg(1));
                break;
            }
            case "PRIVMSG": {
                if (this.channelTypes.indexOf(message.arg(0).charAt(0)) != -1) {
                    this.listener.onChannelChat(this, message, message.parseSender(), message.arg(0), message.arg(1));
                    break;
                }
                this.listener.onUserChat(this, message, message.parseSender(), message.arg(1));
                break;
            }
            case "JOIN": {
                this.listener.onUserJoin(this, message, message.parseSender(), message.arg(0));
                break;
            }
            case "PART": {
                this.listener.onUserPart(this, message, message.parseSender(), message.arg(0), message.arg(1));
                break;
            }
            case "TOPIC": {
                this.listener.onChannelTopicChange(this, message, message.parseSender(), message.arg(0), message.arg(1));
                break;
            }
            case "NICK": {
                this.listener.onUserNickChange(this, message, message.parseSender(), message.arg(0));
                break;
            }
            case "QUIT": {
                this.listener.onUserQuit(this, message, message.parseSender(), message.arg(0));
                break;
            }
            case "MODE": {
                if (this.channelTypes.indexOf(message.arg(0).charAt(0)) != -1) {
                    this.listener.onChannelMode(this, message, message.parseSender(), message.arg(0), message.arg(1), message.subargs(2));
                    break;
                }
                this.listener.onUserMode(this, message, message.parseSender(), message.arg(1), message.subargs(2));
            }
        }
    }

    private void handleMessageNumeric(int numeric, IRCMessage message) {
        switch (numeric) {
            case 1: {
                this.listener.onConnected(this);
                for (String capability : this.configuration.getCapabilities()) {
                    this.sendRaw("CAP REQ " + capability);
                }
                for (String channel : this.configuration.getAutoJoinChannels()) {
                    this.join(channel);
                }
                break;
            }
            case 4: {
                this.serverType = message.arg(1);
                break;
            }
            case 5: {
                for (int i = 0; i < message.argCount(); ++i) {
                    if (message.arg(i).startsWith("CHANTYPES=")) {
                        this.channelTypes = message.arg(i).substring(10);
                        continue;
                    }
                    if (!message.arg(i).startsWith("PREFIX=")) continue;
                    String value = message.arg(i).substring(7);
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < value.length(); ++j) {
                        char c = value.charAt(j);
                        if (c == ')') {
                            this.channelUserModes = sb.toString();
                            sb = new StringBuilder();
                            continue;
                        }
                        if (c == '(') continue;
                        sb.append(c);
                    }
                    this.channelUserModePrefixes = sb.toString();
                }
                break;
            }
            case 332: {
                this.listener.onChannelTopic(this, message, message.arg(1), message.arg(2));
            }
        }
    }

    public void quit(String quitMessage) {
        try {
            this.sendRawNow("QUIT :" + quitMessage);
            this.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void nick(String nick) {
        this.sendRaw("NICK " + nick);
    }

    public void join(String channel) {
        this.join(channel, null);
    }

    public void join(String channel, String password) {
        this.sendRaw("JOIN " + channel + (password != null ? " " + password : ""));
    }

    public void part(String channel) {
        this.sendRaw("PART " + channel);
    }

    public void message(String target, String message) {
        this.sendRaw("PRIVMSG " + target + " :" + message);
    }

    public void notice(String target, String message) {
        this.sendRaw("NOTICE " + target + " :" + message);
    }

    public void kick(String channel, String user, String reason) {
        this.sendRaw("KICK " + channel + " " + user + (reason != null ? ":" + reason : ""));
    }

    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.connected) {
            this.connected = false;
            this.listener.onDisconnected(this);
        }
        this.running = false;
    }

    public void sendRaw(String line) {
        if (this.configuration.isDebug()) {
            log.info("> " + line);
        }
        this.sender.addToSendQueue(line);
    }

    public void sendRawNow(String line) throws IOException {
        if (this.writer == null) {
            throw new NotConnectedException("Attempted to send message while not connected to IRC server.");
        }
        this.writer.write(line);
        this.writer.write(LINE_FEED);
        this.writer.flush();
    }

    public void unhandledException(Exception e) {
        this.listener.onUnhandledException(this, e);
        this.stop();
    }

    public String getServer() {
        return this.configuration.getServer();
    }

    public String getNick() {
        return this.nick;
    }

    public String getChannelUserModePrefixes() {
        return this.channelUserModePrefixes;
    }

    public String getChannelUserModes() {
        return this.channelUserModes;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getServerType() {
        return this.serverType;
    }

    public UserSnapshot getUserSnapshot(String name) {
        return this.userSnapshots.get(name.toLowerCase());
    }

    public ChannelSnapshot getChannelSnapshot(String name) {
        return this.channelSnapshots.get(name.toLowerCase());
    }
}

