/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.auth.TokenPair;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.twitchintegration.TwitchIntegration;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.handler.TwitchChannel;
import net.blay09.mods.twitchintegration.irc.IRCConfiguration;
import net.blay09.mods.twitchintegration.tmi.TMIClient;

public class TwitchManager {
    private final File configFile;
    private final Map<String, TwitchChannel> channels = Maps.newHashMap();
    private final List<TwitchChannel> activeChannels = Lists.newArrayList();
    private TMIClient twitchClient;

    public TwitchManager(File configFile) {
        this.configFile = configFile;
        this.loadChannels();
    }

    public void addChannel(TwitchChannel channel) {
        this.channels.put(channel.getName().toLowerCase(Locale.ENGLISH), channel);
        channel.loadChannelBadges();
        TwitchIntegration.loadChannelEmotes(channel);
    }

    public Collection<TwitchChannel> getChannels() {
        return this.channels.values();
    }

    @Nullable
    public TMIClient getClient() {
        return this.twitchClient;
    }

    public void connect() {
        TwitchChannel[] defaultChannels;
        TokenPair tokenPair = ChatTweaks.getAuthManager().getToken("twitchintegration");
        if (tokenPair != null && !this.channels.containsKey(tokenPair.getUsername().toLowerCase(Locale.ENGLISH)) && (defaultChannels = this.createDefaults()).length > 0) {
            TwitchChannel channel = defaultChannels[0];
            this.channels.put(channel.getName().toLowerCase(Locale.ENGLISH), channel);
            this.saveChannels();
            channel.createOrUpdateChatChannel();
            channel.createDefaultView();
        }
        if (tokenPair != null || TwitchIntegrationConfig.useAnonymousLogin) {
            IRCConfiguration config = TMIClient.defaultConfig();
            config.setEncoding(StandardCharsets.UTF_8);
            if (tokenPair != null && !TwitchIntegrationConfig.useAnonymousLogin) {
                String token = tokenPair.getToken().startsWith("oauth:") ? tokenPair.getToken() : "oauth:" + tokenPair.getToken();
                config.setNick(tokenPair.getUsername());
                config.setPassword(token);
            } else {
                config.setNick(TwitchManager.getAnonymousUsername());
            }
            config.setPort(TwitchIntegrationConfig.port);
            for (TwitchChannel channel : this.channels.values()) {
                if (!channel.isActive()) continue;
                config.getAutoJoinChannels().add("#" + channel.getName().toLowerCase(Locale.ENGLISH));
                this.activeChannels.add(channel);
            }
            this.twitchClient = new TMIClient(config, TwitchIntegration.getTwitchChatHandler());
            this.twitchClient.connect();
        }
    }

    private static String getAnonymousUsername() {
        return "justinfan" + (int)Math.floor(Math.random() * 80000.0 + 1000.0);
    }

    public void disconnect() {
        if (this.twitchClient != null) {
            this.twitchClient.disconnect();
            this.activeChannels.clear();
            this.twitchClient = null;
        }
    }

    public boolean isConnected() {
        return this.twitchClient != null && this.twitchClient.getIRCConnection().isConnected();
    }

    public void updateChannelStates() {
        for (TwitchChannel channel : this.activeChannels) {
            if (this.channels.containsKey(channel.getName().toLowerCase(Locale.ENGLISH))) continue;
            ChatView chatView = ChatViewManager.getChatView((String)channel.getName());
            if (chatView != null && chatView.getChannels().size() == 1 && chatView.getChannels().contains(channel.getChatChannel())) {
                ChatViewManager.removeChatView((ChatView)chatView);
                ChatViewManager.save();
            }
            if (this.twitchClient == null) continue;
            this.twitchClient.part("#" + channel.getName().toLowerCase(Locale.ENGLISH));
        }
        this.activeChannels.clear();
        for (TwitchChannel channel : this.channels.values()) {
            if (channel.isActive()) {
                this.activeChannels.add(channel);
                if (this.twitchClient == null) continue;
                this.twitchClient.join("#" + channel.getName().toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (this.twitchClient == null) continue;
            this.twitchClient.part("#" + channel.getName().toLowerCase(Locale.ENGLISH));
        }
    }

    @Nullable
    public TwitchChannel getTwitchChannel(String channel) {
        return this.channels.get(channel.charAt(0) == '#' ? channel.substring(1).toLowerCase(Locale.ENGLISH) : channel.toLowerCase(Locale.ENGLISH));
    }

    public void removeTwitchChannel(TwitchChannel channel) {
        if (channel.getChatChannel() != null) {
            ChatManager.removeChatChannel((String)channel.getChatChannel().getName());
        }
        this.channels.remove(channel.getName().toLowerCase(Locale.ENGLISH));
        if (this.activeChannels.remove(channel) && this.twitchClient != null) {
            this.twitchClient.part("#" + channel.getName().toLowerCase(Locale.ENGLISH));
        }
    }

    public void loadChannels() {
        Gson gson = new Gson();
        try (InputStreamReader reader2 = new InputStreamReader((InputStream)new FileInputStream(this.configFile), StandardCharsets.UTF_8);){
            JsonObject root = (JsonObject)gson.fromJson((Reader)reader2, JsonObject.class);
            JsonArray channels = root.getAsJsonArray("channels");
            for (JsonElement element : channels) {
                JsonObject obj = element.getAsJsonObject();
                TwitchChannel channel = TwitchChannel.fromJson(obj);
                channel.createOrUpdateChatChannel();
                this.addChannel(channel);
            }
        }
        catch (FileNotFoundException reader2) {
        }
        catch (Exception e) {
            TwitchIntegration.logger.error("Could not load Twitch channel configurations: ", (Throwable)e);
        }
    }

    public void saveChannels() {
        JsonObject root = new JsonObject();
        JsonArray channels = new JsonArray();
        for (TwitchChannel channel : this.channels.values()) {
            channels.add((JsonElement)channel.toJson());
        }
        root.add("channels", (JsonElement)channels);
        Gson gson = new Gson();
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), StandardCharsets.UTF_8));){
            writer.setIndent("  ");
            gson.toJson((JsonElement)root, writer);
        }
        catch (IOException e) {
            TwitchIntegration.logger.error("Could not save Twitch channel configurations: ", (Throwable)e);
        }
    }

    public TwitchChannel[] createDefaults() {
        TokenPair tokenPair = ChatTweaks.getAuthManager().getToken("twitchintegration");
        if (tokenPair != null) {
            TwitchChannel defaultChannel = new TwitchChannel(tokenPair.getUsername());
            defaultChannel.setActive(true);
            return new TwitchChannel[]{defaultChannel};
        }
        return new TwitchChannel[0];
    }

    public void removeAllChannels() {
        this.channels.clear();
    }

    public void renameTwitchChannel(TwitchChannel twitchChannel, String newName) {
        this.removeTwitchChannel(twitchChannel);
        twitchChannel.setName(newName);
        this.addChannel(twitchChannel);
    }
}

