/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.handler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.chat.ChatMessage;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.chat.emotes.EmoteScanner;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteScanner;
import net.blay09.mods.chattweaks.chat.emotes.PositionedEmote;
import net.blay09.mods.chattweaks.chat.emotes.twitch.TwitchChannelEmoteSource;
import net.blay09.mods.chattweaks.chat.emotes.twitch.TwitchEmotesAPI;
import net.blay09.mods.chattweaks.chat.emotes.twitch.TwitchGlobalEmoteSource;
import net.blay09.mods.chattweaks.image.ChatImage;
import net.blay09.mods.chattweaks.image.ChatImageDefault;
import net.blay09.mods.chattweaks.image.ChatImageEmote;
import net.blay09.mods.twitchintegration.TwitchIntegration;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.handler.TwitchBadge;
import net.blay09.mods.twitchintegration.handler.TwitchChannel;
import net.blay09.mods.twitchintegration.handler.TwitchManager;
import net.blay09.mods.twitchintegration.irc.IRCUser;
import net.blay09.mods.twitchintegration.tmi.TMIAdapter;
import net.blay09.mods.twitchintegration.tmi.TMIClient;
import net.blay09.mods.twitchintegration.tmi.TwitchEmote;
import net.blay09.mods.twitchintegration.tmi.TwitchMessage;
import net.blay09.mods.twitchintegration.tmi.TwitchUser;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;

public class TwitchChatHandler
extends TMIAdapter {
    private static final Pattern PATTERN_FORMAT = Pattern.compile("(?<=%[ucmr])|(?=%[ucmr])");
    private final TwitchManager twitchManager;
    private final Comparator<PositionedEmote> emoteComparator = Comparator.comparingInt(PositionedEmote::getStart);
    private final Predicate<IEmote> noTwitchEmotes = input -> !(input.getSource() instanceof TwitchGlobalEmoteSource) && !(input.getSource() instanceof TwitchChannelEmoteSource);
    private final IEmoteScanner emoteScanner = new EmoteScanner();
    private final Multimap<ChannelUser, ChatMessage> messages = ArrayListMultimap.create();
    private final Map<String, TwitchUser> users = Maps.newHashMap();
    private Map<String, TwitchUser> thisUsers = Maps.newHashMap();
    private final List<ChatImage> tmpBadges = Lists.newArrayList();
    private final List<ChatImage> tmpEmotes = Lists.newArrayList();
    private final List<String> tmpBadgeNames = Lists.newArrayList();
    private final float[] tmpHSB = new float[3];

    public TwitchChatHandler(TwitchManager twitchManager) {
        this.twitchManager = twitchManager;
    }

    @Override
    public void onUserState(TMIClient client, String channel, TwitchUser user) {
        this.thisUsers.put(channel, user);
    }

    @Override
    public void onChatMessage(TMIClient client, String channel, TwitchUser user, TwitchMessage message) {
        this.onTwitchChat(client, channel, user, message);
    }

    public void onTwitchChat(TMIClient client, String channel, TwitchUser user, TwitchMessage twitchMessage) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            List emoteList;
            TwitchChannel twitchChannel = this.twitchManager.getTwitchChannel(channel);
            if (twitchChannel != null && twitchChannel.isSubscribersOnly() && !user.isSubscriber() && !user.isMod()) {
                return;
            }
            if (Arrays.stream(TwitchIntegrationConfig.userBlacklist).anyMatch(it -> user.getNick().equalsIgnoreCase((String)it))) {
                return;
            }
            if (twitchChannel != null && twitchChannel.getId() == -1 && twitchMessage.getChannelId() != -1) {
                twitchChannel.setId(twitchMessage.getChannelId());
            }
            boolean isSelf = user.getNick().equals(client.getIRCConnection().getNick());
            this.tmpEmotes.clear();
            List list = emoteList = isSelf && !user.hasEmotes() ? this.emoteScanner.scanForEmotes(twitchMessage.getMessage(), null) : this.emoteScanner.scanForEmotes(twitchMessage.getMessage(), this.noTwitchEmotes);
            if (user.hasEmotes()) {
                for (TwitchEmote twitchEmote : user.getEmotes()) {
                    IEmote emote = TwitchEmotesAPI.getEmoteById((String)twitchEmote.getId());
                    if (emote == null) continue;
                    emoteList.add(new PositionedEmote(emote, twitchEmote.getStart(), twitchEmote.getEnd()));
                }
            }
            emoteList.sort(this.emoteComparator);
            int index = 0;
            StringBuilder sb = new StringBuilder();
            for (PositionedEmote emoteData : emoteList) {
                if (index < emoteData.getStart()) {
                    sb.append(twitchMessage.getMessage().substring(index, emoteData.getStart())).append(' ');
                }
                int imageIndex = sb.length() + 1;
                sb.append("\u00a7*");
                for (int i = 0; i < emoteData.getEmote().getWidthInSpaces(); ++i) {
                    sb.append(' ');
                }
                this.tmpEmotes.add((ChatImage)new ChatImageEmote(imageIndex, emoteData.getEmote()));
                index = emoteData.getEnd() + 1;
            }
            if (index < twitchMessage.getMessage().length()) {
                sb.append(twitchMessage.getMessage().substring(index));
            }
            String message = sb.toString();
            this.tmpBadges.clear();
            int badgeIndex = 0;
            if (isSelf && !user.hasBadges()) {
                this.tmpBadgeNames.clear();
                if (channel.equals("#" + user.getNick())) {
                    this.tmpBadgeNames.add("broadcaster");
                } else if (user.isMod()) {
                    this.tmpBadgeNames.add("moderator");
                }
                if (user.isTurbo()) {
                    this.tmpBadgeNames.add("turbo");
                }
                if (user.isSubscriber()) {
                    this.tmpBadgeNames.add("subscriber/" + user.getSubscribedMonths());
                }
                if (user.getCheeredBits() > 0) {
                    this.tmpBadgeNames.add("bits/" + user.getCheeredBits());
                }
                user.setBadges(this.tmpBadgeNames.toArray(new String[this.tmpBadgeNames.size()]));
            }
            if (twitchChannel != null && user.hasBadges() && !TwitchIntegrationConfig.disableNameBadges) {
                for (String badgeName : user.getBadges()) {
                    TwitchBadge badge;
                    int slash = badgeName.indexOf(47);
                    int version = 1;
                    if (slash != -1) {
                        version = Integer.parseInt(badgeName.substring(slash + 1, badgeName.length()));
                        badgeName = badgeName.substring(0, slash);
                    }
                    if ((badge = twitchChannel.getBadge(badgeName, version)) == null) continue;
                    ChatImageDefault image = new ChatImageDefault(badgeIndex, badge.getChatRenderable(), badge.getTooltipProvider());
                    badgeIndex += image.getSpaces();
                    this.tmpBadges.add((ChatImage)image);
                }
            }
            ChatChannel targetChannel = twitchChannel != null ? twitchChannel.getChatChannel() : null;
            ITextComponent senderComponent = TwitchChatHandler.formatSenderComponent(user, this.tmpBadges);
            ITextComponent messageComponent = TwitchChatHandler.formatMessageComponent(message, twitchMessage.isAction());
            ITextComponent textComponent = TwitchChatHandler.formatComponent(senderComponent, messageComponent, twitchMessage.isAction());
            ChatMessage chatMessage = ChatTweaks.createChatMessage((ITextComponent)textComponent);
            chatMessage.setSender(senderComponent);
            chatMessage.setMessage(messageComponent);
            chatMessage.setOutputVar("c", TwitchChatHandler.formatChannelComponent(channel));
            chatMessage.withRGB(twitchMessage.isAction() ? 2 : 1);
            for (ChatImage chatImage : this.tmpBadges) {
                chatMessage.addImage(chatImage);
            }
            for (ChatImage chatImage : this.tmpEmotes) {
                chatMessage.addImage(chatImage);
            }
            if (user.hasColor() && !TwitchIntegrationConfig.disableUserColors) {
                int nameColor = ChatTweaks.colorFromHex((String)user.getColor());
                chatMessage.setRGBColor(0, this.getAcceptableNameColor(nameColor));
            } else {
                chatMessage.setRGBColor(0, 0x808080);
            }
            if (twitchMessage.isAction()) {
                if (user.hasColor() && !TwitchIntegrationConfig.disableUserColors) {
                    int nameColor = ChatTweaks.colorFromHex((String)user.getColor());
                    chatMessage.setRGBColor(1, this.getAcceptableNameColor(nameColor));
                } else {
                    chatMessage.setRGBColor(1, 0x808080);
                }
            }
            this.messages.put((Object)new ChannelUser(channel, user.getNick().toLowerCase(Locale.ENGLISH)), (Object)chatMessage);
            this.users.put(user.getNick().toLowerCase(Locale.ENGLISH), user);
            ChatTweaks.addChatMessage((ChatMessage)chatMessage, (ChatChannel)targetChannel);
        });
    }

    @Override
    public void onSubscribe(TMIClient client, String channel, String username, boolean prime) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            TwitchChannel twitchChannel = this.twitchManager.getTwitchChannel(channel);
            ChatTweaks.addChatMessage((ITextComponent)new TextComponentTranslation("twitchintegration" + (prime ? ":chat.subscribePrime" : ":chat.subscribe"), new Object[]{username}), (ChatChannel)(twitchChannel != null ? twitchChannel.getChatChannel() : null));
        });
    }

    @Override
    public void onResubscribe(TMIClient client, String channel, TwitchUser user, int months, String message) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            TwitchChannel twitchChannel = this.twitchManager.getTwitchChannel(channel);
            ChatTweaks.addChatMessage((ITextComponent)new TextComponentTranslation("twitchintegration:chat.resubscribe", new Object[]{user.getDisplayName(), months}), (ChatChannel)(twitchChannel != null ? twitchChannel.getChatChannel() : null));
        });
        if (message != null) {
            this.onTwitchChat(client, channel, user, new TwitchMessage(message, -1, false, 0));
        }
    }

    @Override
    public void onWhisperMessage(TMIClient client, TwitchUser user, String message) {
        this.onWhisperMessage(client, user, this.getThisUser(client, null), message);
    }

    public void onWhisperMessage(TMIClient client, TwitchUser user, TwitchUser receiver, String message) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (TwitchIntegrationConfig.showWhispers) {
                ChatView whisperView;
                boolean isAction;
                List emoteList;
                boolean isSelf = user.getNick().equals(client.getIRCConnection().getNick());
                this.tmpEmotes.clear();
                List list = emoteList = isSelf && !user.hasEmotes() ? this.emoteScanner.scanForEmotes(message, null) : this.emoteScanner.scanForEmotes(message, this.noTwitchEmotes);
                if (user.hasEmotes()) {
                    for (TwitchEmote twitchEmote : user.getEmotes()) {
                        IEmote emote = TwitchEmotesAPI.getEmoteById((String)twitchEmote.getId());
                        if (emote == null) continue;
                        emoteList.add(new PositionedEmote(emote, twitchEmote.getStart(), twitchEmote.getEnd()));
                    }
                }
                emoteList.sort(this.emoteComparator);
                int index = 0;
                StringBuilder sb = new StringBuilder();
                for (PositionedEmote emoteData : emoteList) {
                    if (index < emoteData.getStart()) {
                        sb.append(message.substring(index, emoteData.getStart()));
                    }
                    int imageIndex = sb.length() + 1;
                    sb.append("\u00a7*");
                    for (int i = 0; i < emoteData.getEmote().getWidthInSpaces(); ++i) {
                        sb.append(' ');
                    }
                    this.tmpEmotes.add((ChatImage)new ChatImageEmote(imageIndex, emoteData.getEmote()));
                    index = emoteData.getEnd() + 1;
                }
                if (index < message.length()) {
                    sb.append(message.substring(index));
                }
                String transformedMessage = sb.toString();
                ChatChannel whisperChannel = ChatManager.getTemporaryChannel((String)("(" + (isSelf ? receiver.getDisplayName() : user.getDisplayName()) + ")"));
                boolean bl = isAction = transformedMessage.startsWith("/me ") && transformedMessage.length() > 4;
                if (isAction) {
                    transformedMessage = transformedMessage.substring(4);
                }
                ITextComponent senderComponent = TwitchChatHandler.formatSenderComponent(user, this.tmpBadges);
                ITextComponent messageComponent = TwitchChatHandler.formatMessageComponent(transformedMessage, isAction);
                ITextComponent textComponent = TwitchChatHandler.formatComponent(senderComponent, messageComponent, isAction);
                ChatMessage chatMessage = ChatTweaks.createChatMessage((ITextComponent)textComponent);
                chatMessage.setSender(senderComponent);
                chatMessage.setMessage(messageComponent);
                chatMessage.setOutputVar("r", TwitchChatHandler.formatSenderComponent(receiver, null));
                chatMessage.withRGB(isAction ? 2 : 1);
                for (ChatImage chatImage : this.tmpEmotes) {
                    chatMessage.addImage(chatImage);
                }
                if (user.hasColor() && !TwitchIntegrationConfig.disableUserColors) {
                    int nameColor = ChatTweaks.colorFromHex((String)user.getColor());
                    chatMessage.setRGBColor(0, this.getAcceptableNameColor(nameColor));
                } else {
                    chatMessage.setRGBColor(0, 0x808080);
                }
                if (isAction) {
                    if (user.hasColor() && !TwitchIntegrationConfig.disableUserColors) {
                        int nameColor = ChatTweaks.colorFromHex((String)user.getColor());
                        chatMessage.setRGBColor(1, this.getAcceptableNameColor(nameColor));
                    } else {
                        chatMessage.setRGBColor(1, 0x808080);
                    }
                }
                if ((whisperView = ChatViewManager.getChatView((String)whisperChannel.getName())) == null) {
                    whisperView = new ChatView(whisperChannel.getName());
                    whisperView.addChannel(whisperChannel);
                    whisperView.setOutgoingPrefix("/twitch " + (isSelf ? receiver.getNick().toLowerCase(Locale.ENGLISH) : user.getNick().toLowerCase(Locale.ENGLISH)) + " ");
                    whisperView.setTemporary(true);
                    ChatViewManager.addChatView((ChatView)whisperView);
                }
                this.users.put(user.getNick().toLowerCase(Locale.ENGLISH), user);
                ChatTweaks.addChatMessage((ChatMessage)chatMessage, (ChatChannel)whisperChannel);
            }
        });
    }

    @Override
    public void onTimeout(TMIClient client, String channel, String username) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            TwitchChannel twitchChannel = this.twitchManager.getTwitchChannel(channel);
            if (twitchChannel != null) {
                switch (twitchChannel.getDeletedMessages()) {
                    case Hide: {
                        for (ChatMessage message : this.messages.get((Object)new ChannelUser(channel, username))) {
                            ChatManager.removeChatLine((int)message.getId());
                        }
                        ChatTweaks.refreshChat();
                        break;
                    }
                    case Strikethrough: {
                        for (ChatMessage message : this.messages.get((Object)new ChannelUser(channel, username))) {
                            message.getTextComponent().func_150256_b().func_150225_c(Boolean.valueOf(true));
                        }
                        ChatTweaks.refreshChat();
                        break;
                    }
                    case Replace: {
                        for (ChatMessage message : this.messages.get((Object)new ChannelUser(channel, username))) {
                            TextComponentString removedMessageComponent = new TextComponentString("<message deleted>");
                            removedMessageComponent.func_150256_b().func_150238_a(TextFormatting.GRAY);
                            message.setMessage((ITextComponent)removedMessageComponent);
                            message.setTextComponent(TwitchChatHandler.formatComponent(message.getSender(), (ITextComponent)removedMessageComponent, false));
                            message.clearImages();
                        }
                        ChatTweaks.refreshChat();
                    }
                }
            }
        });
    }

    @Override
    public void onClearChat(TMIClient client, String channel) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            for (ChatMessage message : this.messages.values()) {
                ChatManager.removeChatLine((int)message.getId());
            }
            ChatTweaks.refreshChat();
        });
    }

    @Override
    public void onUnhandledException(TMIClient client, Exception e) {
        TwitchIntegration.logger.error("Unhandled exception: ", (Throwable)e);
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Twitch Integration encountered an unhandled exception. The connection has been terminated. Please review your log files and let the mod developer know."), false);
            }
        });
        this.twitchManager.disconnect();
    }

    @Nullable
    public static ITextComponent formatSenderComponent(@Nullable TwitchUser user, @Nullable List<ChatImage> nameBadges) {
        if (user == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (nameBadges != null) {
            for (ChatImage chatImage : nameBadges) {
                sb.append("\u00a7*");
                for (int i = 0; i < chatImage.getSpaces(); ++i) {
                    sb.append(' ');
                }
            }
        }
        return new TextComponentString(sb.toString() + "\u00a7#" + user.getDisplayName() + "\u00a7#");
    }

    public static ITextComponent formatMessageComponent(String message, boolean isAction) {
        message = TextFormatting.func_110646_a((String)message);
        assert (message != null);
        return ForgeHooks.newChatWithLinks((String)message);
    }

    @Nullable
    public static ITextComponent formatChannelComponent(@Nullable String channel) {
        return channel != null ? new TextComponentString(channel) : null;
    }

    public static ITextComponent formatComponent(ITextComponent senderComponent, ITextComponent messageComponent, boolean isAction) {
        TextComponentString textComponent = new TextComponentString("");
        textComponent.func_150257_a(senderComponent);
        textComponent.func_150258_a(isAction ? " " : ": ");
        textComponent.func_150257_a(messageComponent);
        return textComponent;
    }

    public TwitchUser getThisUser(TMIClient client, String channel) {
        if (channel == null) {
            String string = channel = !this.thisUsers.isEmpty() ? this.thisUsers.keySet().iterator().next() : "";
        }
        if (!this.thisUsers.containsKey(channel)) {
            this.thisUsers.put(channel, new TwitchUser(new IRCUser(client.getIRCConnection().getNick(), null, null)));
        }
        return this.thisUsers.get(channel);
    }

    public TwitchUser getUser(String username) {
        return this.users.computeIfAbsent(username.toLowerCase(Locale.ENGLISH), k -> new TwitchUser(new IRCUser(username, null, null)));
    }

    public int getAcceptableNameColor(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Color.RGBtoHSB(red, green, blue, this.tmpHSB);
        float brightness = this.tmpHSB[2];
        if (brightness < 0.4f) {
            brightness = 0.4f;
        }
        return Color.HSBtoRGB(this.tmpHSB[0], this.tmpHSB[1], brightness);
    }

    private static class ChannelUser {
        private final String channel;
        private final String username;

        public ChannelUser(String channel, String username) {
            this.channel = channel;
            this.username = username;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChannelUser that = (ChannelUser)o;
            return this.channel.equals(that.channel) && this.username.equals(that.username);
        }

        public int hashCode() {
            int result = this.channel.hashCode();
            result = 31 * result + this.username.hashCode();
            return result;
        }
    }
}

