/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.handler;

import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.twitchintegration.handler.TwitchBadge;
import net.blay09.mods.twitchintegration.util.TwitchAPI;
import net.minecraft.util.ResourceLocation;

public class TwitchChannel {
    private String name;
    private ChatChannel chatChannel;
    private boolean subscribersOnly;
    private DeletedMessages deletedMessages = DeletedMessages.Replace;
    private boolean active = true;
    private int id = -1;
    private Map<String, TwitchBadge> badges;

    public TwitchChannel(String name) {
        this.name = name;
    }

    public void createOrUpdateChatChannel() {
        if (this.chatChannel != null && !this.chatChannel.getName().equalsIgnoreCase(this.name)) {
            ChatManager.removeChatChannel((String)this.chatChannel.getName());
        }
        this.chatChannel = ChatManager.getChatChannel((String)this.name);
        if (this.chatChannel == null) {
            this.chatChannel = new ChatChannel(this.name, "Twitch Chat for '" + this.name + "'", new ResourceLocation("twitchintegration", "icon.png"));
            ChatManager.addChatChannel((ChatChannel)this.chatChannel);
        }
    }

    public void setName(String name) {
        this.name = name;
        this.createOrUpdateChatChannel();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSubscribersOnly() {
        return this.subscribersOnly;
    }

    public void setSubscribersOnly(boolean subscribersOnly) {
        this.subscribersOnly = subscribersOnly;
    }

    public DeletedMessages getDeletedMessages() {
        return this.deletedMessages;
    }

    public void setDeletedMessages(DeletedMessages deletedMessages) {
        this.deletedMessages = deletedMessages;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.chatChannel != null) {
            this.chatChannel.setEnabled(active);
        }
    }

    @Nullable
    public ChatChannel getChatChannel() {
        return this.chatChannel;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", this.name);
        obj.addProperty("subscribersOnly", Boolean.valueOf(this.subscribersOnly));
        obj.addProperty("channelId", (Number)this.id);
        obj.addProperty("deletedMessages", this.deletedMessages.name());
        obj.addProperty("active", Boolean.valueOf(this.active));
        return obj;
    }

    public static TwitchChannel fromJson(JsonObject obj) {
        TwitchChannel channel = new TwitchChannel(obj.get("name").getAsString());
        channel.subscribersOnly = obj.has("subscribersOnly") && obj.get("subscribersOnly").getAsBoolean();
        channel.id = obj.has("channelId") ? obj.get("channelId").getAsInt() : -1;
        channel.deletedMessages = DeletedMessages.fromName(obj.get("deletedMessages").getAsString());
        channel.active = obj.has("active") && obj.get("active").getAsBoolean();
        return channel;
    }

    public void loadChannelBadges() {
        if (this.badges == null) {
            new Thread(() -> {
                if (this.id == -1) {
                    this.id = TwitchAPI.loadChannelId(this.name);
                    if (this.id == -1) {
                        return;
                    }
                }
                Map<String, TwitchBadge> badges = TwitchAPI.getDefaultBadges();
                badges.putAll(TwitchAPI.loadChannelSpecificBadges(this));
                this.badges = badges;
            }).start();
        }
    }

    @Nullable
    public TwitchBadge getBadge(String key, int version) {
        if (this.badges == null) {
            return null;
        }
        TwitchBadge badge = this.badges.get(key + "/" + version);
        if (badge == null) {
            badge = this.badges.get(key);
        }
        return badge;
    }

    public void createDefaultView() {
        if (this.chatChannel != null) {
            ChatView twitchView = new ChatView(this.name);
            twitchView.addChannel(this.chatChannel);
            twitchView.setOutgoingPrefix("/twitch #" + this.name.toLowerCase(Locale.ENGLISH) + " ");
            ChatViewManager.addChatView((ChatView)twitchView);
            ChatViewManager.save();
        }
    }

    public static enum DeletedMessages {
        Show,
        Strikethrough,
        Replace,
        Hide;


        public static DeletedMessages fromName(String name) {
            try {
                return DeletedMessages.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return Replace;
            }
        }
    }
}

