/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.twitchintegration.TwitchIntegration;
import net.blay09.mods.twitchintegration.gui.SmartyConfigElement;
import net.blay09.mods.twitchintegration.handler.TwitchChannel;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiTwitchChannel
extends GuiConfig {
    private final boolean isNew;
    private final TwitchChannel twitchChannel;
    private static SmartyConfigElement nameElement;
    private static SmartyConfigElement subscribersOnlyElement;
    private static SmartyConfigElement deletedMessagesElement;
    private static SmartyConfigElement activeElement;

    public GuiTwitchChannel(GuiScreen parentScreen, TwitchChannel twitchChannel, boolean isNew) {
        super(parentScreen, GuiTwitchChannel.getConfigElements(twitchChannel), "chattweaks", "config", false, false, "Twitch Channel Configuration");
        this.twitchChannel = twitchChannel;
        this.isNew = isNew;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            this.entryList.saveConfigElements();
            if (!this.twitchChannel.getName().equalsIgnoreCase((String)nameElement.get())) {
                TwitchIntegration.getTwitchManager().renameTwitchChannel(this.twitchChannel, (String)nameElement.get());
            }
            this.twitchChannel.setSubscribersOnly((Boolean)subscribersOnlyElement.get());
            this.twitchChannel.setDeletedMessages(TwitchChannel.DeletedMessages.valueOf((String)deletedMessagesElement.get()));
            this.twitchChannel.setActive((Boolean)activeElement.get());
            TwitchIntegration.getTwitchManager().saveChannels();
            ChatView chatView = ChatViewManager.getChatView((String)this.twitchChannel.getName());
            if (this.isNew && chatView == null) {
                this.twitchChannel.createDefaultView();
            }
            this.field_146297_k.func_147108_a(this.parentScreen);
            return;
        }
        super.func_146284_a(button);
    }

    private static List<IConfigElement> getConfigElements(TwitchChannel twitchChannel) {
        ArrayList list = Lists.newArrayList();
        nameElement = new SmartyConfigElement("Name", twitchChannel.getName(), ConfigGuiType.STRING, "twitchintegration.config.channel.name");
        list.add(nameElement);
        TwitchChannel.DeletedMessages[] deletedMessages = TwitchChannel.DeletedMessages.values();
        String[] deletedMessagesNames = new String[deletedMessages.length];
        for (int i = 0; i < deletedMessages.length; ++i) {
            deletedMessagesNames[i] = deletedMessages[i].name();
        }
        deletedMessagesElement = new SmartyConfigElement("Deleted Messages", (Object)"Replace", ConfigGuiType.STRING, "twitchintegration.config.channel.deleted_messages", deletedMessagesNames);
        deletedMessagesElement.set(twitchChannel.getDeletedMessages().name());
        list.add(deletedMessagesElement);
        subscribersOnlyElement = new SmartyConfigElement("Subscribers only", false, ConfigGuiType.BOOLEAN, "twitchintegration.config.channel.subscribers_only");
        subscribersOnlyElement.set(twitchChannel.isSubscribersOnly());
        list.add(subscribersOnlyElement);
        activeElement = new SmartyConfigElement("Active", true, ConfigGuiType.BOOLEAN, "twitchintegration.config.channel.active");
        activeElement.set(twitchChannel.isActive());
        list.add(activeElement);
        return list;
    }
}

