/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.twitchintegration.TwitchIntegration;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.gui.GuiTwitchAuthentication;
import net.blay09.mods.twitchintegration.gui.GuiTwitchChannelsConfig;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ConfigGUI
extends GuiConfig {
    public ConfigGUI(GuiScreen parentScreen) {
        super(parentScreen, ConfigGUI.collectConfigElements(), "twitchintegration", "config", false, false, "Twitch Integration");
    }

    private static List<IConfigElement> collectConfigElements() {
        ArrayList list = Lists.newArrayList();
        boolean isAuthenticated = ChatTweaks.getAuthManager().getToken("twitchintegration") != null;
        boolean isConnected = TwitchIntegration.getTwitchManager().isConnected();
        String connectLangKey = isConnected ? "twitchintegration.config.disconnect" : "twitchintegration.config.connect";
        list.add(new DummyConfigElement.DummyCategoryElement(connectLangKey, connectLangKey, ConfigEntryConnect.class));
        String authLangKey = isAuthenticated ? "twitchintegration.config.edit_authentication" : "twitchintegration.config.authenticate";
        list.add(new DummyConfigElement.DummyCategoryElement(authLangKey, authLangKey, ConfigEntryAuthenticate.class));
        list.add(GuiTwitchChannelsConfig.getDummyElement());
        list.addAll(ConfigElement.from(TwitchIntegrationConfig.class).getChildElements());
        list.removeIf(p -> p.getName().equals("Use Anonymous Login"));
        return list;
    }

    public static class ConfigEntryAuthenticate
    extends GuiConfigEntries.CategoryEntry {
        public ConfigEntryAuthenticate(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            boolean isAuthenticated = ChatTweaks.getAuthManager().getToken("twitchintegration") != null;
            this.btnSelectCategory.field_146126_j = I18n.func_135052_a((String)(isAuthenticated ? "twitchintegration.config.edit_authentication" : "twitchintegration.config.authenticate"), (Object[])new Object[0]);
            if (ChatTweaks.getAuthManager().getToken("twitchintegration") == null && !TwitchIntegrationConfig.useAnonymousLogin) {
                this.btnSelectCategory.field_146126_j = TextFormatting.GREEN + this.btnSelectCategory.field_146126_j;
            }
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiTwitchAuthentication((GuiScreen)this.owningScreen);
        }
    }

    public static class ConfigEntryConnect
    extends GuiConfigEntries.CategoryEntry {
        private boolean enabled;

        public ConfigEntryConnect(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnSelectCategory.func_146116_c(this.mc, x, y)) {
                this.btnSelectCategory.func_146113_a(this.mc.func_147118_V());
                if (TwitchIntegration.getTwitchManager().isConnected()) {
                    TwitchIntegration.getTwitchManager().disconnect();
                } else {
                    TwitchIntegration.getTwitchManager().connect();
                }
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            this.updateButton();
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
        }

        @Nullable
        protected GuiScreen buildChildScreen() {
            return null;
        }

        private void updateButton() {
            boolean isAuthenticated = TwitchIntegrationConfig.useAnonymousLogin || ChatTweaks.getAuthManager().getToken("twitchintegration") != null;
            boolean isConnected = TwitchIntegration.getTwitchManager().isConnected();
            this.btnSelectCategory.field_146126_j = I18n.func_135052_a((String)(isConnected ? "twitchintegration.config.disconnect" : "twitchintegration.config.connect"), (Object[])new Object[0]);
            if (isAuthenticated) {
                this.btnSelectCategory.field_146126_j = TextFormatting.GREEN + this.btnSelectCategory.field_146126_j;
                this.enabled = true;
            } else {
                this.enabled = isConnected;
            }
        }

        public boolean enabled() {
            return this.enabled;
        }
    }
}

