/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration;

import java.io.File;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.auth.TokenPair;
import net.blay09.mods.chattweaks.chat.emotes.bttv.BTTVChannelEmotes;
import net.blay09.mods.chattweaks.chat.emotes.ffz.FFZChannelEmotes;
import net.blay09.mods.twitchintegration.CommandTwitch;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.handler.TwitchChannel;
import net.blay09.mods.twitchintegration.handler.TwitchChatHandler;
import net.blay09.mods.twitchintegration.handler.TwitchManager;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="twitchintegration", name="Twitch Integration", acceptedMinecraftVersions="[1.12]", clientSideOnly=true, dependencies="required-after:chattweaks", guiFactory="net.blay09.mods.twitchintegration.gui.GuiFactory")
public class TwitchIntegration {
    public static final String MOD_ID = "twitchintegration";
    @Mod.Instance(value="twitchintegration")
    public static TwitchIntegration instance;
    public static Logger logger;
    private TwitchManager twitchManager;
    private TwitchChatHandler twitchChatHandler;
    private File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDir = new File(event.getModConfigurationDirectory(), "TwitchIntegration");
        if (!this.configDir.exists() && !this.configDir.mkdirs()) {
            logger.error("Failed to create Twitch Integration config directory.");
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTwitch());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.twitchManager = new TwitchManager(new File(this.configDir, "twitch_channels.json"));
        this.twitchChatHandler = new TwitchChatHandler(this.twitchManager);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void onWorldJoined(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!this.twitchManager.isConnected()) {
            this.twitchManager.connect();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (MOD_ID.equals(event.getModID())) {
            TokenPair token;
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            if (TwitchIntegrationConfig.doNotStoreToken && (token = ChatTweaks.getAuthManager().getToken(MOD_ID)) != null) {
                ChatTweaks.getAuthManager().storeToken(MOD_ID, token.getUsername(), token.getToken(), true);
            }
        }
    }

    public static TwitchChatHandler getTwitchChatHandler() {
        return TwitchIntegration.instance.twitchChatHandler;
    }

    public static TwitchManager getTwitchManager() {
        return TwitchIntegration.instance.twitchManager;
    }

    public static void loadChannelEmotes(TwitchChannel channel) {
        new Thread(() -> {
            try {
                new BTTVChannelEmotes(channel.getName());
            }
            catch (Exception e) {
                logger.error("Failed to load BTTV channel emotes: ", (Throwable)e);
            }
            try {
                new FFZChannelEmotes(channel.getName());
            }
            catch (Exception e) {
                logger.error("Failed to load FFZ channel emotes: ", (Throwable)e);
            }
        }).start();
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

