/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchintegration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.twitchintegration.TwitchIntegration;
import net.blay09.mods.twitchintegration.TwitchIntegrationConfig;
import net.blay09.mods.twitchintegration.handler.TwitchChannel;
import net.blay09.mods.twitchintegration.handler.TwitchChatHandler;
import net.blay09.mods.twitchintegration.tmi.TMIClient;
import net.blay09.mods.twitchintegration.tmi.TwitchMessage;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class CommandTwitch
extends CommandBase {
    public String func_71517_b() {
        return "twitch";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/twitch <channel|user> <message>";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String message = StringUtils.join((Object[])args, (char)' ', (int)1, (int)args.length);
        TMIClient twitchClient = TwitchIntegration.getTwitchManager().getClient();
        TwitchChatHandler twitchChatHandler = TwitchIntegration.getTwitchChatHandler();
        if (twitchClient != null) {
            if (TwitchIntegrationConfig.useAnonymousLogin || twitchClient.getIRCConnection().getNick().startsWith("justinfan")) {
                TextComponentTranslation component = new TextComponentTranslation("twitchintegration.error.read_only_chat", new Object[0]);
                component.func_150256_b().func_150238_a(TextFormatting.RED);
                sender.func_145747_a((ITextComponent)component);
                return;
            }
            if (args[0].startsWith("#")) {
                twitchClient.send(args[0], message);
                if (message.startsWith("/me ")) {
                    message = message.substring(4);
                    twitchChatHandler.onChatMessage(twitchClient, args[0], twitchChatHandler.getThisUser(twitchClient, args[0]), new TwitchMessage(message, -1, true, 0));
                } else {
                    twitchChatHandler.onChatMessage(twitchClient, args[0], twitchChatHandler.getThisUser(twitchClient, args[0]), new TwitchMessage(message, -1, false, 0));
                }
            } else {
                twitchClient.getTwitchCommands().whisper(args[0], message);
                twitchChatHandler.onWhisperMessage(twitchClient, twitchChatHandler.getThisUser(twitchClient, null), twitchChatHandler.getUser(args[0]), message);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList completions = Lists.newArrayList();
        for (TwitchChannel channel : TwitchIntegration.getTwitchManager().getChannels()) {
            if (!channel.isActive()) continue;
            completions.add("#" + channel.getName().toLowerCase(Locale.ENGLISH));
        }
        return CommandTwitch.func_175762_a((String[])args, (Collection)completions);
    }
}

