/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import mods.waterstrainer.Config;

public abstract class FileReader {
    public final String NEW_LINE = System.getProperty("line.separator").toString();
    public String directoryPath = null;
    public List<String> fileData = null;

    public abstract String getFileName();

    public abstract void parseFileData();

    public abstract boolean createFile();

    public void importFileData(List<String> data) {
        this.fileData = data;
        if (this.fileData == null) {
            this.directoryPath = Config.directoryPath.toString();
            if (this.directoryPath == null) {
                return;
            }
            this.directoryPath = this.directoryPath + this.getFileName();
            if (!this.readFile() && this.createFile()) {
                this.readFile();
            }
        }
        this.parseFileData();
    }

    public boolean readFile() {
        try {
            this.fileData = Files.readAllLines(Paths.get(this.directoryPath, new String[0]));
            return true;
        }
        catch (IOException e) {
            this.fileData = null;
            return false;
        }
    }

    public boolean writeLineToFile(String fileName, String content) {
        try {
            Files.write(Paths.get(fileName, new String[0]), content.getBytes(), StandardOpenOption.CREATE);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

