/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.tileentity;

import java.util.Random;
import mods.waterstrainer.Config;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.item.IIsBait;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.Patcher;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class TileEntityStrainer
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[0];
    private static final int[] SLOTS_ALL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private Random rand = new Random();
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)30, (Object)ItemStack.field_190927_a);
    private int curIdleTime = 0;
    private int maxIdleTime = Config.idleTime * 20;
    private ItemStack lastCheckedInputStack = Patcher.emptyStack();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.curIdleTime = compound.func_74762_e("CurIdleTime");
        this.maxIdleTime = compound.func_74762_e("MaxIdleTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        compound.func_74768_a("CurIdleTime", this.curIdleTime);
        compound.func_74768_a("MaxIdleTime", this.maxIdleTime);
        return compound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!Patcher.isStackEmpty(itemstack)) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!Patcher.isStackEmpty(stack) && Patcher.stackSize(stack) > this.func_70297_j_()) {
            Patcher.setStackSize(stack, this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (Patcher.isStackEmpty(stack)) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemStrainer && slot == 0) {
            return true;
        }
        if (stack.func_77973_b() instanceof IIsBait && slot == 28) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemBaitPot && slot == 29;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_70005_c_() {
        return "tile.waterstrainer.strainer_base.name";
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_ALL;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot != 0 && slot != 28 && slot != 29;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private Block getBlock(BlockPos pos) {
        return this.func_145831_w().func_180495_p(pos).func_177230_c();
    }

    public float calculateEfficiency() {
        float efficiency = 0.0f;
        ItemStack strainer = this.func_70301_a(0);
        if (Config.miscEnableEfficiency) {
            Biome biome;
            Chunk chunk;
            IBlockState blockState;
            Block waterBlock;
            if (!Patcher.isStackEmpty(strainer) && strainer.func_77973_b() instanceof ItemStrainer) {
                efficiency += (float)((ItemStrainer)strainer.func_77973_b()).getEfficiencyBonus();
            }
            if (APIUtils.isWaterBlock(waterBlock = (blockState = this.func_145831_w().func_180495_p(this.field_174879_c.func_177984_a())).func_177230_c())) {
                int meta = waterBlock.func_176201_c(blockState);
                if (meta > 0) {
                    efficiency += 10.0f;
                }
                if (meta > 1) {
                    efficiency -= (float)((meta - 1) * 3);
                }
            }
            BlockPos pos = this.field_174879_c;
            for (int curZ = pos.func_177952_p() - 1; curZ < pos.func_177952_p() + 2; ++curZ) {
                for (int curX = pos.func_177958_n() - 1; curX < pos.func_177958_n() + 2; ++curX) {
                    if (curX == pos.func_177958_n() && curZ == pos.func_177952_p() || this.getBlock(new BlockPos(curX, pos.func_177956_o(), curZ)) != BlockRegistry.strainer_base) continue;
                    efficiency -= 15.0f;
                }
            }
            World world = this.func_145831_w();
            if (world != null && !(chunk = world.func_175726_f(pos)).func_76621_g() && (biome = chunk.func_177411_a(pos, world.func_72959_q())) != null) {
                if (Patcher.isBiomeOfType(biome, BiomeDictionary.Type.OCEAN)) {
                    efficiency += 10.0f;
                } else if (Patcher.isBiomeOfType(biome, BiomeDictionary.Type.BEACH)) {
                    efficiency += 15.0f;
                } else if (Patcher.isBiomeOfType(biome, BiomeDictionary.Type.RIVER)) {
                    efficiency += 20.0f;
                }
            }
        }
        return efficiency += (float)(ItemStrainer.getEnchantmentLevel(strainer, Enchantments.field_185305_q) * 5);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (!BlockStrainerBase.canBlockStayAtPos((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
                return;
            }
            ++this.curIdleTime;
            ItemStack strainer = this.func_70301_a(0);
            if (strainer != this.lastCheckedInputStack) {
                this.lastCheckedInputStack = strainer;
                if (!Patcher.isStackEmpty(strainer)) {
                    String itemName = strainer.func_77973_b().getRegistryName().toString();
                    BlockStrainerBase.setState(this.func_145831_w(), this.field_174879_c, ItemRegistry.getMetaFromName(itemName));
                } else {
                    BlockStrainerBase.setState(this.func_145831_w(), this.field_174879_c, 0);
                }
            }
            block0: for (EntityItem ent : TileEntityHopper.func_184292_a((World)this.func_145831_w(), (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5))) {
                for (int i = 1; i < 28; ++i) {
                    if (ent == null) continue;
                    ItemStack entstack = this.addItemStackToSlot(i, ent.func_92059_d());
                    if (!Patcher.isStackEmpty(entstack) && Patcher.stackSize(entstack) != 0) {
                        ent.func_92058_a(entstack);
                        continue;
                    }
                    ent.func_70106_y();
                    continue block0;
                }
            }
            if (this.curIdleTime >= this.maxIdleTime) {
                ItemStrainer itemstrainer;
                ItemStack stack;
                this.curIdleTime = 0;
                int min = Config.idleTime - Config.idleTimeDeviation;
                int max = Config.idleTime + Config.idleTimeDeviation;
                this.maxIdleTime = (this.rand.nextInt(max - min + 1) + min) * 20;
                float efficiency = this.calculateEfficiency();
                if (efficiency > 0.0f) {
                    this.maxIdleTime = (int)((float)this.maxIdleTime / ((efficiency + 100.0f) / 100.0f));
                } else if (efficiency < 0.0f) {
                    this.maxIdleTime = Math.abs((int)((float)this.maxIdleTime * ((efficiency - 100.0f) / 100.0f)));
                }
                if (APIUtils.isWaterBlock(this.func_145831_w().func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c()) && !Patcher.isStackEmpty(strainer) && strainer.func_77973_b() instanceof ItemStrainer && !Patcher.isStackEmpty(stack = (itemstrainer = (ItemStrainer)strainer.func_77973_b()).generateRandomItemStack(this.func_145831_w(), this.func_174877_v(), strainer))) {
                    if (itemstrainer == ItemRegistry.strainer_fisherman && !this.consumeBait()) {
                        return;
                    }
                    int stackSize = Patcher.stackSize(stack);
                    if (ItemStrainer.generateBonusItem(ItemStrainer.getEnchantmentLevel(strainer, Enchantments.field_185308_t))) {
                        Patcher.increaseStackSize(stack, 1);
                        ++stackSize;
                    }
                    for (int i = 1; i < 28 && !Patcher.isStackEmpty(stack = this.addItemStackToSlot(i, stack)); ++i) {
                    }
                    if ((Patcher.isStackEmpty(stack) || stackSize != Patcher.stackSize(stack)) && strainer.func_77984_f()) {
                        if (!ItemStrainer.preventDamage(ItemStrainer.getEnchantmentLevel(strainer, Enchantments.field_185307_s))) {
                            strainer.func_77964_b(strainer.func_77952_i() + 1);
                        }
                        if (strainer.func_77952_i() >= strainer.func_77958_k()) {
                            this.func_70299_a(0, Patcher.emptyStack());
                        }
                    }
                }
            }
        }
    }

    private boolean consumeBait() {
        ItemStack stack = this.func_70301_a(28);
        if (Patcher.isStackEmpty(stack) || !(stack.func_77973_b() instanceof IIsBait)) {
            return false;
        }
        if (!((IIsBait)stack.func_77973_b()).infiniteBait()) {
            ItemStack pot = this.func_70301_a(29);
            if (!Patcher.isStackEmpty(pot) && pot.func_77973_b() instanceof ItemBaitPot && this.rand.nextInt(2) == 0) {
                pot.func_77964_b(pot.func_77952_i() + 1);
                if (pot.func_77952_i() >= pot.func_77958_k()) {
                    this.func_70299_a(29, Patcher.emptyStack());
                }
                return true;
            }
            Patcher.decreaseStackSize(stack, 1);
            if (Patcher.stackSize(stack) <= 0) {
                this.func_70299_a(28, Patcher.emptyStack());
            }
        }
        return true;
    }

    private ItemStack addItemStackToSlot(int slotIndex, ItemStack newStack) {
        int max;
        ItemStack stackInSlot = this.func_70301_a(slotIndex);
        boolean needsUpdate = false;
        if (Patcher.isStackEmpty(stackInSlot)) {
            int max2 = Math.min(newStack.func_77976_d(), this.func_70297_j_());
            if (max2 >= Patcher.stackSize(newStack)) {
                this.func_70299_a(slotIndex, newStack);
                newStack = Patcher.emptyStack();
            } else {
                this.func_70299_a(slotIndex, newStack.func_77979_a(max2));
            }
            needsUpdate = true;
        } else if (TileEntityStrainer.canCombineStacks(stackInSlot, newStack) && (max = Math.min(newStack.func_77976_d(), this.func_70297_j_())) > Patcher.stackSize(stackInSlot)) {
            int i = max - Patcher.stackSize(stackInSlot);
            int j = Math.min(Patcher.stackSize(newStack), i);
            Patcher.decreaseStackSize(newStack, j);
            Patcher.increaseStackSize(stackInSlot, j);
            boolean bl = needsUpdate = j > 0;
        }
        if (needsUpdate) {
            this.func_70296_d();
        }
        if (!Patcher.isStackEmpty(newStack) && Patcher.stackSize(newStack) == 0) {
            newStack = Patcher.emptyStack();
        }
        return newStack;
    }

    private static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (Patcher.stackSize(stack1) > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (Patcher.isStackEmpty(stack)) continue;
            return false;
        }
        return true;
    }
}

