/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mods.waterstrainer.Config;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncLootTables
implements IMessage {
    private List<String> lootTableData = new ArrayList<String>();
    private int size = 0;

    public MessageSyncLootTables() {
    }

    public MessageSyncLootTables(List<String> data) {
        this.size = data == null ? 0 : data.size();
        this.lootTableData = data;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.size);
        if (this.size > 0) {
            for (String data : this.lootTableData) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)data);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.size = buf.readInt();
        if (this.size > 0) {
            for (int i = 0; i < this.size; ++i) {
                this.lootTableData.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSyncLootTables, IMessage> {
        public IMessage onMessage(final MessageSyncLootTables message, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (message.size > 0) {
                        Config.Files.FILE_LOOTTABLE.importFileData(message.lootTableData);
                    } else {
                        Config.Files.FILE_LOOTTABLE.importFileData(null);
                    }
                }
            });
            return null;
        }
    }
}

