/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.block;

import java.util.List;
import javax.annotation.Nullable;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.Patcher;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStrainerBase
extends BlockContainer {
    public static final PropertyInteger MODELID = PropertyInteger.func_177719_a((String)"modelid", (int)0, (int)11);

    public BlockStrainerBase() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setRegistryName("strainer_base");
        this.func_149663_c("waterstrainer.strainer_base");
        this.func_149647_a(WaterStrainer.tabWaterStrainer);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(0)));
    }

    public void initModel() {
        WaterStrainer.proxy.registerModel(Item.func_150898_a((Block)this), 0, new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Generates items while in water.");
        tooltip.add("Requires a Strainer.");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityStrainer tile;
        if (world.field_72995_K || player == null) {
            return true;
        }
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (!Patcher.isStackEmpty(heldItemStack) && heldItemStack.func_77973_b() instanceof ItemStrainer && (tile = BlockStrainerBase.getTileEntity((IBlockAccess)world, pos)) != null && Patcher.isStackEmpty(tile.func_70301_a(0))) {
            tile.func_70299_a(0, heldItemStack);
            BlockStrainerBase.setState(world, pos, ItemRegistry.getMetaFromName(heldItemStack.func_77973_b().getRegistryName().toString()));
            int slot = player.field_71071_by.field_70461_c;
            player.field_71071_by.func_70299_a(slot, Patcher.emptyStack());
            return true;
        }
        if (!Patcher.isStackEmpty(heldItemStack) && heldItemStack.func_77973_b() == ItemRegistry.efficiency_meter) {
            IBlockState blockState = world.func_180495_p(pos.func_177984_a());
            Block waterBlock = blockState.func_177230_c();
            if (!APIUtils.isWaterBlock(waterBlock)) {
                Patcher.sendChatMessage((ICommandSender)player, TextFormatting.RED + "Strainer has no water!");
                return true;
            }
            TileEntityStrainer tile2 = BlockStrainerBase.getTileEntity((IBlockAccess)world, pos);
            if (tile2 != null) {
                float efficiency = tile2.calculateEfficiency();
                if (efficiency == 0.0f) {
                    Patcher.sendChatMessage((ICommandSender)player, TextFormatting.GOLD + "Bonus Efficiency: " + TextFormatting.YELLOW + "0%");
                } else if (efficiency > 0.0f) {
                    Patcher.sendChatMessage((ICommandSender)player, TextFormatting.GOLD + "Bonus Efficiency: " + TextFormatting.GREEN + "+" + (int)efficiency + "%");
                } else {
                    Patcher.sendChatMessage((ICommandSender)player, TextFormatting.GOLD + "Bonus Efficiency: " + TextFormatting.RED + (int)efficiency + "%");
                }
                return true;
            }
        }
        player.openGui((Object)WaterStrainer.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return BlockStrainerBase.canBlockStayAtPos((IBlockAccess)world, pos);
    }

    public static void setState(World world, BlockPos pos, int newState) {
        IBlockState state = world.func_180495_p(pos);
        if (state == null || state.func_177230_c() != BlockRegistry.strainer_base) {
            return;
        }
        int oldState = (Integer)state.func_177229_b((IProperty)MODELID);
        if (newState != oldState) {
            if (!BlockStrainerBase.canBlockStayAtPos((IBlockAccess)world, pos)) {
                newState = 1;
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(newState)));
        }
    }

    public static boolean canBlockStayAtPos(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block == Blocks.field_150350_a || APIUtils.isWaterBlock(block);
    }

    public void observedNeighborChange(IBlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        if (!BlockStrainerBase.canBlockStayAtPos((IBlockAccess)world, pos)) {
            BlockStrainerBase.setState(world, pos, 1);
        } else {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof TileEntityStrainer) {
                ItemStack stack = ((TileEntityStrainer)tile).func_70301_a(0);
                if (!Patcher.isStackEmpty(stack)) {
                    String itemName = stack.func_77973_b().getRegistryName().toString();
                    BlockStrainerBase.setState(world, pos, ItemRegistry.getMetaFromName(itemName));
                } else {
                    BlockStrainerBase.setState(world, pos, 0);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityStrainer();
    }

    public static TileEntityStrainer getTileEntity(IBlockAccess block, BlockPos pos) {
        return (TileEntityStrainer)block.func_175625_s(pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODELID, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MODELID);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODELID});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState blockstate) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

