/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.world;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;

public class IIWorldGen
implements IWorldGenerator {
    public static ArrayList<OreGen> orespawnList = new ArrayList();
    public static ArrayList<Integer> oreDimBlacklistOverworld = new ArrayList();
    public static ArrayList<Integer> oreDimBlacklistNether = new ArrayList();
    public static ArrayList<Integer> oreDimBlacklistEnd = new ArrayList();
    public static HashMap<String, Boolean> retrogenMap = new HashMap();
    public static ArrayListMultimap<Integer, ChunkPos> retrogenChunks = ArrayListMultimap.create();

    public static OreGen addOreGen(String name, IBlockState state, int maxVeinSize, int minY, int maxY, int chunkOccurence, int weight, EnumOreType type) {
        Block block = type == EnumOreType.OVERWORLD ? Blocks.field_150348_b : (type == EnumOreType.NETHER ? Blocks.field_150424_aL : Blocks.field_150377_bs);
        OreGen gen = new OreGen(name, state, maxVeinSize, block, minY, maxY, chunkOccurence, weight, type);
        orespawnList.add(gen);
        return gen;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOres(random, chunkX, chunkZ, world, true);
    }

    public void generateOres(Random random, int chunkX, int chunkZ, World world, boolean newGeneration) {
        OreGen gen;
        EnumOreType type;
        int dim = world.field_73011_w.getDimension();
        Iterator<OreGen> iterator = orespawnList.iterator();
        while (!(!iterator.hasNext() || (type = (gen = iterator.next()).getType()) == EnumOreType.OVERWORLD && oreDimBlacklistOverworld.contains(dim) || type == EnumOreType.NETHER && oreDimBlacklistNether.contains(dim) || type == EnumOreType.END && oreDimBlacklistEnd.contains(dim))) {
            if (!newGeneration && !retrogenMap.get("retrogen_" + gen.name).booleanValue()) continue;
            gen.generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        NBTTagCompound nbt = new NBTTagCompound();
        event.getData().func_74782_a("ImmersiveIntelligence", (NBTBase)nbt);
        nbt.func_74757_a(Config.IIConfig.Ores.retrogen_key, true);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        if (!event.getData().func_74775_l("ImmersiveIntelligence").func_74764_b(Config.IIConfig.Ores.retrogen_key) && (Config.IIConfig.Ores.retrogen_platinum || Config.IIConfig.Ores.retrogen_salt || Config.IIConfig.Ores.retrogen_tungsten || Config.IIConfig.Ores.retrogen_zinc || Config.IIConfig.Ores.retrogen_fluorite)) {
            if (Config.IIConfig.Ores.retrogen_log_flagChunk) {
                ImmersiveIntelligence.logger.info("Chunk " + event.getChunk().func_76632_l() + " has been flagged for Ore RetroGeneration by IE.");
            }
            retrogenChunks.put((Object)dimension, (Object)event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.START) {
            return;
        }
        int dimension = event.world.field_73011_w.getDimension();
        int counter = 0;
        List chunks = retrogenChunks.get((Object)dimension);
        if (chunks != null && chunks.size() > 0) {
            for (int i = 0; i < 2 && (chunks = retrogenChunks.get((Object)dimension)) != null && chunks.size() > 0; ++i) {
                ++counter;
                ChunkPos loc = (ChunkPos)chunks.get(0);
                long worldSeed = event.world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)loc.field_77276_a + zSeed * (long)loc.field_77275_b ^ worldSeed);
                this.generateOres(fmlRandom, loc.field_77276_a, loc.field_77275_b, event.world, false);
                chunks.remove(0);
            }
        }
        if (counter > 0 && Config.IIConfig.Ores.retrogen_log_remaining) {
            ImmersiveIntelligence.logger.info("Retrogen was performed on " + counter + " Chunks, " + Math.max(0, chunks.size()) + " chunks remaining");
        }
    }

    public static class OreGen {
        String name;
        WorldGenMinable mineableGen;
        int minY;
        int maxY;
        int chunkOccurence;
        int weight;
        EnumOreType type;

        public OreGen(String name, IBlockState state, int maxVeinSize, Block replaceTarget, int minY, int maxY, int chunkOccurence, int weight, EnumOreType type) {
            this.name = name;
            this.mineableGen = new WorldGenMinable(state, maxVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)replaceTarget));
            this.minY = minY;
            this.maxY = maxY;
            this.chunkOccurence = chunkOccurence;
            this.weight = weight;
            this.type = type;
        }

        public void generate(World world, Random rand, int x, int z) {
            for (int i = 0; i < this.chunkOccurence; ++i) {
                if (rand.nextInt(100) >= this.weight) continue;
                BlockPos pos = new BlockPos(x + rand.nextInt(16), this.minY + rand.nextInt(this.maxY - this.minY), z + rand.nextInt(16));
                this.mineableGen.func_180709_b(world, rand, pos);
            }
        }

        public EnumOreType getType() {
            return this.type;
        }
    }

    public static enum EnumOreType {
        OVERWORLD,
        NETHER,
        END;

    }
}

