/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;

public class MessageGuiNBT
implements IMessage {
    public int id;
    public int x;
    public int y;
    public int z;
    public String player;

    public MessageGuiNBT(int id, BlockPos pos, EntityPlayer player) {
        this.id = id;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.player = player.func_110124_au().toString();
    }

    public MessageGuiNBT() {
        this.id = -1;
        this.x = Integer.MAX_VALUE;
        this.y = Integer.MAX_VALUE;
        this.z = Integer.MAX_VALUE;
        this.player = "_";
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.player = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class HandlerServer
    implements IMessageHandler<MessageGuiNBT, IMessage> {
        public IMessage onMessage(MessageGuiNBT message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                if (world.func_175667_e(new BlockPos(message.x, message.y, message.z)) && world.func_175625_s(new BlockPos(message.x, message.y, message.z)) instanceof IEBlockInterfaces.IGuiTile) {
                    if (message.player.equals("_") || world.func_152378_a(UUID.fromString(message.player)) == null) {
                        return;
                    }
                    EntityPlayer player = world.func_152378_a(UUID.fromString(message.player));
                    ImmersiveIntelligence.proxy.onServerGuiChangeRequest(world.func_175625_s(new BlockPos(message.x, message.y, message.z)), message.id, player);
                }
            });
            return null;
        }
    }
}

