/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.client.ClientUtils;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;

public class MessageBlockDamageSync
implements IMessage {
    public float damage;
    public int dim;
    public int x;
    public int y;
    public int z;

    public MessageBlockDamageSync(float damage, DimensionBlockPos pos) {
        this.damage = damage;
        this.dim = pos.dimension;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public MessageBlockDamageSync() {
        this.damage = 0.0f;
        this.dim = -1;
        this.x = Integer.MAX_VALUE;
        this.y = Integer.MAX_VALUE;
        this.z = Integer.MAX_VALUE;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.damage);
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        this.damage = buf.readFloat();
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public static class HandlerClient
    implements IMessageHandler<MessageBlockDamageSync, IMessage> {
        public IMessage onMessage(MessageBlockDamageSync message, MessageContext ctx) {
            ClientUtils.mc().func_152344_a(() -> {
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    DimensionBlockPos bpos = new DimensionBlockPos(message.x, message.y, message.z, message.dim);
                    DimensionBlockPos bpos2 = null;
                    for (Map.Entry<DimensionBlockPos, Float> entry : PenetrationRegistry.blockDamage.entrySet()) {
                        if (!entry.getKey().equals((Object)bpos)) continue;
                        bpos2 = entry.getKey();
                    }
                    if (message.damage > 0.0f) {
                        if (PenetrationRegistry.blockDamageClient.containsKey(bpos2)) {
                            PenetrationRegistry.blockDamageClient.replace(bpos2, Float.valueOf(message.damage));
                        } else {
                            PenetrationRegistry.blockDamageClient.put(bpos2, Float.valueOf(message.damage));
                        }
                    } else {
                        PenetrationRegistry.blockDamageClient.remove(bpos2);
                    }
                }
            });
            return null;
        }
    }
}

