/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.weapons;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.client.render.MachinegunRenderer;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIWeaponUpgrade
extends ItemIIBase
implements IUpgrade {
    public ItemIIWeaponUpgrade() {
        super("weapon_upgrade", 1, WeaponUpgrades.parse());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() < this.getSubNames().length) {
            String[] flavour;
            for (String s : flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.func_135052_a((String)("desc.immersiveintelligence." + "toolupgrade." + this.getSubNames()[stack.func_77952_i()]), (Object[])new Object[0]), 200)) {
                list.add(s);
            }
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return WeaponUpgrades.get(stack.func_77960_j()).stackSize;
    }

    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return WeaponUpgrades.get(upgrade.func_77960_j()).toolset;
    }

    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate check = WeaponUpgrades.get(upgrade.func_77960_j()).applyCheck;
        if (check != null && target.func_77973_b() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        WeaponUpgrades.get(upgrade.func_77960_j()).function.accept(upgrade, modifications);
    }

    public static void addUpgradesToRender() {
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("water_cooling"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.waterCoolingBox);
        });
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("heavy_barrel"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.heavyBarrelBox);
        });
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("second_magazine"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.add(MachinegunRenderer.model.secondMagazineMainBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.secondMagazineMagBox);
        });
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("belt_fed_loader"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.ammoBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.beltFedLoaderBox);
        });
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("scope"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.scopeBox));
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("infrared_scope"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.infraredScopeBox));
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("hasty_bipod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.hastyBipodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> CommonProxy.item_machinegun.getUpgrades((ItemStack)stack).func_74767_n("precise_bipod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.preciseBipodBox);
        });
    }

    public static enum WeaponUpgrades {
        HEAVY_BARREL((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("water_cooling"), (upgrade, modifications) -> modifications.func_74757_a("heavy_barrel", true)),
        WATER_COOLING((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("heavy_barrel"), (upgrade, modifications) -> modifications.func_74757_a("water_cooling", true)),
        BELT_FED_LOADER((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("second_magazine"), (upgrade, modifications) -> modifications.func_74757_a("belt_fed_loader", true)),
        SECOND_MAGAZINE((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("belt_fed_loader"), (upgrade, modifications) -> modifications.func_74757_a("second_magazine", true)),
        HASTY_BIPOD((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("precise_bipod"), (upgrade, modifications) -> modifications.func_74757_a("hasty_bipod", true)),
        PRECISE_BIPOD((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("hasty_bipod"), (upgrade, modifications) -> modifications.func_74757_a("precise_bipod", true)),
        SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("infrared_scope"), (upgrade, modifications) -> modifications.func_74757_a("scope", true)),
        INFRARED_SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("scope"), (upgrade, modifications) -> modifications.func_74757_a("infrared_scope", true));

        private ImmutableSet<String> toolset;
        private int stackSize = 1;
        private BiPredicate<ItemStack, ItemStack> applyCheck;
        private BiConsumer<ItemStack, NBTTagCompound> function;

        private WeaponUpgrades(ImmutableSet<String> toolset, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, 1, function);
        }

        private WeaponUpgrades(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, stackSize, null, function);
        }

        private WeaponUpgrades(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, NBTTagCompound> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }

        static String[] parse() {
            String[] ret = new String[WeaponUpgrades.values().length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = WeaponUpgrades.values()[i].toString().toLowerCase(Locale.US);
            }
            return ret;
        }

        static WeaponUpgrades get(int meta) {
            if (meta >= 0 && meta < WeaponUpgrades.values().length) {
                return WeaponUpgrades.values()[meta];
            }
            return HEAVY_BARREL;
        }
    }
}

