/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.tools;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIElectricWirecutter
extends ItemIIBase
implements ITool,
EnergyHelper.IIEEnergyItem {
    public ItemIIElectricWirecutter() {
        super("electric_wirecutter", 1, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    super(x0);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                        return (T)((Object)this);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.field_72995_K && tileEntity instanceof IImmersiveConnectable && this.hasEnoughEnergy(player.func_184586_b(hand))) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
            boolean cut = ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC((Object)nodeHere), world, target);
            IESaveData.setDirty((int)world.field_73011_w.getDimension());
            this.extractEnergy(player.func_184586_b(hand), Config.IIConfig.Tools.electric_wirecutter_energy_per_use, false);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        double reachDistance;
        ImmersiveNetHandler.Connection target;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (target = ApiUtils.getTargetConnection((World)world, (EntityPlayer)player, null, (double)(reachDistance = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111126_e()))) != null) {
            ImmersiveNetHandler.INSTANCE.removeConnectionAndDrop(target, world, player.func_180425_c());
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.hasEnoughEnergy(stack)) {
            return 4;
        }
        return -1;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isTool(ItemStack item) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getEnergyStored(stack) / this.getMaxEnergyStored(stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.hasEnoughEnergy(stack)) {
            for (String type : this.getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return 16.0f;
            }
        }
        return super.func_150893_a(stack, state);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return Config.IIConfig.Tools.electric_wirecutter_capacity;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(Config.IIConfig.Tools.electric_wirecutter_energy_per_use, false);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"IE_WIRECUTTER");
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return this.hasEnoughEnergy(stack) && (state.func_177230_c() instanceof BlockIEBase ? ((BlockIEBase)state.func_177230_c()).allowWirecutterHarvest(state) : state.func_177230_c().isToolEffective("IE_WIRECUTTER", state));
    }

    public boolean hasEnoughEnergy(ItemStack stack) {
        return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() >= Config.IIConfig.Tools.electric_wirecutter_energy_per_use;
    }
}

