/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.mechanical;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorGear;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIMotorGear
extends ItemIIBase
implements IMotorGear {
    public ItemIIMotorGear() {
        super("motor_gear", 8, MotorGear.getNames());
    }

    @Override
    public int getGearDurability(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"gear_damage")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"gear_damage", (int)0);
        }
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"gear_damage");
    }

    @Override
    public void damageGear(ItemStack stack, int amount) {
        int current = this.getGearDurability(stack) + amount;
        if (current <= this.getGearMaxDurability(stack)) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"gear_damage", (int)current);
        } else {
            ItemNBTHelper.remove((ItemStack)stack, (String)"gear_damage");
            stack.func_190918_g(1);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getGearDurability(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getGearDurability(stack) / (double)this.getGearMaxDurability(stack);
    }

    @Override
    public int getGearMaxDurability(ItemStack stack) {
        return MotorGear.valueOf((String)this.subNames[stack.func_77960_j()].toUpperCase()).maxDurability;
    }

    @Override
    public int getGearMinTorque(ItemStack stack) {
        return MotorGear.valueOf((String)this.subNames[stack.func_77960_j()].toUpperCase()).minRPM;
    }

    @Override
    public int getGearMaxRPM(ItemStack stack) {
        return MotorGear.valueOf((String)this.subNames[stack.func_77960_j()].toUpperCase()).maxRPM;
    }

    @Override
    public int getGearMaxTorque(ItemStack stack) {
        return MotorGear.valueOf((String)this.subNames[stack.func_77960_j()].toUpperCase()).maxTorque;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (flagIn.func_194127_a()) {
            tooltip.add(I18n.func_135052_a((String)"info.immersiveintelligence.gear_durability", (Object[])new Object[]{this.getGearMaxDurability(stack) - this.getGearDurability(stack), this.getGearMaxDurability(stack)}));
        }
    }

    static enum MotorGear implements IStringSerializable
    {
        COPPER(Config.IIConfig.MechanicalDevices.gear_min_rpm[0], Config.IIConfig.MechanicalDevices.gear_max_rpm[0], Config.IIConfig.MechanicalDevices.gear_max_torque[0], Config.IIConfig.MechanicalDevices.gear_max_durability[0]),
        BRASS(Config.IIConfig.MechanicalDevices.gear_min_rpm[1], Config.IIConfig.MechanicalDevices.gear_max_rpm[1], Config.IIConfig.MechanicalDevices.gear_max_torque[1], Config.IIConfig.MechanicalDevices.gear_max_durability[1]),
        IRON(Config.IIConfig.MechanicalDevices.gear_min_rpm[2], Config.IIConfig.MechanicalDevices.gear_max_rpm[2], Config.IIConfig.MechanicalDevices.gear_max_torque[2], Config.IIConfig.MechanicalDevices.gear_max_durability[2]),
        STEEL(Config.IIConfig.MechanicalDevices.gear_min_rpm[3], Config.IIConfig.MechanicalDevices.gear_max_rpm[3], Config.IIConfig.MechanicalDevices.gear_max_torque[3], Config.IIConfig.MechanicalDevices.gear_max_durability[3]),
        TUNGSTEN(Config.IIConfig.MechanicalDevices.gear_min_rpm[4], Config.IIConfig.MechanicalDevices.gear_max_rpm[4], Config.IIConfig.MechanicalDevices.gear_max_torque[4], Config.IIConfig.MechanicalDevices.gear_max_durability[4]);

        int minRPM;
        int maxRPM;
        int maxTorque;
        int maxDurability;

        private MotorGear(int minRPM, int maxRPM, int maxTorque, int maxDurability) {
            this.minRPM = minRPM;
            this.maxRPM = maxRPM;
            this.maxTorque = maxTorque;
            this.maxDurability = maxDurability;
        }

        public static String[] getNames() {
            ArrayList<String> list = new ArrayList<String>();
            String[] a = new String[list.size()];
            for (MotorGear belt : MotorGear.values()) {
                list.add(belt.func_176610_l());
            }
            return list.toArray(a);
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

