/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.api.utils.ISawblade;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIISawblade
extends ItemIIBase
implements ISawblade {
    public ItemIISawblade() {
        super("sawblade", 1, "iron", "steel", "tungsten");
        SawmillRecipe.registerSawblade("iron", this);
        SawmillRecipe.registerSawblade("steel", this);
        SawmillRecipe.registerSawblade("tungsten", this);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)this.getSawbladeMaxDamage(stack));
    }

    @Override
    public String getMaterialName(ItemStack stack) {
        return this.subNames[stack.func_77960_j()];
    }

    @Override
    public void damageSawblade(ItemStack stack, int amount) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)this.getSawbladeMaxDamage(stack));
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)(this.getSawbladeDamage(stack) - amount));
        if (this.getSawbladeDamage(stack) < 0) {
            stack.func_190920_e(0);
        }
    }

    @Override
    public int getSawbladeDamage(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"damage");
    }

    @Override
    public int getSawbladeMaxDamage(ItemStack stack) {
        switch (this.subNames[stack.func_77960_j()]) {
            case "iron": {
                return Config.IIConfig.Tools.sawblade_iron_durability;
            }
            case "steel": {
                return Config.IIConfig.Tools.sawblade_steel_durability;
            }
            case "tungsten": {
                return Config.IIConfig.Tools.sawblade_tungsten_durability;
            }
        }
        return -1;
    }

    @Override
    public int getHardness(ItemStack stack) {
        switch (this.subNames[stack.func_77960_j()]) {
            case "iron": {
                return 2;
            }
            case "steel": {
                return 3;
            }
            case "tungsten": {
                return 4;
            }
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage") && (double)this.getSawbladeDamage(stack) / (double)this.getSawbladeDamage(stack) != 1.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getSawbladeDamage(stack) / (double)this.getSawbladeDamage(stack);
    }

    @Override
    public ItemStack getToolPresentationStack(String tool_name) {
        return new ItemStack((Item)this, 1, this.getMetaBySubname(tool_name));
    }

    @Override
    public int getSawbladeDisplayMeta(ItemStack stack) {
        switch (this.subNames[stack.func_77960_j()]) {
            case "iron": {
                return 8;
            }
            case "steel": {
                return 9;
            }
            case "tungsten": {
                return 10;
            }
        }
        return 0;
    }
}

