/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBullet;

public class ItemIIBulletMagazine
extends ItemIIBase
implements IEItemInterfaces.ITextureOverride {
    public ItemIIBulletMagazine() {
        super("bullet_magazine", 1, "machinegun", "submachinegun", "automatic_revolver");
    }

    public static void makeDefault(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullets")) {
            NonNullList l = NonNullList.func_191197_a((int)ItemIIBulletMagazine.getBulletCapactity(stack), (Object)ItemStack.field_190927_a);
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)Utils.writeInventory((Collection)l));
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour0")) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour0", (int)-1);
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour1")) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour1", (int)-1);
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour2")) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour2", (int)-1);
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour3")) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour3", (int)-1);
            }
        } else {
            ItemStack bullet;
            int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
            NonNullList cartridge = Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("bullets", 10), (int)bc);
            ArrayList<ItemStack> already = new ArrayList<ItemStack>();
            int i = 0;
            Iterator iterator = cartridge.iterator();
            while (iterator.hasNext() && !(bullet = (ItemStack)iterator.next()).func_190926_b() && i <= 3) {
                boolean contains = false;
                for (ItemStack s : already) {
                    if (!ItemStack.func_77989_b((ItemStack)bullet, (ItemStack)s)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                already.add(bullet);
                ItemNBTHelper.setInt((ItemStack)stack, (String)("colour" + i), (int)ItemIIBullet.getColour(bullet));
                ItemNBTHelper.setTagCompound((ItemStack)stack, (String)("bullet" + i), (NBTTagCompound)bullet.serializeNBT());
                ++i;
            }
            if (already.size() < 1) {
                ItemNBTHelper.remove((ItemStack)stack, (String)"bullet0");
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour0", (int)-1);
            }
            if (already.size() < 2) {
                ItemNBTHelper.remove((ItemStack)stack, (String)"bullet1");
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour1", (int)-1);
            }
            if (already.size() < 3) {
                ItemNBTHelper.remove((ItemStack)stack, (String)"bullet2");
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour2", (int)-1);
            }
            if (already.size() < 4) {
                ItemNBTHelper.remove((ItemStack)stack, (String)"bullet3");
                ItemNBTHelper.setInt((ItemStack)stack, (String)"colour3", (int)-1);
            }
        }
    }

    public static ItemStack takeBullet(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullets")) {
            int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
            NonNullList cartridge = Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("bullets", 10), (int)bc);
            ItemStack ammo = ((ItemStack)cartridge.get(0)).func_77946_l();
            cartridge.set(0, (Object)ItemStack.field_190927_a);
            for (int i = 1; i < bc; ++i) {
                if (!((ItemStack)cartridge.get(i - 1)).func_190926_b()) continue;
                cartridge.set(i - 1, cartridge.get(i));
                cartridge.set(i, (Object)ItemStack.field_190927_a);
            }
            NBTTagList list = Utils.writeInventory((Collection)cartridge);
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)list);
            return ammo;
        }
        ItemIIBulletMagazine.makeDefault(stack);
        return ItemStack.field_190927_a;
    }

    public static boolean hasNoBullets(ItemStack stack) {
        int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
        NonNullList cartridge = Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("bullets", 10), (int)bc);
        return ((ItemStack)cartridge.get(0)).func_190926_b();
    }

    public static int getBulletCapactity(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 48;
            }
            case 1: {
                return 24;
            }
            case 2: {
                return 16;
            }
        }
        return 0;
    }

    public static boolean matchesMagazine(ItemStack stack, String casing) {
        switch (stack.func_77960_j()) {
            case 0: {
                return casing.equals("machinegun_2bCal");
            }
            case 1: {
                return casing.equals("submachinegun_1bCal");
            }
            case 2: {
                return casing.equals("revolver_1bCal");
            }
        }
        return false;
    }

    public static ItemStack getMagazine(String type, ItemStack bullet1, ItemStack bullet2, ItemStack bullet3, ItemStack bullet4) {
        ItemStack stack = new ItemStack((Item)CommonProxy.item_bullet_magazine, 1, CommonProxy.item_bullet_magazine.getMetaBySubname(type));
        NonNullList l = NonNullList.func_191197_a((int)ItemIIBulletMagazine.getBulletCapactity(stack), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < l.size(); ++i) {
            int t = i % 4;
            l.set(i, (Object)(t == 0 ? bullet1 : (t == 1 ? bullet2 : (t == 2 ? bullet3 : bullet4))));
        }
        NBTTagList list = Utils.writeInventory((Collection)l);
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)list);
        ItemIIBulletMagazine.makeDefault(stack);
        return stack;
    }

    public String getModelCacheKey(ItemStack stack) {
        return this.subNames[stack.func_77960_j()] + "_" + this.checkColours(stack);
    }

    public int checkColours(ItemStack stack) {
        ItemIIBulletMagazine.makeDefault(stack);
        int num = 0;
        num += ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0") != -1 ? 1 : 0;
        num += ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1") != -1 ? 1 : 0;
        num += ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2") != -1 ? 1 : 0;
        return num += ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3") != -1 ? 1 : 0;
    }

    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> l = new ArrayList<ResourceLocation>();
        String name = this.getSubNames()[stack.func_77960_j()];
        l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/main"));
        if (ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0") != -1) {
            l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet0"));
            l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint0"));
            if (ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1") != -1) {
                l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet1"));
                l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint1"));
                if (ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2") != -1) {
                    l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet2"));
                    l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint2"));
                    if (ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3") != -1) {
                        l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet3"));
                        l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint3"));
                    }
                }
            }
        }
        return l;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        if (!stack.func_77942_o()) {
            ItemIIBulletMagazine.makeDefault(stack);
        }
        switch (pass) {
            case 2: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0");
            }
            case 4: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1");
            }
            case 6: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2");
            }
            case 8: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3");
            }
        }
        return -1;
    }
}

