/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCasingType;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCoreType;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIBullet
extends ItemIIBase
implements IEItemInterfaces.ITextureOverride {
    public ItemIIBullet() {
        super("bullet", 32, new String[0]);
    }

    public static void makeDefault(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"casing")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"casing", (String)"artillery_8bCal");
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)"CoreBrass");
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponent")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"firstComponent", (String)"empty");
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponentQuantity")) {
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"firstComponentQuantity", (float)0.0f);
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponent")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"secondComponent", (String)"empty");
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponentQuantity")) {
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"secondComponentQuantity", (float)0.0f);
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponentNBT")) {
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"firstComponentNBT", (NBTTagCompound)new NBTTagCompound());
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponentNBT")) {
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"secondComponentNBT", (NBTTagCompound)new NBTTagCompound());
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour", (int)0);
        }
    }

    public static IBulletCasingType getCasing(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"casing")) {
            ItemIIBullet.makeDefault(stack);
        }
        return BulletRegistry.INSTANCE.getCasing(ItemNBTHelper.getString((ItemStack)stack, (String)"casing"));
    }

    public static IBulletCoreType getCore(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            ItemIIBullet.makeDefault(stack);
        }
        return BulletRegistry.INSTANCE.getCore(ItemNBTHelper.getString((ItemStack)stack, (String)"core"));
    }

    public static boolean hasFirstComponent(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponent") && BulletRegistry.INSTANCE.getComponent(ItemNBTHelper.getString((ItemStack)stack, (String)"firstComponent")) != null;
    }

    public static boolean hasSecondComponent(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponent") && BulletRegistry.INSTANCE.getComponent(ItemNBTHelper.getString((ItemStack)stack, (String)"secondComponent")) != null;
    }

    public static boolean hasCore(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"core") && BulletRegistry.INSTANCE.getCore(ItemNBTHelper.getString((ItemStack)stack, (String)"core")) != null;
    }

    public static boolean hasColour(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour");
    }

    public static int getColour(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour");
    }

    public static IBulletComponent getFirstComponent(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponent")) {
            ItemIIBullet.makeDefault(stack);
        }
        return BulletRegistry.INSTANCE.getComponent(ItemNBTHelper.getString((ItemStack)stack, (String)"firstComponent"));
    }

    public static IBulletComponent getSecondComponent(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponent")) {
            ItemIIBullet.makeDefault(stack);
        }
        return BulletRegistry.INSTANCE.getComponent(ItemNBTHelper.getString((ItemStack)stack, (String)"secondComponent"));
    }

    public static float getFirstComponentQuantity(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponentQuantity")) {
            ItemIIBullet.makeDefault(stack);
        }
        return ItemNBTHelper.getFloat((ItemStack)stack, (String)"firstComponentQuantity");
    }

    public static float getSecondComponentQuantity(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponentQuantity")) {
            ItemIIBullet.makeDefault(stack);
        }
        return ItemNBTHelper.getFloat((ItemStack)stack, (String)"secondComponentQuantity");
    }

    public static NBTTagCompound getFirstComponentNBT(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"firstComponentNBT")) {
            ItemIIBullet.makeDefault(stack);
        }
        return ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"firstComponentNBT");
    }

    public static NBTTagCompound getSecondComponentNBT(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"secondComponentNBT")) {
            ItemIIBullet.makeDefault(stack);
        }
        return ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"secondComponentNBT");
    }

    public static float getMass(ItemStack stack) {
        return ItemIIBullet.getCasing(stack).getInitialMass() + (ItemIIBullet.getCore(stack) != null ? ItemIIBullet.getCore(stack).getDensity() * ItemIIBullet.getCasing(stack).getInitialMass() : 0.0f) + (ItemIIBullet.getFirstComponent(stack) != null ? ItemIIBullet.getCasing(stack).getComponentCapacity() * (ItemIIBullet.getFirstComponent(stack).getDensity() * ItemIIBullet.getFirstComponentQuantity(stack)) : 0.0f) + (ItemIIBullet.getSecondComponent(stack) != null ? ItemIIBullet.getCasing(stack).getComponentCapacity() * (ItemIIBullet.getSecondComponent(stack).getDensity() * ItemIIBullet.getSecondComponentQuantity(stack)) : 0.0f);
    }

    public static ItemStack getAmmoStack(int amount, String casing, String core, String component1, String component2, float proportion, float amount1, float amount2) {
        proportion = Math.min(Math.max(proportion, 0.0f), 1.0f);
        ItemStack stack = new ItemStack((Item)CommonProxy.item_bullet, amount);
        ItemIIBullet.makeDefault(stack);
        if (BulletRegistry.INSTANCE.getCasing(casing) == null) {
            return ItemStack.field_190927_a;
        }
        ItemNBTHelper.setString((ItemStack)stack, (String)"casing", (String)casing);
        if (core != null && !core.equals("empty")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        }
        if (!component1.equals("empty")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"firstComponent", (String)component1);
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"firstComponentQuantity", (float)(proportion * amount1));
        }
        if (!component2.equals("empty")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"secondComponent", (String)component2);
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"secondComponentQuantity", (float)((1.0f - proportion) * amount2));
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"colour", (int)Color.HSBtoRGB((float)Math.random(), 0.9f, 0.45f));
        return stack;
    }

    public static ItemStack getAmmoStack(int amount, String casing, String core, String component1, String component2, float proportion) {
        return ItemIIBullet.getAmmoStack(amount, casing, core, component1, component2, proportion, 1.0f, 1.0f);
    }

    public static int getTrailColour(ItemStack stack) {
        int col1 = -1;
        int col2 = -1;
        if (ItemIIBullet.hasFirstComponent(stack) && ItemIIBullet.getFirstComponent(stack).hasTrail()) {
            col1 = ItemIIBullet.getFirstComponent(stack).getTrailColour(ItemIIBullet.getFirstComponentNBT(stack));
        }
        if (ItemIIBullet.hasSecondComponent(stack) && ItemIIBullet.getSecondComponent(stack).hasTrail()) {
            col2 = ItemIIBullet.getSecondComponent(stack).getTrailColour(ItemIIBullet.getSecondComponentNBT(stack));
        }
        return col1 != -1 ? col1 : col2;
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemIIBullet.makeDefault(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemIIBullet.getCasing(stack) != null ? ItemIIBullet.getCasing(stack).getStackSize() : 32;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemIIBullet.getFirstComponent(stack) != null) {
            String core_name = "";
            String comp1_name = "";
            String comp2_name = "";
            if (ItemIIBullet.getCore(stack) != null) {
                core_name = I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + ItemIIBullet.getCore(stack).getRole().func_176610_l()), (Object[])new Object[0]);
                tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.core", (Object[])new Object[]{I18n.func_135052_a((String)("item.immersiveintelligence.bullet.component." + ItemIIBullet.getCore(stack).getName() + ".name"), (Object[])new Object[0])}));
            }
            if (ItemIIBullet.getFirstComponent(stack) != null) {
                comp1_name = I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + ItemIIBullet.getFirstComponent(stack).getRole().func_176610_l()), (Object[])new Object[0]);
            }
            if (ItemIIBullet.getSecondComponent(stack) != null) {
                comp2_name = I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + ItemIIBullet.getSecondComponent(stack).getRole().func_176610_l()), (Object[])new Object[0]);
            }
            tooltip.add(core_name + (!comp1_name.isEmpty() && !comp1_name.equals(core_name) ? " - " + comp1_name : "") + (!comp2_name.isEmpty() && !comp2_name.equals(core_name) && !comp2_name.equals(comp1_name) ? " - " + comp2_name : ""));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.mass", (Object[])new Object[]{Float.valueOf(ItemIIBullet.getMass(stack))}));
        }
        if (ItemIIBullet.getCasing(stack) != null) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.caliber", (Object[])new Object[]{Float.valueOf(ItemIIBullet.getCasing(stack).getSize() * 16.0f)}));
        }
    }

    @Nullable
    public CreativeTabs func_77640_w() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return ItemIIBullet.getCasing(stack) != null ? I18n.func_135052_a((String)("item.immersiveintelligence.bullet." + ItemIIBullet.getCasing(stack).getName() + ".name"), (Object[])new Object[0]) : "immersiveintelligence.item.bullet.null";
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelCacheKey(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"casing")) {
            return ItemNBTHelper.getString((ItemStack)stack, (String)"casing").toLowerCase();
        }
        return "bullet";
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        return Arrays.asList(new ResourceLocation("immersiveintelligence:items/bullets/bullet_" + key + "_main"), new ResourceLocation("immersiveintelligence:items/bullets/bullet_" + key + "_core"), new ResourceLocation("immersiveintelligence:items/bullets/bullet_" + key + "_paint"));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch (pass) {
            case 1: {
                if (!ItemIIBullet.hasCore(stack)) break;
                return ItemIIBullet.getCore(stack).getColour();
            }
            case 2: {
                if (!ItemIIBullet.hasColour(stack)) break;
                return ItemIIBullet.getColour(stack);
            }
        }
        return -1;
    }

    public boolean isGrenade(ItemStack stack) {
        return ItemIIBullet.getCasing(stack).isThrowable();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isGrenade(stack) ? EnumAction.BOW : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return Math.round(60.0f * ItemIIBullet.getMass(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (this.isGrenade(player.func_184586_b(hand))) {
            ItemStack itemstack = player.func_184586_b(hand);
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (!world.field_72995_K) {
            double true_angle = Math.toRadians(360.0f - entityLiving.field_70759_as);
            double true_angle2 = Math.toRadians(-entityLiving.field_70125_A);
            Vec3d gun_end = Utils.offsetPosDirection(1.0f, true_angle, true_angle2);
            EntityBullet a = new EntityBullet(world, entityLiving.field_70165_t + gun_end.field_72450_a, entityLiving.field_70163_u + (double)entityLiving.func_70047_e() + gun_end.field_72448_b, entityLiving.field_70161_v + gun_end.field_72449_c, entityLiving, stack);
            float distance = 0.65f * (((float)this.func_77626_a(stack) - (float)timeLeft) / (float)this.func_77626_a(stack));
            a.field_70159_w = (double)distance * gun_end.field_72450_a;
            a.field_70181_x = (double)distance * gun_end.field_72448_b;
            a.field_70179_y = (double)distance * gun_end.field_72449_c;
            ImmersiveIntelligence.logger.info((Object)Float.valueOf(entityLiving.field_70125_A));
            a.field_70170_p.func_72838_d((Entity)a);
            if (!(entityLiving instanceof EntityPlayer) || !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }
}

