/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIAssemblyScheme
extends ItemIIBase {
    public ItemIIAssemblyScheme() {
        super("assembly_scheme", 8, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        ItemStack s = ItemNBTHelper.getItemStack((ItemStack)stack, (String)"recipeItem");
        list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.used_to_create", (Object[])new Object[]{s.func_82833_r() + (s.func_190916_E() > 1 ? " x" + s.func_190916_E() : "")}));
        list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.items_created", (Object[])new Object[]{ItemNBTHelper.getInt((ItemStack)stack, (String)"createdItems")}));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.materials", (Object[])new Object[0]));
            PrecissionAssemblerRecipe recipe = this.getRecipeForStack(stack);
            if (recipe != null) {
                for (IngredientStack ingredient : recipe.inputs) {
                    list.add(ingredient.getExampleStack().func_82833_r() + (ingredient.inputSize > 1 ? " x" + ingredient.inputSize : ""));
                }
            }
        } else if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.tools", (Object[])new Object[0]));
            PrecissionAssemblerRecipe recipe = this.getRecipeForStack(stack);
            if (recipe != null) {
                for (String tool : recipe.tools) {
                    list.add(PrecissionAssemblerRecipe.getExampleToolStack(tool).func_82833_r());
                }
            }
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.info_hold1", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.assembly_scheme.info_hold2", (Object[])new Object[0]));
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"createdItems")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"createdItems", (int)0);
        }
    }

    public ItemStack getStackForRecipe(PrecissionAssemblerRecipe recipe) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("recipeItem", (NBTBase)recipe.output.serializeNBT());
        stack.func_77982_d(tag);
        return stack;
    }

    public ItemStack getProducedStack(ItemStack scheme) {
        if (ItemNBTHelper.hasKey((ItemStack)scheme, (String)"recipeItem")) {
            return new ItemStack(ItemNBTHelper.getTagCompound((ItemStack)scheme, (String)"recipeItem"));
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public PrecissionAssemblerRecipe getRecipeForStack(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"recipeItem");
        ItemStack recipe_stack = new ItemStack(tag);
        for (PrecissionAssemblerRecipe recipe : PrecissionAssemblerRecipe.recipeList) {
            if (!recipe.output.func_77969_a(recipe_stack)) continue;
            return recipe;
        }
        return null;
    }

    public void increaseCreatedItems(ItemStack stack, int amount) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"createdItems", (int)(ItemNBTHelper.getInt((ItemStack)stack, (String)"createdItems") + amount));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (PrecissionAssemblerRecipe recipe : PrecissionAssemblerRecipe.recipeList) {
                ItemStack stack = new ItemStack((Item)this);
                ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"recipeItem", (NBTTagCompound)recipe.output.serializeNBT());
                list.add((Object)stack);
            }
        }
    }
}

