/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.bullets;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.client.ClientUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.common.IIDamageSources;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBullet;

public class EntityBullet
extends Entity
implements IEntityAdditionalSpawnData {
    private static int fuse = 600;
    public EntityLivingBase owner;
    public ItemStack stack;
    public String name;
    public int colourCore = 0;
    public int colourPaint = 0;
    public int colourTrail = -1;
    private float size = 0.0f;
    private float penetrationPower = 0.0f;
    private float mass = 0.0f;
    @SideOnly(value=Side.CLIENT)
    private boolean playedFlybySound;

    public EntityBullet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.stack = ItemIIBullet.getAmmoStack(1, "artillery_8bCal", "CoreSteel", "TNT", "", 1.0f);
    }

    public EntityBullet(World world, double x, double y, double z, EntityLivingBase shooter, ItemStack stack) {
        this(world);
        this.owner = shooter;
        this.stack = stack.func_77946_l();
        this.func_70107_b(x, y, z);
        this.setParams();
        ItemIIBullet.getCasing(stack).doPuff(this);
        this.func_184224_h(false);
    }

    public float getSize() {
        return this.size;
    }

    public void setFuse(int fuse) {
        EntityBullet.fuse = fuse;
    }

    protected void func_70088_a() {
    }

    private void setParams() {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() instanceof ItemIIBullet) {
            this.mass = ItemIIBullet.getMass(this.stack);
            float first_pen = 0.0f;
            float second_pen = 0.0f;
            float core_pen = 0.0f;
            this.penetrationPower = ItemIIBullet.getCasing(this.stack).getPenetration();
            if (ItemIIBullet.hasCore(this.stack)) {
                core_pen = ItemIIBullet.getCore(this.stack).getPenetrationModifier(new NBTTagCompound());
            }
            if (ItemIIBullet.hasFirstComponent(this.stack)) {
                first_pen = ItemIIBullet.getFirstComponent(this.stack).getPenetrationModifier(ItemIIBullet.getFirstComponentNBT(this.stack));
            }
            if (ItemIIBullet.hasSecondComponent(this.stack)) {
                second_pen = ItemIIBullet.getSecondComponent(this.stack).getPenetrationModifier(ItemIIBullet.getSecondComponentNBT(this.stack));
            }
            this.penetrationPower = core_pen + first_pen + second_pen;
            this.penetrationPower *= ItemIIBullet.getCasing(this.stack).getPenetration();
            this.size = ItemIIBullet.getCasing(this.stack).getSize();
            this.name = ItemIIBullet.getCasing(this.stack).getName();
            this.colourCore = ItemIIBullet.getCore(this.stack).getColour();
            this.colourPaint = ItemIIBullet.getColour(this.stack);
            this.colourTrail = ItemIIBullet.getTrailColour(this.stack);
            this.func_70105_a(0.625f * this.size, 0.625f * this.size);
        }
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > fuse) {
            this.func_70106_y();
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.onUpdateClient();
        }
        boolean canMove = true;
        Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult mop = this.field_70170_p.func_147447_a(currentPos, nextPos, false, true, false);
        if (mop == null || mop.field_72308_g == null) {
            Entity entity = null;
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), e -> e.func_70067_L());
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || this.field_70173_aa <= 1) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(currentPos, nextPos);
                if (movingobjectposition1 == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                mop = new RayTraceResult(entity);
            }
        }
        if (mop != null && this.onImpact(mop)) {
            this.func_70106_y();
        }
        float drag = 0.99f;
        float gravity_part = 0.02f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float bubbleMotion = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)bubbleMotion, this.field_70163_u - this.field_70181_x * (double)bubbleMotion, this.field_70161_v - this.field_70179_y * (double)bubbleMotion, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            drag = 0.8f;
        }
        this.field_70159_w *= (double)drag;
        this.field_70181_x *= (double)drag;
        this.field_70179_y *= (double)drag;
        this.penetrationPower *= drag;
        this.field_70181_x -= (double)(gravity_part * this.mass);
        if (this.colourTrail != -1) {
            float[] colors = Utils.rgbIntToRGB(this.colourTrail);
            ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, this.size * 4.0f, colors[0], colors[1], colors[2]);
        }
        if (canMove) {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float motionXZ = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionXZ) * 180.0 / 3.1415927410125732);
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onUpdateClient() {
        if (this.func_174818_b(ClientUtils.mc().field_71439_g.func_180425_c()) < (double)(this.size * 15.0f) && !this.playedFlybySound) {
            this.playedFlybySound = true;
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74782_a("stack", (NBTBase)this.stack.serializeNBT());
        if (this.owner == null) {
            tag.func_74778_a("owner", "null");
        } else {
            tag.func_74778_a("owner", this.owner.func_70005_c_());
        }
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("colourCore", this.colourCore);
        tag.func_74768_a("colourPaint", this.colourPaint);
    }

    public void func_70037_a(NBTTagCompound tag) {
        String ownerName = tag.func_74779_i("owner");
        if (tag.func_74764_b("stack")) {
            this.stack = new ItemStack(tag.func_74775_l("stack"));
        }
        if (ownerName != null && !ownerName.equals("null")) {
            this.owner = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(ownerName);
        }
        this.name = tag.func_74779_i("name");
        this.colourCore = tag.func_74762_e("colourCore");
        this.colourPaint = tag.func_74762_e("colourPaint");
    }

    public void writeSpawnData(ByteBuf data) {
        this.setParams();
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.stack);
        if (this.owner == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)"null");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.owner.func_70005_c_());
        }
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.name);
        data.writeInt(this.colourCore);
        data.writeInt(this.colourPaint);
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.field_70159_w = data.readDouble();
            this.field_70181_x = data.readDouble();
            this.field_70179_y = data.readDouble();
            this.stack = ByteBufUtils.readItemStack((ByteBuf)data);
            String name = ByteBufUtils.readUTF8String((ByteBuf)data);
            for (Object obj : this.field_70170_p.field_72996_f) {
                if (obj == null || !((Entity)obj).func_70005_c_().equals(name)) continue;
                this.owner = (EntityLivingBase)obj;
                break;
            }
            this.name = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.colourCore = data.readInt();
            this.colourPaint = data.readInt();
        }
        catch (Exception e) {
            super.func_70106_y();
        }
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean onImpact(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && !this.stack.func_190926_b() && this.stack.func_77973_b() instanceof ItemIIBullet) {
            if (this.penetrationPower > 0.0f) {
                float f;
                if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                    float penFraction;
                    BlockPos pos = mop.func_178782_a();
                    PenetrationRegistry.IPenetrationHandler pen = null;
                    for (Map.Entry<Predicate<IBlockState>, PenetrationRegistry.IPenetrationHandler> entry : PenetrationRegistry.registeredBlocks.entrySet()) {
                        if (!entry.getKey().test(this.field_70170_p.func_180495_p(pos))) continue;
                        pen = entry.getValue();
                        break;
                    }
                    if (pen == null) {
                        for (Map.Entry<Predicate<IBlockState>, PenetrationRegistry.IPenetrationHandler> entry : PenetrationRegistry.registeredMaterials.entrySet()) {
                            if (!entry.getKey().test((IBlockState)this.field_70170_p.func_180495_p(pos).func_185904_a())) continue;
                            pen = entry.getValue();
                            break;
                        }
                    }
                    float hardness = this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos);
                    f = pen.getDensity();
                    float width = 1.0f;
                    AxisAlignedBB aabb = this.field_70170_p.func_180495_p(pos).func_185900_c((IBlockAccess)this.field_70170_p, pos);
                    switch (EnumFacing.func_176737_a((float)((float)this.field_70159_w), (float)((float)this.field_70181_x), (float)((float)this.field_70179_y))) {
                        case NORTH: 
                        case SOUTH: {
                            width = (float)Math.abs(aabb.field_72336_d - aabb.field_72340_a);
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            width = (float)Math.abs(aabb.field_72334_f - aabb.field_72339_c);
                            break;
                        }
                        case UP: 
                        case DOWN: {
                            width = (float)Math.abs(aabb.field_72337_e - aabb.field_72338_b);
                        }
                    }
                    float hp = pen.getIntegrity() / pen.getDensity();
                    boolean done = false;
                    DimensionBlockPos blockHitPos = new DimensionBlockPos(pos, this.field_70170_p);
                    for (Map.Entry<DimensionBlockPos, Float> p : PenetrationRegistry.blockDamage.entrySet()) {
                        if (!p.getKey().equals((Object)blockHitPos)) continue;
                        blockHitPos = p.getKey();
                        hp = p.getValue().floatValue();
                        done = true;
                        break;
                    }
                    if (!done) {
                        PenetrationRegistry.blockDamage.put(blockHitPos, Float.valueOf(hp));
                    }
                    if ((penFraction = this.penetrationPower / (hardness * width * f)) > 1.0f) {
                        PenetrationHelper.dealBlockDamage(this.field_70170_p, this.size * 50.0f, blockHitPos, hp, pen);
                        this.penetrationPower -= hardness * width * f;
                        float supressionRadius = ItemIIBullet.getCasing(this.stack).getSupressionRadius();
                        int suppressionPower = ItemIIBullet.getCasing(this.stack).getSuppressionPower();
                        PenetrationHelper.supress(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, supressionRadius * (1.0f - penFraction), suppressionPower);
                        this.playHitSound(PenetrationRegistry.HitEffect.PENETRATION, this.field_70170_p, pos, pen);
                    } else if (this.penetrationPower > 0.01f && penFraction < 0.125f && f >= 1.0f) {
                        this.penetrationPower = 0.01f;
                        this.field_70159_w *= -0.125;
                        this.field_70179_y *= -0.125;
                        this.field_70181_x *= -0.25;
                        double newPitch = 90.0f - Math.abs(this.field_70125_A);
                        if (this.field_70125_A < 0.0f) {
                            this.field_70125_A = (float)((double)this.field_70125_A - 2.0 * newPitch);
                        } else if (this.field_70125_A > 0.0f) {
                            this.field_70125_A = (float)((double)this.field_70125_A + 2.0 * newPitch);
                        }
                        float supressionRadius = ItemIIBullet.getCasing(this.stack).getSupressionRadius();
                        int suppressionPower = ItemIIBullet.getCasing(this.stack).getSuppressionPower();
                        PenetrationHelper.supress(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, supressionRadius, suppressionPower);
                        this.playHitSound(PenetrationRegistry.HitEffect.PARTIAL_PENETRATION, this.field_70170_p, pos, pen);
                    } else {
                        PenetrationHelper.dealBlockDamage(this.field_70170_p, this.size * penFraction * 50.0f, blockHitPos, hp, pen);
                        this.playHitSound(PenetrationRegistry.HitEffect.PENETRATION, this.field_70170_p, pos, pen);
                        this.penetrationPower = 0.0f;
                    }
                }
                if (mop.field_72308_g != null) {
                    boolean headshot = false;
                    if (mop.field_72308_g instanceof EntityLivingBase) {
                        headshot = blusunrize.immersiveengineering.common.util.Utils.isVecInEntityHead((EntityLivingBase)((EntityLivingBase)mop.field_72308_g), (Vec3d)new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
                    }
                    float core_damage = ItemIIBullet.getCasing(this.stack).getDamage() * (ItemIIBullet.hasCore(this.stack) ? ItemIIBullet.getCore(this.stack).getDamageModifier(null) : 1.0f);
                    float first_dmg = ItemIIBullet.hasFirstComponent(this.stack) ? ItemIIBullet.getFirstComponent(this.stack).getDamageModifier(ItemIIBullet.getFirstComponentNBT(this.stack)) : 0.0f;
                    f = ItemIIBullet.hasSecondComponent(this.stack) ? ItemIIBullet.getSecondComponent(this.stack).getDamageModifier(ItemIIBullet.getSecondComponentNBT(this.stack)) : 0.0f;
                    float damage = (float)((double)(core_damage * (1.0f + first_dmg + f)) * (headshot ? 1.25 : 1.0));
                    if (mop.field_72308_g.func_70097_a(IIDamageSources.causeBulletDamage(this, (Entity)this.owner), damage)) {
                        mop.field_72308_g.field_70172_ad = 0;
                    }
                    Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                    this.penetrationPower = Math.max(0.0f, this.penetrationPower - damage / 3.0f);
                    this.func_174828_a(new BlockPos(nextPos), this.field_70177_z, this.field_70125_A);
                }
            }
            if (this.penetrationPower <= 0.0f) {
                if (ItemIIBullet.hasFirstComponent(this.stack)) {
                    ItemIIBullet.getFirstComponent(this.stack).onExplosion(ItemIIBullet.getCore(this.stack).getExplosionModifier() * ItemIIBullet.getCasing(this.stack).getComponentCapacity() * ItemIIBullet.getFirstComponentQuantity(this.stack), ItemIIBullet.getFirstComponentNBT(this.stack), this.field_70170_p, this.func_180425_c(), this);
                }
                if (ItemIIBullet.hasSecondComponent(this.stack)) {
                    ItemIIBullet.getSecondComponent(this.stack).onExplosion(ItemIIBullet.getCore(this.stack).getExplosionModifier() * ItemIIBullet.getCasing(this.stack).getComponentCapacity() * ItemIIBullet.getSecondComponentQuantity(this.stack), ItemIIBullet.getSecondComponentNBT(this.stack), this.field_70170_p, this.func_180425_c(), this);
                }
                return true;
            }
        }
        return false;
    }

    private void playHitSound(PenetrationRegistry.HitEffect effect, World world, BlockPos pos, PenetrationRegistry.IPenetrationHandler handler) {
        IBlockState state = world.func_180495_p(pos);
        SoundEvent event = handler.getSpecialSound(effect);
        if (event == null) {
            SoundType type = state.func_177230_c().getSoundType(state, world, pos, (Entity)this);
            event = effect == PenetrationRegistry.HitEffect.PENETRATION ? type.func_185845_c() : type.func_185844_d();
        }
        world.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, event, SoundCategory.BLOCKS, 0.5f, (float)(0.5 + Math.random() * 0.5), true);
    }
}

