/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.ISkyCrateConnector;
import pl.pabilo8.immersiveintelligence.api.utils.ISkycrateMount;

public class EntitySkyCrate
extends Entity
implements ITeslaEntity {
    private static final DataParameter<NBTTagCompound> dataMarkerMount = EntityDataManager.func_187226_a(EntitySkyCrate.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<NBTTagCompound> dataMarkerCrate = EntityDataManager.func_187226_a(EntitySkyCrate.class, (DataSerializer)DataSerializers.field_192734_n);
    public final Set<BlockPos> ignoreCollisions = new HashSet<BlockPos>();
    public ImmersiveNetHandler.Connection connection;
    public double linePos = 0.0;
    public ItemStack mount = ItemStack.field_190927_a;
    public ItemStack crate = ItemStack.field_190927_a;
    public double horizontalSpeedPowered = 0.0;
    public double horizontalSpeedUnpowered = 0.0;
    public double energy;

    public EntitySkyCrate(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntitySkyCrate(World world, ImmersiveNetHandler.Connection connection, ItemStack mount, ItemStack crate, BlockPos firstPos) {
        this(world);
        if (!world.field_72995_K) {
            this.setConnection(connection, firstPos, this.linePos);
            this.setSkycrate(mount, crate);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarkerCrate, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(dataMarkerMount, (Object)new NBTTagCompound());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.crate = new ItemStack((NBTTagCompound)this.field_70180_af.func_187225_a(dataMarkerCrate));
            this.mount = new ItemStack((NBTTagCompound)this.field_70180_af.func_187225_a(dataMarkerMount));
        } else if (this.linePos >= 1.0) {
            boolean success = false;
            if (this.field_70170_p.func_175625_s(this.connection.end) instanceof ISkyCrateConnector) {
                success = ((ISkyCrateConnector)this.field_70170_p.func_175625_s(this.connection.end)).onSkycrateMeeting(this);
            }
            if (!success) {
                if (this.crate.func_77973_b() instanceof ItemBlock) {
                    ItemBlock b = (ItemBlock)this.crate.func_77973_b();
                    EntityFallingBlock e = new EntityFallingBlock(this.field_70170_p, (double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70165_t), b.func_179223_d().func_176223_P());
                    this.field_70170_p.func_72838_d((Entity)e);
                    e.field_145812_b = -1;
                } else {
                    Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.crate.func_77946_l());
                }
                Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.mount.func_77946_l());
                this.func_70106_y();
            }
        } else if (this.field_70170_p.func_175625_s(this.func_180425_c()) instanceof ISkyCrateConnector) {
            this.nextPos();
        } else {
            this.nextPos();
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("crate")) {
            this.crate = new ItemStack(compound.func_74775_l("crate"));
        }
        if (compound.func_74764_b("mount")) {
            this.mount = new ItemStack(compound.func_74775_l("mount"));
        }
        if (compound.func_74764_b("connection")) {
            this.connection = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)compound.func_74775_l("connection"));
        } else if (this.connection == null) {
            this.func_70106_y();
        }
        this.linePos = compound.func_74769_h("linePos");
        this.energy = compound.func_74769_h("energy");
        this.setSkycrate(this.mount, this.crate);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("crate", (NBTBase)this.crate.serializeNBT());
        compound.func_74782_a("mount", (NBTBase)this.mount.serializeNBT());
        compound.func_74780_a("linePos", this.linePos);
        compound.func_74780_a("energy", this.energy);
        compound.func_74782_a("connection", (NBTBase)this.connection.writeToNBT());
    }

    public void setSkycrate(ItemStack mount, ItemStack crate) {
        this.mount = mount.func_77946_l();
        this.crate = crate.func_77946_l();
        if (mount.func_77973_b() instanceof ISkycrateMount) {
            ISkycrateMount s = (ISkycrateMount)mount.func_77973_b();
            this.energy = s.getMountEnergy(mount);
            this.horizontalSpeedPowered = s.getPoweredSpeed(mount);
            this.horizontalSpeedUnpowered = s.getUnpoweredSpeed(mount);
        }
        this.field_70180_af.func_187227_b(dataMarkerCrate, (Object)crate.serializeNBT());
        this.field_70180_af.func_187227_b(dataMarkerMount, (Object)mount.serializeNBT());
    }

    public void setConnection(ImmersiveNetHandler.Connection connection, BlockPos firstPos, double linePos) {
        this.connection = connection.start.equals((Object)firstPos) ? connection : ImmersiveNetHandler.INSTANCE.getReverseConnection(this.field_70170_p.field_73011_w.getDimension(), connection);
        this.linePos = linePos;
        try {
            Vec3d v = this.connection.getVecAt(this.linePos);
            this.func_70107_b((double)firstPos.func_177958_n() + v.field_72450_a, (double)firstPos.func_177956_o() + v.field_72448_b, (double)firstPos.func_177952_p() + v.field_72449_c);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.field_70170_p.func_175625_s(connection.start) instanceof IImmersiveConnectable && this.field_70170_p.func_175625_s(connection.end) instanceof IImmersiveConnectable) {
            this.ignoreCollisions.addAll(((IImmersiveConnectable)this.field_70170_p.func_175625_s(connection.start)).getIgnored((IImmersiveConnectable)this.field_70170_p.func_175625_s(connection.end)));
        }
    }

    public void nextPos() {
        if (this.connection != null && !this.field_70170_p.field_72995_K) {
            block3: {
                double speed = this.getSpeed();
                this.linePos += speed / (double)this.connection.length;
                try {
                    Vec3d pos = this.connection.getVecAt(this.linePos).func_178787_e(new Vec3d((Vec3i)this.connection.start));
                    this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    this.func_70101_b((float)Math.atan2(pos.field_72449_c, pos.field_72450_a), (float)this.connection.getSlopeAt(this.linePos));
                }
                catch (NullPointerException e) {
                    if (this.field_70173_aa <= 10) break block3;
                    this.func_70106_y();
                }
            }
            this.linePos = MathHelper.func_151237_a((double)this.linePos, (double)0.0, (double)1.0);
        }
    }

    public ImmersiveNetHandler.Connection getConnection() {
        return this.connection;
    }

    public double getSpeed() {
        return this.energy > 0.0 ? this.horizontalSpeedPowered : this.horizontalSpeedUnpowered;
    }

    public void onHit(TileEntity teslaCoil, boolean lowPower) {
        if (!this.field_70170_p.field_72995_K) {
            if (((ISkycrateMount)this.mount.func_77973_b()).isTesla(this.mount)) {
                int cap = (int)Math.floor((float)Config.IEConfig.Machines.teslacoil_consumption_active * (lowPower ? 0.5f : 1.0f) / (float)Config.IIConfig.Tools.SkycrateMounts.electric_energy_ratio);
                this.energy = Math.min(this.energy + (double)cap, ((ISkycrateMount)this.mount.func_77973_b()).getMountMaxEnergy(this.mount));
            } else {
                this.func_70106_y();
            }
        }
    }
}

