/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.camera.CameraHandler;
import pl.pabilo8.immersiveintelligence.api.utils.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_StoneDecoration;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBullet;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageMachinegunSync;

public class EntityMachinegun
extends Entity
implements IEntityAdditionalSpawnData {
    public static MachinegunZoom scope = new MachinegunZoom();
    public ItemStack gun;
    public ItemStack magazine1 = ItemStack.field_190927_a;
    public ItemStack magazine2 = ItemStack.field_190927_a;
    public int pickProgress = 0;
    public int bulletDelay = 0;
    public int bulletDelayMax = 0;
    public int clipReload = 0;
    public int setupTime = Config.IIConfig.Weapons.Machinegun.setupTime;
    public int maxSetupTime = Config.IIConfig.Weapons.Machinegun.setupTime;
    public int overheating = 0;
    public float setYaw = 0.0f;
    public float recoilYaw = 0.0f;
    public float recoilPitch = 0.0f;
    public float gunYaw = 0.0f;
    public float gunPitch = 0.0f;
    public float maxRecoilPitch = Config.IIConfig.Weapons.Machinegun.recoilHorizontal;
    public float maxRecoilYaw = Config.IIConfig.Weapons.Machinegun.recoilVertical;
    public float currentlyLoaded = -1.0f;
    public boolean shoot = false;
    public boolean aiming = false;
    public boolean hasSecondMag = false;
    public boolean mag1Empty = false;
    public boolean mag2Empty = false;
    public boolean hasInfrared = false;
    public boolean loadedFromCrate = false;
    public boolean overheated = false;
    AxisAlignedBB aabb = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 0.65, 0.85);

    public EntityMachinegun(World worldIn) {
        super(worldIn);
    }

    public EntityMachinegun(World world, BlockPos pos, float yaw, float pitch, ItemStack stack) {
        super(world);
        float height = 0.0f;
        this.gun = stack.func_77946_l();
        this.func_70105_a(0.5f, 0.5f);
        if (blusunrize.immersiveengineering.common.util.Utils.isBlockAt((World)world, (BlockPos)pos, CommonProxy.block_stone_decoration, (int)IIBlockTypes_StoneDecoration.SANDBAGS.getMeta())) {
            height = -0.25f;
        }
        this.func_70080_a((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f + height, (float)pos.func_177952_p() + 0.5f, yaw, pitch);
        this.setYaw = yaw;
        this.getConfigFromItem(stack);
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.aabb.func_186670_a(this.func_180425_c());
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void func_70015_d(int seconds) {
    }

    public boolean func_184186_bw() {
        return false;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 10L == 0L && this.field_70170_p.func_180495_p(this.func_180425_c().func_177972_a(EnumFacing.DOWN)).func_185904_a().equals(Material.field_151579_a)) {
            this.dropItem();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.hasInfrared && this.func_184188_bt().size() > 0 && this.func_184188_bt().get(0) != null && this.field_70170_p.func_82737_E() % 20L == 0L && this.aiming && this.func_184188_bt().get(0) instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)this.func_184188_bt().get(0);
            boolean energy = false;
            for (ItemStack stack : ent.func_184193_aE()) {
                int out;
                if (!EnergyHelper.isFluxItem((ItemStack)stack) || (out = EnergyHelper.extractFlux((ItemStack)stack, (int)(Config.IIConfig.Weapons.Machinegun.infraredScopeEnergyUsage * 20), (boolean)false)) <= 0) continue;
                ent.func_70690_d(new PotionEffect(MobEffects.field_76439_r, Math.round((float)out / (float)Config.IIConfig.Weapons.Machinegun.infraredScopeEnergyUsage * 1.25f), 2, true, false));
                break;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 120L == 0L) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("forClient", true);
            this.func_70014_b(tag);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachinegunSync(this, tag), Utils.targetPointFromEntity(this, 24));
        }
        if (this.func_184188_bt().size() > 0 && this.func_184188_bt().get(0) != null) {
            if (this.recoilPitch != 0.0f || this.recoilYaw != 0.0f) {
                this.recoilPitch /= 2.0f;
                this.recoilYaw /= 2.0f;
                if (this.recoilPitch < 0.5f && this.recoilPitch > -0.5f) {
                    this.recoilPitch = 0.0f;
                }
                if (this.recoilYaw < 0.5f && this.recoilYaw > -0.5f) {
                    this.recoilYaw = 0.0f;
                }
            }
            if (this.func_184188_bt().get(0) instanceof EntityLivingBase) {
                EntityLivingBase psg = (EntityLivingBase)this.func_184188_bt().get(0);
                if (this.setupTime < 1) {
                    this.doRotationsWithPlayer(psg);
                    if (this.magazine1.func_190926_b()) {
                        this.mag1Empty = true;
                    }
                    if (this.hasSecondMag && this.magazine2.func_190926_b()) {
                        this.mag2Empty = true;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        if (!this.overheated && this.shoot && this.clipReload == 0) {
                            if (this.bulletDelay < 1) {
                                if (!this.loadedFromCrate) {
                                    if (this.hasSecondMag && !this.mag2Empty) {
                                        boolean bl = this.mag2Empty = !this.shoot(2);
                                    }
                                    if (!this.mag1Empty) {
                                        this.mag1Empty = !this.shoot(1);
                                    }
                                }
                            } else {
                                --this.bulletDelay;
                            }
                        }
                        if (this.overheating > Config.IIConfig.Weapons.Machinegun.maxOverheat) {
                            this.overheated = true;
                        }
                        this.overheating = Math.max(0, this.overheating - 1);
                        if (this.overheated && this.overheating == 0) {
                            this.overheated = false;
                        }
                    }
                    if (!this.shoot && !this.loadedFromCrate && (this.mag1Empty || this.mag2Empty)) {
                        boolean b1 = false;
                        boolean b2 = false;
                        if (this.currentlyLoaded == -1.0f || this.currentlyLoaded == 2.0f) {
                            b1 = this.processEmptyMagazine(this.mag2Empty, this.magazine2, psg, EntityEquipmentSlot.OFFHAND, 2);
                        }
                        if (this.currentlyLoaded == -1.0f || this.currentlyLoaded == 1.0f) {
                            b2 = this.processEmptyMagazine(this.mag1Empty, this.magazine1, psg, EntityEquipmentSlot.MAINHAND, 1);
                        }
                        if (!b1 && !b2) {
                            this.currentlyLoaded = -1.0f;
                        }
                    }
                } else {
                    --this.setupTime;
                }
            }
            this.field_70177_z = MathHelper.func_76142_g((float)(this.setYaw + this.gunYaw + this.recoilYaw));
            this.field_70125_A = MathHelper.func_76142_g((float)(this.gunPitch + this.recoilPitch));
        }
        if (this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 2L == 0L) {
            double true_angle = Math.toRadians(360.0f - this.field_70177_z);
            double true_angle2 = Math.toRadians(-this.field_70125_A);
            Vec3d gun_end = Utils.offsetPosDirection(0.6875f, true_angle, true_angle2);
            Vec3d vec3d = Utils.offsetPosDirection(0.1875f, true_angle, true_angle2 + 90.0);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            if (amount > 10.0f || this.pickProgress > 3) {
                this.dropItem();
            } else {
                ++this.pickProgress;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            BlockPos pos = this.func_180425_c();
            double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
            double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
            Vec3d pos2 = Utils.offsetPosDirection(-1.65f, true_angle, 0.0);
            Vec3d pos3 = Utils.offsetPosDirection(-0.25f, true_angle2, 0.0);
            passenger.func_70107_b((double)pos.func_177958_n() + 0.5 + pos2.field_72450_a + pos3.field_72450_a, (double)pos.func_177956_o() - 1.15, (double)pos.func_177952_p() + 0.5 + pos2.field_72449_c + pos3.field_72449_c);
        }
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    boolean processEmptyMagazine(boolean isEmpty, ItemStack magazine, EntityLivingBase entity, EntityEquipmentSlot takeFrom, int setTo) {
        if (isEmpty) {
            if (!magazine.func_190926_b()) {
                if (this.clipReload >= Config.IIConfig.Weapons.Machinegun.clipReloadTime) {
                    this.currentlyLoaded = -1.0f;
                    this.clipReload = 0;
                    ItemStack mag2 = magazine.func_77946_l();
                    ItemIIBulletMagazine.makeDefault(mag2);
                    if (!this.field_70170_p.field_72995_K) {
                        blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)entity.func_180425_c(), (ItemStack)mag2);
                    }
                    this.setMagazineToSlot(setTo, ItemStack.field_190927_a);
                    return true;
                }
                this.currentlyLoaded = setTo;
                ++this.clipReload;
                if (!this.field_70170_p.field_72995_K && this.clipReload < 2) {
                    NBTTagCompound tag = new NBTTagCompound();
                    this.func_70014_b(tag);
                    IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachinegunSync(this, tag), Utils.targetPointFromEntity(this, 24));
                }
                if (!this.field_70170_p.field_72995_K && this.clipReload == 1) {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.machinegun_unload, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            if (this.clipReload == 0) {
                if (entity.func_184582_a(takeFrom).func_77973_b() instanceof ItemIIBulletMagazine) {
                    if (ItemIIBulletMagazine.hasNoBullets(entity.func_184582_a(takeFrom))) {
                        this.currentlyLoaded = -1.0f;
                        return false;
                    }
                    this.clipReload = 1;
                    this.currentlyLoaded = setTo;
                    return true;
                }
            } else {
                if (this.clipReload < Config.IIConfig.Weapons.Machinegun.clipReloadTime) {
                    if (entity.func_184582_a(takeFrom).func_77973_b() instanceof ItemIIBulletMagazine) {
                        ++this.clipReload;
                        this.currentlyLoaded = setTo;
                        if (!this.field_70170_p.field_72995_K && this.clipReload == Math.round((float)Config.IIConfig.Weapons.Machinegun.clipReloadTime * 0.35f)) {
                            this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.machinegun_reload, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        return true;
                    }
                    this.clipReload = 0;
                    this.currentlyLoaded = -1.0f;
                    return false;
                }
                if (entity.func_184582_a(takeFrom).func_77973_b() instanceof ItemIIBulletMagazine) {
                    this.clipReload = 0;
                    this.setMagazineToSlot(setTo, entity.func_184582_a(takeFrom).func_77946_l());
                    entity.func_184201_a(takeFrom, ItemStack.field_190927_a);
                    this.setEmpty(setTo, false);
                    this.currentlyLoaded = -1.0f;
                    if (!this.field_70170_p.field_72995_K) {
                        NBTTagCompound tag = new NBTTagCompound();
                        this.func_70014_b(tag);
                        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachinegunSync(this, tag), Utils.targetPointFromEntity(this, 24));
                    }
                    return true;
                }
                this.clipReload = 0;
                this.currentlyLoaded = -1.0f;
                return false;
            }
        }
        return false;
    }

    void setMagazineToSlot(int mag, ItemStack stack) {
        switch (mag) {
            case 1: {
                this.magazine1 = stack;
                break;
            }
            case 2: {
                this.magazine2 = stack;
            }
        }
    }

    void setEmpty(int mag, boolean is) {
        switch (mag) {
            case 1: {
                this.mag1Empty = is;
                break;
            }
            case 2: {
                this.mag2Empty = is;
            }
        }
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (!compound.func_74764_b("clientMessage")) {
            if (compound.func_74764_b("currentlyLoaded")) {
                this.currentlyLoaded = compound.func_74760_g("currentlyLoaded");
            }
            if (compound.func_74764_b("magazine1")) {
                this.magazine1 = new ItemStack(compound.func_74775_l("magazine1"));
            }
            if (compound.func_74764_b("magazine2")) {
                this.magazine2 = new ItemStack(compound.func_74775_l("magazine2"));
            }
            if (compound.func_74764_b("gun")) {
                this.gun = new ItemStack(compound.func_74775_l("gun"));
                if (!this.field_70170_p.field_72995_K) {
                    this.getConfigFromItem(new ItemStack(compound.func_74775_l("gun")));
                }
            }
            if (compound.func_74764_b("overheating")) {
                this.overheating = compound.func_74762_e("overheating");
            }
            if (compound.func_74764_b("mag1Empty")) {
                this.mag1Empty = compound.func_74767_n("mag1Empty");
            }
            if (compound.func_74764_b("mag2Empty")) {
                this.mag2Empty = compound.func_74767_n("mag2Empty");
            }
            if (compound.func_74764_b("setYaw")) {
                this.setYaw = compound.func_74760_g("setYaw");
            }
            if (compound.func_74764_b("gunYaw")) {
                this.gunYaw = compound.func_74760_g("gunYaw");
            }
            if (compound.func_74764_b("gunPitch")) {
                this.gunPitch = compound.func_74760_g("gunPitch");
            }
            if (compound.func_74764_b("recoilYaw")) {
                this.recoilYaw = compound.func_74760_g("recoilYaw");
            }
            if (compound.func_74764_b("recoilPitch")) {
                this.recoilPitch = compound.func_74760_g("recoilPitch");
            }
            if (compound.func_74764_b("clipReload")) {
                this.clipReload = compound.func_74762_e("clipReload");
            }
            if (compound.func_74764_b("setupTime")) {
                this.setupTime = compound.func_74762_e("setupTime");
            }
            if (compound.func_74764_b("maxSetupTime")) {
                this.maxSetupTime = compound.func_74762_e("maxSetupTime");
            }
        } else {
            if (compound.func_74764_b("shoot")) {
                this.shoot = compound.func_74767_n("shoot");
            }
            if (compound.func_74764_b("aiming")) {
                this.aiming = compound.func_74767_n("aiming");
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("gun", (NBTBase)this.gun.serializeNBT());
        compound.func_74782_a("magazine1", (NBTBase)this.magazine1.serializeNBT());
        compound.func_74782_a("magazine2", (NBTBase)this.magazine2.serializeNBT());
        compound.func_74757_a("mag1Empty", this.mag1Empty);
        compound.func_74757_a("mag2Empty", this.mag2Empty);
        compound.func_74776_a("currentlyLoaded", this.currentlyLoaded);
        compound.func_74768_a("overheating", this.overheating);
        compound.func_74776_a("setYaw", this.setYaw);
        compound.func_74776_a("gunYaw", this.gunYaw);
        compound.func_74776_a("gunPitch", this.gunPitch);
        compound.func_74776_a("recoilYaw", this.recoilYaw);
        compound.func_74776_a("recoilPitch", this.recoilPitch);
        compound.func_74768_a("clipReload", this.clipReload);
        compound.func_74768_a("setupTime", this.setupTime);
        compound.func_74768_a("maxSetupTime", this.maxSetupTime);
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.gun);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.gun = ByteBufUtils.readItemStack((ByteBuf)additionalData);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)additionalData);
        if (tag != null) {
            this.func_70037_a(tag);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af() && player.func_184586_b(hand).func_190926_b()) {
                this.dropItem();
                return true;
            }
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    protected void func_184225_p(Entity passenger) {
        if (this.field_70170_p.field_72995_K && passenger instanceof EntityPlayerSP) {
            CameraHandler.INSTANCE.setEnabled(false);
            ZoomHandler.isZooming = false;
        }
        this.shoot = false;
        this.aiming = false;
        super.func_184225_p(passenger);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_184190_l(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.setYaw));
        float f1 = MathHelper.func_76131_a((float)f, (float)-45.0f, (float)45.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public void doRotationsWithPlayer(EntityLivingBase entity) {
        float true_head_angle = MathHelper.func_76142_g((float)(entity.field_70759_as - this.setYaw));
        if (this.gunYaw < true_head_angle) {
            this.gunYaw += 2.0f;
        } else if (this.gunYaw > true_head_angle) {
            this.gunYaw -= 2.0f;
        }
        if (Math.ceil(this.gunYaw) <= Math.ceil(true_head_angle) + 1.0 && Math.ceil(this.gunYaw) >= Math.ceil(true_head_angle) - 1.0) {
            this.gunYaw = true_head_angle;
        }
        if (this.gunPitch < entity.field_70125_A) {
            this.gunPitch += 1.0f;
        } else if (this.gunPitch > entity.field_70125_A) {
            this.gunPitch -= 1.0f;
        }
        if (Math.ceil(this.gunPitch) <= Math.ceil(entity.field_70125_A) + 1.0 && Math.ceil(this.gunPitch) >= Math.ceil(entity.field_70125_A) - 1.0) {
            this.gunPitch = entity.field_70125_A;
        }
        this.gunYaw = MathHelper.func_76131_a((float)this.gunYaw, (float)-45.0f, (float)45.0f);
        this.gunPitch = MathHelper.func_76131_a((float)this.gunPitch, (float)-20.0f, (float)20.0f);
    }

    public boolean shoot(int magazine) {
        ItemStack stack;
        if (this.func_184188_bt().get(0) == null || !(this.func_184188_bt().get(0) instanceof EntityLivingBase)) {
            return false;
        }
        double true_angle = Math.toRadians(360.0f - this.field_70177_z);
        double true_angle2 = Math.toRadians(-this.field_70125_A);
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("heavy_barrel")) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.machinegun_shot_heavybarrel, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("water_cooling")) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.machinegun_shot_watercooled, SoundCategory.BLOCKS, 1.0f, 0.85f);
        } else {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), IISounds.machinegun_shot, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.bulletDelay = this.bulletDelayMax;
        this.recoilYaw = (float)((double)this.recoilYaw + (Math.random() > 0.5 ? (double)(this.maxRecoilYaw * 2.0f) * Math.random() : (double)(-this.maxRecoilYaw * 2.0f) * Math.random()));
        this.recoilPitch = (float)((double)this.recoilPitch + (double)this.maxRecoilPitch * Math.random());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("forClient", true);
        tag.func_74776_a("recoilYaw", this.recoilYaw);
        tag.func_74776_a("recoilPitch", this.recoilPitch);
        Vec3d gun_end = Utils.offsetPosDirection(0.95f, true_angle, true_angle2);
        Vec3d gun_height = Utils.offsetPosDirection(0.1875f, true_angle, true_angle2 + 90.0);
        ItemStack itemStack = stack = magazine == 1 ? ItemIIBulletMagazine.takeBullet(this.magazine1) : ItemIIBulletMagazine.takeBullet(this.magazine2);
        if (stack.func_190926_b()) {
            if (magazine == 1) {
                this.mag1Empty = true;
            } else if (magazine == 2) {
                this.mag2Empty = true;
            }
            return false;
        }
        tag.func_74757_a("mag1Empty", this.mag1Empty);
        tag.func_74757_a("mag2Empty", this.mag2Empty);
        EntityBullet a = new EntityBullet(this.field_70170_p, this.field_70165_t + 0.85 * (gun_end.field_72450_a + gun_height.field_72450_a), this.field_70163_u + 0.34375 + 0.85 * (gun_end.field_72448_b + gun_height.field_72448_b), this.field_70161_v + 0.85 * (gun_end.field_72449_c + gun_height.field_72449_c), (EntityLivingBase)this.func_184188_bt().get(0), stack);
        float distance = 6.0f;
        a.field_70159_w = (double)distance * gun_end.field_72450_a;
        a.field_70181_x = (double)distance * gun_end.field_72448_b;
        a.field_70179_y = (double)distance * gun_end.field_72449_c;
        a.field_70170_p.func_72838_d((Entity)a);
        ItemStack stack2 = ItemIIBullet.getCasing(stack).getStack(1);
        blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)stack2);
        if (!this.field_70170_p.field_72995_K) {
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachinegunSync(this, tag), Utils.targetPointFromEntity(this, 24));
        }
        return true;
    }

    public void getConfigFromItem(ItemStack stack) {
        this.gun = stack;
        float setup_multiplier = 1.0f;
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("precise_bipod")) {
            setup_multiplier = Config.IIConfig.Weapons.Machinegun.preciseBipodSetupTimeMultiplier;
        } else if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("hasty_bipod")) {
            setup_multiplier = Config.IIConfig.Weapons.Machinegun.hastyBipodSetupTimeMultiplier;
        }
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("belt_fed_loader")) {
            setup_multiplier *= Config.IIConfig.Weapons.Machinegun.beltFedLoaderSetupTimeMultiplier;
        }
        this.maxSetupTime = this.setupTime = Math.round((float)Config.IIConfig.Weapons.Machinegun.setupTime * setup_multiplier);
        float bullet_delay_multiplier = 1.0f;
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("heavy_barrel")) {
            bullet_delay_multiplier = Config.IIConfig.Weapons.Machinegun.heavyBarrelFireRateMultiplier;
        } else if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("water_cooling")) {
            bullet_delay_multiplier = Config.IIConfig.Weapons.Machinegun.waterCoolingFireRateMultiplier;
        }
        this.bulletDelayMax = Math.round(bullet_delay_multiplier * (float)Config.IIConfig.Weapons.Machinegun.bulletFireTime);
        this.bulletDelay = 0;
        float recoil_multiplier_h = 1.0f;
        float recoil_multiplier_w = 1.0f;
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("precise_bipod")) {
            recoil_multiplier_w *= Config.IIConfig.Weapons.Machinegun.preciseBipodRecoilMultiplier;
            recoil_multiplier_h *= Config.IIConfig.Weapons.Machinegun.preciseBipodRecoilMultiplier;
        } else if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("hasty_bipod")) {
            recoil_multiplier_w *= Config.IIConfig.Weapons.Machinegun.hastyBipodRecoilMultiplier;
            recoil_multiplier_h *= Config.IIConfig.Weapons.Machinegun.hastyBipodRecoilMultiplier;
        }
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("heavy_barrel")) {
            recoil_multiplier_w *= Config.IIConfig.Weapons.Machinegun.recoilHBHorizontal;
            recoil_multiplier_h *= Config.IIConfig.Weapons.Machinegun.recoilHBVertical;
        }
        if (CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("second_magazine")) {
            recoil_multiplier_w *= Config.IIConfig.Weapons.Machinegun.recoilSecondMagazine;
        }
        this.hasSecondMag = CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("second_magazine");
        this.maxRecoilYaw *= recoil_multiplier_w;
        this.maxRecoilPitch *= recoil_multiplier_h;
        if (ItemNBTHelper.hasKey((ItemStack)this.gun, (String)"magazine1")) {
            this.magazine1 = new ItemStack(ItemNBTHelper.getTagCompound((ItemStack)this.gun, (String)"magazine1"));
        }
        if (ItemNBTHelper.hasKey((ItemStack)this.gun, (String)"magazine2")) {
            this.magazine2 = new ItemStack(ItemNBTHelper.getTagCompound((ItemStack)this.gun, (String)"magazine2"));
        }
        if (!(this.hasSecondMag || this.magazine2.func_190926_b() || this.field_70170_p.field_72995_K)) {
            blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)stack);
        }
        this.hasInfrared = CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("infrared_scope");
        this.loadedFromCrate = CommonProxy.item_machinegun.getUpgrades(this.gun).func_74764_b("belt_fed_loader");
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageMachinegunSync(this, tag), Utils.targetPointFromEntity(this, 24));
    }

    void dropItem() {
        ItemNBTHelper.setTagCompound((ItemStack)this.gun, (String)"magazine1", (NBTTagCompound)this.magazine1.serializeNBT());
        ItemNBTHelper.setTagCompound((ItemStack)this.gun, (String)"magazine2", (NBTTagCompound)this.magazine2.serializeNBT());
        blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.gun);
        this.func_70106_y();
    }

    public static class MachinegunZoom
    implements IAdvancedZoomTool {
        @Override
        public String getZoomOverlayTexture(ItemStack stack, EntityPlayer player) {
            NBTTagCompound nbt = CommonProxy.item_machinegun.getUpgrades(stack);
            return "immersiveintelligence:textures/gui/item/machinegun/" + (nbt.func_74764_b("scope") ? "scope" : "scope_infrared") + ".png";
        }

        public boolean canZoom(ItemStack stack, EntityPlayer player) {
            NBTTagCompound nbt = CommonProxy.item_machinegun.getUpgrades(stack);
            return nbt.func_74764_b("scope") || nbt.func_74764_b("infrared_scope");
        }

        public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
            return Config.IIConfig.Weapons.Machinegun.machinegun_scope_max_zoom;
        }
    }
}

