/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.jei;

import blusunrize.immersiveengineering.client.gui.GuiFluidSorter;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.common.util.compat.jei.FluidSorterGhostHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.IEFluidTooltipCallback;
import blusunrize.immersiveengineering.common.util.compat.jei.IEGhostItemHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.crafting.BathingRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.ElectrolyzerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.client.gui.GuiChemicalBath;
import pl.pabilo8.immersiveintelligence.client.gui.GuiElectrolyzer;
import pl.pabilo8.immersiveintelligence.client.gui.GuiPrecissionAssembler;
import pl.pabilo8.immersiveintelligence.client.gui.GuiSawmill;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.compat.jei.IIRecipeCategory;
import pl.pabilo8.immersiveintelligence.common.compat.jei.bathing.BathingRecipeCategory;
import pl.pabilo8.immersiveintelligence.common.compat.jei.electrolyzer.ElectrolyzerRecipeCategory;
import pl.pabilo8.immersiveintelligence.common.compat.jei.precission_assembler.PrecissionAssemblerRecipeCategory;
import pl.pabilo8.immersiveintelligence.common.compat.jei.sawmill.SawmillRecipeCategory;

@JEIPlugin
public class JEIHelper
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IModRegistry modRegistry;
    public static IDrawable slotDrawable;
    public static ITooltipCallback fluidTooltipCallback;
    Map<Class, IIRecipeCategory> categories = new LinkedHashMap<Class, IIRecipeCategory>();

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        slotDrawable = guiHelper.getSlotDrawable();
        this.categories.put(BathingRecipe.class, new BathingRecipeCategory(guiHelper));
        this.categories.put(ElectrolyzerRecipe.class, new ElectrolyzerRecipeCategory(guiHelper));
        this.categories.put(PrecissionAssemblerRecipe.class, new PrecissionAssemblerRecipeCategory(guiHelper));
        this.categories.put(SawmillRecipe.class, new SawmillRecipeCategory(guiHelper));
        registry.addRecipeCategories(this.categories.values().toArray(new IRecipeCategory[this.categories.size()]));
    }

    public void register(IModRegistry registryIn) {
        modRegistry = registryIn;
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CommonProxy.item_printed_page, 1, 1));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CommonProxy.item_printed_page, 1, 2));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CommonProxy.item_printed_page, 1, 3));
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CommonProxy.item_bullet, 1, Short.MAX_VALUE));
        ImmersiveIntelligence.logger.info("JEI has just requested our recipes, it seems that we even have a class for registering them!");
        modRegistry.addGhostIngredientHandler(GuiIEContainerBase.class, (IGhostIngredientHandler)new IEGhostItemHandler());
        modRegistry.addGhostIngredientHandler(GuiFluidSorter.class, (IGhostIngredientHandler)new FluidSorterGhostHandler());
        for (IIRecipeCategory cat : this.categories.values()) {
            cat.addCatalysts(registryIn);
            modRegistry.handleRecipes(cat.getRecipeClass(), (IRecipeWrapperFactory)cat, cat.getRecipeCategoryUid());
        }
        modRegistry.addRecipes(BathingRecipe.recipeList, "ii.bathing");
        modRegistry.addRecipeClickArea(GuiChemicalBath.class, 16, 58, 19, 12, new String[]{"ii.bathing"});
        modRegistry.addRecipeClickArea(GuiChemicalBath.class, 131, 57, 11, 13, new String[]{"ii.bathing"});
        modRegistry.addRecipes(ElectrolyzerRecipe.recipeList, "ii.electrolyzer");
        modRegistry.addRecipeClickArea(GuiElectrolyzer.class, 16, 58, 19, 12, new String[]{"ii.electrolyzer"});
        modRegistry.addRecipes(PrecissionAssemblerRecipe.recipeList, "ii.precissionassembler");
        modRegistry.addRecipeClickArea(GuiPrecissionAssembler.class, 16, 58, 19, 12, new String[]{"ii.precissionassembler"});
        modRegistry.addRecipes(SawmillRecipe.recipeList, "ii.sawmill");
        modRegistry.addRecipeClickArea(GuiSawmill.class, 16, 58, 19, 12, new String[]{"ii.sawmill"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ImmersiveIntelligence.logger.info("otak!");
    }

    private IIRecipeCategory getFactory(Class recipeClass) {
        IIRecipeCategory factory = this.categories.get(recipeClass);
        if (factory == null && recipeClass != Object.class) {
            factory = this.getFactory(recipeClass.getSuperclass());
        }
        return factory;
    }

    static {
        fluidTooltipCallback = new IEFluidTooltipCallback();
    }
}

