/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.bullets.shrapnel;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.ShrapnelHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityShrapnel;

public class BulletComponentShrapnel
implements IBulletComponent {
    String name;

    public BulletComponentShrapnel(String material) {
        this.name = material;
    }

    @Override
    public String getName() {
        return "shrapnel_" + this.name;
    }

    @Override
    public IngredientStack getMaterial() {
        return new IngredientStack("dust" + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1));
    }

    @Override
    public float getDensity() {
        return 1.0f;
    }

    @Override
    public void onExplosion(float amount, NBTTagCompound tag, World world, BlockPos pos, EntityBullet bullet) {
        boolean lower = false;
        Vec3d v = new Vec3d(0.0, -1.0, 0.0);
        Vec3d throwerPos = new Vec3d((Vec3i)pos.func_177967_a(EnumFacing.UP, 3));
        int i = 0;
        while ((float)i < 50.0f * amount) {
            Vec3d vecDir = v.func_72441_c(Utils.RAND.nextGaussian() * 0.25, Utils.RAND.nextGaussian() * 0.25, Utils.RAND.nextGaussian() * 0.25);
            EntityShrapnel shrap = new EntityShrapnel(world, throwerPos.field_72450_a + v.field_72450_a * 2.0, throwerPos.field_72448_b + v.field_72448_b * 2.0, throwerPos.field_72449_c + v.field_72449_c * 2.0, 0.0, 0.0, 0.0, this.name);
            shrap.field_70159_w = vecDir.field_72450_a * 2.0;
            shrap.field_70181_x = vecDir.field_72448_b * (double)0.05f;
            shrap.field_70179_y = vecDir.field_72449_c * 2.0;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)shrap);
            }
            ++i;
        }
    }

    @Override
    public float getPenetrationModifier(NBTTagCompound tag) {
        return 0.0f;
    }

    @Override
    public float getDamageModifier(NBTTagCompound tag) {
        return 0.0f;
    }

    @Override
    public BulletRegistry.EnumComponentRole getRole() {
        return BulletRegistry.EnumComponentRole.SHRAPNEL;
    }

    @Override
    public int getColour() {
        return ShrapnelHandler.registry.get((Object)this.name).color;
    }
}

