/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.rotary;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorGear;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.api.utils.IRotationalEnergyBlock;
import pl.pabilo8.immersiveintelligence.api.utils.IWrenchGui;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageRotaryPowerSync;

public class TileEntityGearbox
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IGuiTile,
IIEInventory,
IWrenchGui,
IRotationalEnergyBlock {
    public IEEnums.SideConfig[] sideConfig = new IEEnums.SideConfig[]{IEEnums.SideConfig.NONE, IEEnums.SideConfig.INPUT, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE};
    public int comparatorOutput = 0;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    float efficiency = 0.0f;
    public RotaryStorage rotation = new RotaryStorage(0.0f, 0.0f){

        @Override
        public IRotaryEnergy.RotationSide getSide(@Nullable EnumFacing facing) {
            switch (TileEntityGearbox.this.sideConfig[facing.func_176745_a()]) {
                case INPUT: {
                    return IRotaryEnergy.RotationSide.INPUT;
                }
                case OUTPUT: {
                    return IRotaryEnergy.RotationSide.OUTPUT;
                }
            }
            return IRotaryEnergy.RotationSide.NONE;
        }
    };

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityRotaryEnergy.ROTARY_ENERGY) {
            if (facing == null) {
                return true;
            }
            if (this.sideConfig[facing.func_176745_a()] != IEEnums.SideConfig.NONE) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityRotaryEnergy.ROTARY_ENERGY) {
            if (facing == null) {
                return (T)this.rotation;
            }
            if (this.sideConfig[facing.func_176745_a()] != IEEnums.SideConfig.NONE) {
                return (T)this.rotation;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.rotation.setRotationSpeed(0.0f);
            this.rotation.setTorque(0.0f);
            ArrayList<IRotaryEnergy> in = new ArrayList<IRotaryEnergy>();
            ArrayList<IRotaryEnergy> out = new ArrayList<IRotaryEnergy>();
            ArrayList<EnumFacing> out_sides = new ArrayList<EnumFacing>();
            for (int i = 0; i < this.sideConfig.length; ++i) {
                EnumFacing f;
                BlockPos p;
                IEEnums.SideConfig s = this.sideConfig[i];
                if (s == IEEnums.SideConfig.NONE || this.field_145850_b.func_175625_s(p = this.field_174879_c.func_177972_a(f = EnumFacing.func_82600_a((int)i))) == null || !this.field_145850_b.func_175625_s(p).hasCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, f.func_176734_d())) continue;
                IRotaryEnergy energy = (IRotaryEnergy)this.field_145850_b.func_175625_s(p).getCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, f.func_176734_d());
                if (s == IEEnums.SideConfig.INPUT) {
                    if (this.rotation.getRotationSpeed() == 0.0f) {
                        this.rotation.setRotationSpeed(energy.getOutputRotationSpeed());
                    }
                    in.add(energy);
                    continue;
                }
                out.add(energy);
                out_sides.add(f.func_176734_d());
            }
            in.forEach(iRotationalEnergy -> this.rotation.setTorque(this.rotation.getCombinedTorque((IRotaryEnergy)iRotationalEnergy)));
            if (out.size() > 1) {
                this.rotation.setTorque(this.rotation.getTorque() / (float)out.size());
            }
            float eff = RotaryUtils.getGearEffectiveness(this.inventory, this.getEfficiencyMultiplier());
            this.rotation.setRotationSpeed(this.rotation.getRotationSpeed() * eff);
            this.rotation.setTorque(this.rotation.getTorque() * eff);
            RotaryUtils.damageGears(this.inventory, this.rotation);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.rotation, 0, this.func_174877_v()), Utils.targetPointFromTile((TileEntity)this, 32));
        }
    }

    @Override
    public void updateRotationStorage(float rpm, float torque, int part) {
        if (this.field_145850_b.field_72995_K && part == 0) {
            this.rotation.setRotationSpeed(rpm);
            this.rotation.setTorque(torque);
        }
    }

    public IEEnums.SideConfig getSideConfig(int side) {
        return this.sideConfig[side];
    }

    public boolean toggleSide(int side, EntityPlayer player) {
        this.sideConfig[side] = IEEnums.SideConfig.next((IEEnums.SideConfig)this.sideConfig[side]);
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
        return true;
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        }
        for (int i = 0; i < 6; ++i) {
            nbt.func_74768_a("sideConfig_" + i, this.sideConfig[i].ordinal());
        }
        nbt.func_74782_a("rotation", (NBTBase)this.rotation.toNBT());
        nbt.func_74776_a("efficiency", this.efficiency);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (!descPacket && nbt.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)3);
        }
        if (nbt.func_74764_b("sideConfig")) {
            int[] old = nbt.func_74759_k("sideConfig");
            for (int i = 0; i < old.length; ++i) {
                this.sideConfig[i] = IEEnums.SideConfig.values()[old[i] + 1];
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = IEEnums.SideConfig.values()[nbt.func_74762_e("sideConfig_" + i)];
            }
        }
        if (nbt.func_74764_b("rotation")) {
            this.rotation.fromNBT(nbt.func_74775_l("rotation"));
        }
        this.efficiency = nbt.func_74760_g("efficiency");
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport) {
            IEEnums.SideConfig i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.ordinal())];
            IEEnums.SideConfig j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.func_176734_d().ordinal())];
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + i), (Object[])new Object[0]), I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + j), (Object[])new Object[0])};
        }
        return null;
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        for (int i = 0; i < 6; ++i) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)("sideConfig_" + i), (int)this.sideConfig[i].ordinal());
        }
        return stack;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        for (int i = 0; i < 6; ++i) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)("sideConfig_" + i))) continue;
            this.sideConfig[i] = IEEnums.SideConfig.values()[ItemNBTHelper.getInt((ItemStack)stack, (String)("sideConfig_" + i))];
        }
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return 32;
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IMotorGear;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void doGraphicalUpdates(int slot) {
    }

    public float getEfficiencyMultiplier() {
        return 1.0f;
    }
}

