/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.IDataStorageItem;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeArray;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.TileEntityMultiblockConnectable;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.MultiblockRedstoneInterface;

public class TileEntityRedstoneInterface
extends TileEntityMultiblockConnectable<TileEntityRedstoneInterface, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IGuiTile,
IDataDevice,
IRedstoneConnector {
    public boolean rsDirty = false;
    public DataPacket storedData = new DataPacket();
    public DataPacket storedRedstone = new DataPacket();
    public boolean copySide = false;
    public int productionProgress = 0;
    protected RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add((IRedstoneConnector)this);
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    byte[] redstoneOutput = new byte[16];
    private boolean refreshWireNetwork = false;
    private boolean redstoneChanged = false;
    IItemHandler inventoryHandler = new IEInventoryHandler(2, (IIEInventory)this, 0, true, true);

    public TileEntityRedstoneInterface() {
        super(MultiblockRedstoneInterface.instance, new int[]{1, 3, 2}, 0, false);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!this.isDummy()) {
            if (!descPacket && nbt.func_74764_b("inventory")) {
                this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)2);
            }
            if (nbt.func_74764_b("copySide")) {
                this.copySide = nbt.func_74767_n("copySide");
            }
            if (nbt.func_74764_b("storedData")) {
                this.storedData.fromNBT(nbt.func_74775_l("storedData"));
            }
            if (nbt.func_74764_b("storedRedstone")) {
                this.storedRedstone.fromNBT(nbt.func_74775_l("storedRedstone"));
            }
            if (nbt.func_74764_b("productionProgress")) {
                this.productionProgress = nbt.func_74762_e("productionProgress");
            }
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.isDummy()) {
            if (!descPacket) {
                nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.getInventory()));
            }
            nbt.func_74757_a("copySide", this.copySide);
            nbt.func_74782_a("storedData", (NBTBase)this.storedData.toNBT());
            nbt.func_74782_a("storedRedstone", (NBTBase)this.storedRedstone.toNBT());
            nbt.func_74768_a("productionProgress", this.productionProgress);
        }
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)2);
        }
        if (message.func_74764_b("copySide")) {
            this.copySide = message.func_74767_n("copySide");
        }
        if (message.func_74764_b("storedData")) {
            this.storedData.fromNBT(message.func_74775_l("storedData"));
        }
        if (message.func_74764_b("storedRedstone")) {
            this.storedRedstone.fromNBT(message.func_74775_l("storedRedstone"));
        }
        if (message.func_74764_b("productionProgress")) {
            this.productionProgress = message.func_74762_e("productionProgress");
        }
        super.receiveMessageFromServer(message);
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.func_74764_b("copySide")) {
            this.copySide = message.func_74767_n("copySide");
        }
        if (message.func_74764_b("storedData")) {
            this.storedData.fromNBT(message.func_74775_l("storedData"));
        }
        if (message.func_74764_b("storedRedstone")) {
            this.storedRedstone.fromNBT(message.func_74775_l("storedRedstone"));
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.rsDirty) {
            this.wireNetwork.updateValues();
        }
        if (this.isDummy() || !this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    }

    public int[] getEnergyPos() {
        return new int[0];
    }

    public int[] getRedstonePos() {
        return new int[0];
    }

    @Override
    public int[] getConnectionPos() {
        return new int[]{4};
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    public NonNullList<ItemStack> getInventory() {
        return ((TileEntityRedstoneInterface)this.master()).inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IDataStorageItem || stack.func_190926_b();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[0];
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        NBTTagCompound tag = new NBTTagCompound();
        if (!tag.func_82582_d()) {
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), Utils.targetPointFromTile((TileEntity)this, 32));
        }
    }

    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    protected boolean canTakeMV() {
        return false;
    }

    @Override
    protected boolean canTakeLV() {
        return false;
    }

    @Override
    protected boolean canTakeHV() {
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (!"REDSTONE".equals(cableType.getCategory())) {
            return false;
        }
        return this.limitType == null;
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return new Vec3d(0.5, 0.625, 0.5);
    }

    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.func_174877_v(), (Object)this.func_174877_v().func_177967_a(this.facing.func_176734_d(), 1));
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return 20;
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public void onReceive(DataPacket packet, @Nullable EnumFacing side) {
        if (this.field_174879_c == 0 && side == this.facing.func_176734_d()) {
            for (char c : packet.variables.keySet()) {
                if (!this.storedData.variables.containsKey(Character.valueOf(c))) continue;
                if (this.storedData.variables.get(Character.valueOf(c)) instanceof DataPacketTypeArray) {
                    DataPacketTypeArray a = (DataPacketTypeArray)this.storedData.variables.get(Character.valueOf(c));
                    DataPacketTypeInteger int1 = (DataPacketTypeInteger)a.value[0];
                    DataPacketTypeInteger int2 = (DataPacketTypeInteger)a.value[1];
                    this.redstoneOutput[int1.value] = this.getRedstoneFromPacket(int2.value, packet, c);
                    continue;
                }
                this.storedData.removeVariable(Character.valueOf(c));
            }
            ((TileEntityRedstoneInterface)this.master()).redstoneChanged = true;
            ((TileEntityRedstoneInterface)this.getTileForPos(4)).getNetwork().updateValues();
            ((TileEntityRedstoneInterface)this.master()).redstoneChanged = false;
        }
    }

    private byte getRedstoneFromPacket(int value, DataPacket packet, char c) {
        switch (value) {
            case 0: {
                return 0;
            }
            case 1: {
                if (packet.getPacketVariable(Character.valueOf(c)) instanceof DataPacketTypeBoolean) {
                    return (byte)(((DataPacketTypeBoolean)packet.getPacketVariable((Character)Character.valueOf((char)c))).value ? 15 : 0);
                }
                return 0;
            }
            case 2: {
                if (packet.getPacketVariable(Character.valueOf(c)) instanceof DataPacketTypeInteger) {
                    int i = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)c))).value;
                    return (byte)MathHelper.func_76125_a((int)i, (int)0, (int)15);
                }
                return 0;
            }
            case 3: {
                if (packet.getPacketVariable(Character.valueOf(c)) instanceof DataPacketTypeInteger) {
                    int i = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)c))).value;
                    return (byte)MathHelper.func_76131_a((float)((float)i / 255.0f * 15.0f), (float)0.0f, (float)15.0f);
                }
                return 0;
            }
            case 4: {
                if (packet.getPacketVariable(Character.valueOf(c)) instanceof DataPacketTypeInteger) {
                    int i = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)c))).value;
                    return (byte)MathHelper.func_76131_a((float)((float)i / 100.0f * 15.0f), (float)0.0f, (float)15.0f);
                }
                return 0;
            }
            case 5: {
                if (packet.getPacketVariable(Character.valueOf(c)) instanceof DataPacketTypeString) {
                    String s;
                    switch (s = ((DataPacketTypeString)packet.getPacketVariable((Character)Character.valueOf((char)c))).value) {
                        case "on": {
                            return 15;
                        }
                        case "off": {
                            return 0;
                        }
                        case "low": {
                            return 4;
                        }
                        case "high": {
                            return 12;
                        }
                        case "med": {
                            return 8;
                        }
                    }
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    private IDataType getTypeFromRedstone(byte value, int type) {
        switch (type) {
            case 0: {
                return new DataPacketTypeNull();
            }
            case 1: {
                return new DataPacketTypeBoolean(value > 0);
            }
            case 2: {
                return new DataPacketTypeInteger(value);
            }
            case 3: {
                return new DataPacketTypeInteger((int)((float)value / 15.0f * 255.0f));
            }
            case 4: {
                return new DataPacketTypeInteger((int)((float)value / 15.0f * 100.0f));
            }
            case 5: {
                String s = value == 15 ? "on" : (value >= 12 ? "high" : (value >= 8 ? "med" : (value >= 4 ? "low" : "off")));
                return new DataPacketTypeString(s);
            }
        }
        return new DataPacketTypeNull();
    }

    @Override
    public void onSend() {
    }

    public RedstoneWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    public void setNetwork(RedstoneWireNetwork net) {
        this.wireNetwork = net;
    }

    public void onChange() {
        if (!((TileEntityRedstoneInterface)this.master()).redstoneChanged) {
            this.dataToRedstone();
        }
    }

    public World getConnectorWorld() {
        return this.field_145850_b;
    }

    public void updateInput(byte[] signals) {
        for (int i = 0; i < 16; ++i) {
            if (signals[i] >= ((TileEntityRedstoneInterface)this.master()).redstoneOutput[i]) continue;
            signals[i] = ((TileEntityRedstoneInterface)this.master()).redstoneOutput[i];
        }
    }

    private void dataToRedstone() {
        TileEntityRedstoneInterface m = (TileEntityRedstoneInterface)this.master();
        if (m == null) {
            return;
        }
        if (m.storedRedstone.variables.size() < 1) {
            return;
        }
        DataPacket out = new DataPacket();
        for (char c : DataPacket.varCharacters) {
            if (!m.storedRedstone.variables.containsKey(Character.valueOf(c)) || !(m.storedRedstone.variables.get(Character.valueOf(c)) instanceof DataPacketTypeArray)) continue;
            DataPacketTypeArray a = (DataPacketTypeArray)m.storedRedstone.variables.get(Character.valueOf(c));
            int i1 = ((DataPacketTypeInteger)a.value[0]).value;
            int i2 = ((DataPacketTypeInteger)a.value[1]).value;
            out.setVariable(Character.valueOf(c), this.getTypeFromRedstone((byte)((TileEntityRedstoneInterface)this.getTileForPos(4)).getNetwork().getPowerOutput(i1), i2));
        }
        if (out.variables.size() < 1) {
            return;
        }
        IDataConnector conn = Utils.findConnectorFacing(((TileEntityRedstoneInterface)this.master()).func_174877_v(), this.field_145850_b, this.facing.func_176734_d());
        ImmersiveIntelligence.logger.info((Object)conn);
        if (conn != null) {
            conn.sendPacket(out);
        }
    }
}

