/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_Connector;

public class TileEntityFluidInserter
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IHammerInteraction,
ITickable,
IEBlockInterfaces.IBlockBounds,
IDataConnector {
    public static ItemStack conn_data;
    public static ItemStack conn_mv;
    public int energyStorage = 0;
    public EnumFacing outputFacing = EnumFacing.NORTH;
    public EnumFacing inputFacing = EnumFacing.SOUTH;
    public int fluidToTake = 0;
    protected Set<String> acceptablePowerWires = ImmutableSet.of((Object)"LV", (Object)"MV");
    protected DataWireNetwork wireNetwork = new DataWireNetwork().add(this);
    WireType secondCable;
    String fluidTakeMode = "set";
    SidedFluidHandler outputFluidHandler = new SidedFluidHandler(this, this.outputFacing);
    SidedFluidHandler inputFluidHandler = new SidedFluidHandler(this, this.inputFacing);
    private boolean refreshWireNetwork = false;

    protected boolean canTakeLV() {
        return true;
    }

    protected boolean canTakeMV() {
        return true;
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return true;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < Config.IIConfig.Machines.FluidInserter.energyCapacity) {
            if (!simulate) {
                int rec = Math.min(Config.IIConfig.Machines.FluidInserter.energyCapacity - this.energyStorage, Config.IIConfig.Machines.FluidInserter.energyUsage);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(Config.IIConfig.Machines.FluidInserter.energyCapacity - this.energyStorage, Config.IIConfig.Machines.FluidInserter.energyUsage);
        }
        return 0;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        int tc = this.getTargetedConnector(target);
        return this.canAttach(cableType, tc);
    }

    private boolean canAttach(WireType toAttach, int conn) {
        String attachCat = toAttach.getCategory();
        if (attachCat == null) {
            return false;
        }
        if (conn == 0) {
            return attachCat.equals("DATA") && this.limitType == null;
        }
        if (conn == 1) {
            return this.acceptablePowerWires.contains(attachCat) && this.secondCable == null;
        }
        return false;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                if (this.limitType != null) break;
                DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
                this.limitType = cableType;
                break;
            }
            case 1: {
                if (this.secondCable != null) break;
                this.secondCable = cableType;
            }
        }
        this.markContainingBlockForUpdate(null);
    }

    public WireType getCableLimiter(TargetingInfo target) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                return this.limitType;
            }
            case 1: {
                return this.secondCable;
            }
        }
        return null;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.secondCable = null;
        }
        if (type == this.limitType) {
            this.wireNetwork.removeFromNetwork(this);
            this.limitType = null;
        }
        if (type == this.secondCable) {
            this.secondCable = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        boolean right = con.cableType == this.limitType;
        return this.getConnectionOffset(con, right);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getConnectionOffset(con, this.getTargetedConnector(target) == 0);
    }

    private Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, boolean data) {
        if (data) {
            return new Vec3d(0.875, 0.5, 0.875);
        }
        return new Vec3d(0.125, (double)0.475f, 0.125);
    }

    public int getTargetedConnector(TargetingInfo target) {
        if (target.hitX < 1.0f && (double)target.hitX > 0.75 && target.hitZ < 1.0f && (double)target.hitZ > 0.75) {
            return 0;
        }
        return 1;
    }

    public WireType getLimiter(int side) {
        if (side == 0) {
            return this.limitType;
        }
        return this.secondCable;
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("energyStorage")) {
            this.energyStorage = message.func_74762_e("energyStorage");
        }
        if (message.func_74764_b("outputFacing")) {
            this.outputFacing = EnumFacing.func_82600_a((int)message.func_74762_e("outputFacing"));
        }
        if (message.func_74764_b("inputFacing")) {
            this.inputFacing = EnumFacing.func_82600_a((int)message.func_74762_e("inputFacing"));
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.fluidToTake = nbt.func_74762_e("fluidToTake");
        this.fluidTakeMode = nbt.func_74779_i("fluidTakeMode");
        this.outputFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("outputFacing"));
        this.inputFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("inputFacing"));
        this.secondCable = nbt.func_74764_b("secondCable") ? ApiUtils.getWireTypeFromNBT((NBTTagCompound)nbt, (String)"secondCable") : null;
        this.energyStorage = nbt.func_74762_e("energyStorage");
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("fluidToTake", this.fluidToTake);
        nbt.func_74778_a("fluidTakeMode", this.fluidTakeMode);
        nbt.func_74768_a("outputFacing", this.outputFacing.ordinal());
        nbt.func_74768_a("inputFacing", this.inputFacing.ordinal());
        if (this.secondCable != null) {
            nbt.func_74778_a("secondCable", this.secondCable.getUniqueName());
        }
        nbt.func_74768_a("energyStorage", this.energyStorage);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == this.inputFacing || facing == this.outputFacing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == this.inputFacing) {
                return (T)this.inputFluidHandler;
            }
            if (facing == this.outputFacing) {
                return (T)this.outputFluidHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f};
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.receiveMessageFromServer(stack.func_77978_p());
        }
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        EnumFacing hitside = null;
        if (Utils.isPointInRectangle(0.25, 0.75, 0.75, 1.0, hitX, hitZ)) {
            hitside = EnumFacing.SOUTH;
        } else if (Utils.isPointInRectangle(0.25, 0.0, 0.75, 0.25, hitX, hitZ)) {
            hitside = EnumFacing.NORTH;
        } else if (Utils.isPointInRectangle(0.75, 0.25, 1.0, 0.75, hitX, hitZ)) {
            hitside = EnumFacing.EAST;
        } else if (Utils.isPointInRectangle(0.0, 0.25, 0.25, 0.75, hitX, hitZ)) {
            hitside = EnumFacing.WEST;
        }
        if (hitside != null) {
            if (player.func_70093_af()) {
                if (this.inputFacing == hitside) {
                    this.inputFacing = EnumFacing.UP;
                }
                this.outputFacing = hitside;
            } else {
                if (this.outputFacing == hitside) {
                    this.outputFacing = EnumFacing.UP;
                }
                this.inputFacing = hitside;
            }
        }
        this.outputFluidHandler.facing = this.outputFacing;
        this.inputFluidHandler.facing = this.inputFacing;
        this.markContainingBlockForUpdate(null);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("inputFacing", this.inputFacing.ordinal());
        nbt.func_74768_a("outputFacing", this.outputFacing.ordinal());
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 24));
        return true;
    }

    @Override
    public DataWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void setNetwork(DataWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public void onChange() {
        if (!this.func_145837_r()) {
            this.func_70296_d();
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        if (packet.getPacketVariable(Character.valueOf('m')).getName().equals("string")) {
            this.fluidTakeMode = ((DataPacketTypeString)packet.getPacketVariable((Character)Character.valueOf((char)'m'))).value;
        }
        if (packet.getPacketVariable(Character.valueOf('c')).getName().equals("integer")) {
            int items = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'c'))).value;
            this.fluidToTake = this.fluidTakeMode.equals("add") ? this.fluidToTake + items : items;
        }
    }

    @Override
    public void sendPacket(DataPacket packet) {
    }

    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, IIBlockTypes_Connector.FLUID_INSERTER.getMeta());
        ItemNBTHelper.setInt((ItemStack)stack, (String)"outputFacing", (int)this.outputFacing.ordinal());
        ItemNBTHelper.setInt((ItemStack)stack, (String)"inputFacing", (int)this.inputFacing.ordinal());
        return stack;
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        TileEntityFluidInserter internal;
        EnumFacing facing;

        SidedFluidHandler(TileEntityFluidInserter internal, EnumFacing facing) {
            this.internal = internal;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.internal.energyStorage >= Config.IIConfig.Machines.FluidInserter.energyUsage && this.internal.fluidToTake > 0 && this.internal.field_145850_b.func_175625_s(this.internal.field_174879_c.func_177972_a(this.internal.outputFacing)) != null && this.internal.field_145850_b.func_175625_s(this.internal.field_174879_c.func_177972_a(this.internal.outputFacing)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.internal.outputFacing.func_176734_d())) {
                TileEntity te = this.internal.field_145850_b.func_175625_s(this.internal.field_174879_c.func_177972_a(this.internal.outputFacing));
                IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.internal.outputFacing.func_176734_d());
                BlockPos pos = this.internal.field_174879_c.func_177972_a(this.internal.outputFacing);
                FluidStack res2 = resource.copy();
                res2.amount = Math.min(resource.amount, Math.min(Config.IIConfig.Machines.FluidInserter.maxOutput, this.internal.fluidToTake));
                int maxfill = Math.min(resource.amount, Math.min(Config.IIConfig.Machines.FluidInserter.maxOutput, this.internal.fluidToTake));
                int left = handler.fill(res2, doFill);
                if (doFill) {
                    this.internal.fluidToTake -= left;
                    this.internal.energyStorage -= Config.IIConfig.Machines.FluidInserter.energyUsage;
                }
                return left;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTank(0).getTankProperties();
        }
    }
}

