/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.items.ItemSpeedloader;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageBooleanAnimatedPartsSync;

public class TileEntityAmmunitionCrate
extends TileEntityIEBase
implements IIEInventory,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
ILootContainer,
IEBlockInterfaces.IPlayerInteraction,
ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IDirectionalTile,
IBooleanAnimatedPartsBlock {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)38, (Object)ItemStack.field_190927_a);
    public ResourceLocation lootTable;
    public String name;
    private NBTTagList enchantments;
    public boolean open = false;
    public float lidAngle = 0.0f;
    public EnumFacing facing = EnumFacing.NORTH;
    IItemHandler insertionHandler = new IEInventoryHandler(38, (IIEInventory)this);

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("enchantments")) {
            this.enchantments = nbt.func_150295_c("enchantments", 10);
        }
        if (nbt.func_74764_b("open")) {
            this.open = nbt.func_74767_n("open");
        }
        if (!descPacket) {
            if (nbt.func_150297_b("lootTable", 8)) {
                this.lootTable = new ResourceLocation(nbt.func_74779_i("lootTable"));
            } else {
                this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)38);
            }
            this.open = !this.insertionHandler.getStackInSlot(37).func_190926_b();
        }
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (this.facing == EnumFacing.UP || this.facing == EnumFacing.DOWN) {
            this.facing = EnumFacing.NORTH;
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        if (this.enchantments != null && this.enchantments.func_74745_c() > 0) {
            nbt.func_74782_a("enchantments", (NBTBase)this.enchantments);
        }
        if (!descPacket) {
            if (this.lootTable != null) {
                nbt.func_74778_a("lootTable", this.lootTable.toString());
            } else {
                this.writeInv(nbt, false);
            }
        }
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("open", this.open);
    }

    public void writeInv(NBTTagCompound nbt, boolean toItem) {
        boolean write = false;
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            if (toItem) {
                write = true;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        if (!toItem || write) {
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.name != null ? new TextComponentString(this.name) : new TextComponentTranslation("tile.immersiveintelligence.metal_device.metal_crate.name", new Object[0]);
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return 1;
    }

    public TileEntity getGuiMaster() {
        return this;
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (this.lootTable != null && !clientside) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                contextBuilder.func_186469_a(player.func_184817_da());
            }
            LootContext context = contextBuilder.func_186471_a();
            Random rand = new Random();
            List list = loottable.func_186462_a(rand, context);
            ArrayList listSlots = Lists.newArrayList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                listSlots.add(i);
            }
            Collections.shuffle(listSlots, rand);
            if (listSlots.isEmpty()) {
                return;
            }
            Utils.shuffleLootItems((List)list, (int)listSlots.size(), (Random)rand);
            for (ItemStack itemstack : list) {
                int slot = (Integer)listSlots.remove(listSlots.size() - 1);
                this.inventory.set(slot, (Object)itemstack);
            }
            this.func_70296_d();
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot < 20) {
            return stack.func_77973_b() instanceof ItemBullet && !stack.func_77969_a(BulletHandler.emptyCasing) && !stack.func_77969_a(BulletHandler.emptyShell);
        }
        if (slot >= 20 && slot < 29) {
            return stack.func_77973_b() instanceof ItemBullet && stack.func_77969_a(BulletHandler.emptyCasing) || stack.func_77969_a(BulletHandler.emptyShell) && !stack.func_77942_o();
        }
        if (slot >= 29 && slot < 37) {
            return stack.func_77973_b() instanceof ItemBullet && !stack.equals(BulletHandler.emptyCasing) && !stack.equals(BulletHandler.emptyShell);
        }
        if (slot == 37) {
            return stack.func_77973_b() instanceof ItemRevolver || stack.func_77973_b() instanceof ItemSpeedloader;
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeInv(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        if (this.name != null) {
            stack.func_151001_c(this.name);
        }
        if (this.enchantments != null && this.enchantments.func_74745_c() > 0) {
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("ench", (NBTBase)this.enchantments);
        }
        return stack;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_77978_p(), false);
            if (stack.func_82837_s()) {
                this.name = stack.func_82833_r();
            }
            this.enchantments = stack.func_77986_q();
        }
    }

    public boolean preventInventoryDrop() {
        return true;
    }

    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory((IIEInventory)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ResourceLocation func_184276_b() {
        return this.lootTable;
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            if (((ItemStack)this.inventory.get(37)).func_190926_b()) {
                if (heldItem.func_77969_a(new ItemStack((Item)IEContent.itemSpeedloader)) || heldItem.func_77969_a(new ItemStack((Item)IEContent.itemRevolver))) {
                    heldItem = this.insertionHandler.insertItem(37, heldItem, false);
                    EntityEquipmentSlot truehand = hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
                    player.func_184201_a(truehand, heldItem);
                    player.field_71069_bz.func_75142_b();
                    this.open = true;
                    IIPacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBooleanAnimatedPartsSync(this.open, 0, this.field_174879_c), this.field_145850_b.field_73011_w.getDimension());
                    return true;
                }
            } else if (heldItem == ItemStack.field_190927_a) {
                if (((ItemStack)this.inventory.get(37)).func_77973_b() instanceof ItemRevolver) {
                    ItemNBTHelper.setInt((ItemStack)((ItemStack)this.inventory.get(37)), (String)"reload", (int)Math.round(30.0f * Config.IIConfig.Tools.ammunition_crate_resupply_time));
                }
                IItemHandler bullethandler = (IItemHandler)((ItemStack)this.inventory.get(37)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                for (int i = 0; i < 8; ++i) {
                    int j;
                    ItemStack s = bullethandler.extractItem(i, 1, false);
                    if (s.func_77969_a(BulletHandler.emptyCasing) || s.func_77969_a(BulletHandler.emptyShell)) {
                        for (j = 20; j < 29 && !(s = this.insertionHandler.insertItem(j, s, false)).func_190926_b(); ++j) {
                        }
                        continue;
                    }
                    for (j = 0; j < 20 && !(s = this.insertionHandler.insertItem(j, s, false)).func_190926_b(); ++j) {
                    }
                }
                for (int j = 0; j < 8; ++j) {
                    ItemStack required = (ItemStack)this.inventory.get(29 + j);
                    if (required.func_190926_b()) continue;
                    ItemStack s = ItemStack.field_190927_a;
                    for (int k = 0; k < 20; ++k) {
                        if (this.insertionHandler.getStackInSlot(k).func_190926_b() || !this.insertionHandler.getStackInSlot(k).func_77978_p().equals((Object)required.func_77978_p())) continue;
                        s = this.insertionHandler.extractItem(k, 1, false);
                        break;
                    }
                    bullethandler.insertItem(j, s, false);
                }
                player.func_191521_c(this.insertionHandler.extractItem(37, 1, false));
                this.open = false;
                IIPacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBooleanAnimatedPartsSync(this.open, 0, this.field_174879_c), this.field_145850_b.field_73011_w.getDimension());
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.open && this.lidAngle < 1.5f) {
            this.lidAngle = Math.min(this.lidAngle + 0.2f, 1.5f);
        } else if (!this.open && this.lidAngle > 0.0f) {
            this.lidAngle = Math.max(this.lidAngle - 0.3f, 0.0f);
        }
    }

    public float[] getBlockBounds() {
        if (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) {
            return new float[]{0.0f, 0.0f, 0.25f, 1.0f, 0.58f, 0.75f};
        }
        return new float[]{0.25f, 0.0f, 0.0f, 0.75f, 0.58f, 1.0f};
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    public boolean canRotate(EnumFacing axis) {
        return !axis.func_176740_k().func_176720_b();
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        this.open = state;
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        this.open = state;
    }
}

