/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.utils.IMinecartBlockPickable;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_Connector;

public class TileEntityAdvancedInserter
extends TileEntityImmersiveConnectable
implements IIEInventory,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IHammerInteraction,
ITickable,
IEBlockInterfaces.IBlockBounds,
IDataConnector {
    public static ItemStack conn_data;
    public static ItemStack conn_mv;
    public int energyStorage = 0;
    public EnumFacing outputFacing = EnumFacing.NORTH;
    public EnumFacing inputFacing = EnumFacing.SOUTH;
    public int pickProgress = 100;
    public int armDirection = 0;
    public int nextPickProgress = 0;
    public int nextDirection = 0;
    public IItemHandler insertionHandler = new IEInventoryHandler(1, (IIEInventory)this);
    protected Set<String> acceptablePowerWires = ImmutableSet.of((Object)"LV", (Object)"MV");
    protected DataWireNetwork wireNetwork = new DataWireNetwork().add(this);
    boolean canPickBlocks = false;
    WireType secondCable;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    NonNullList<ItemStack> filters = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    String filterMode = "none";
    String filterItemMode = "item";
    int itemsToTake = 0;
    String itemTakeMode = "set";
    String minecartMode = "place";
    private boolean refreshWireNetwork = false;

    protected boolean canTakeLV() {
        return true;
    }

    protected boolean canTakeMV() {
        return true;
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return true;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < Config.IIConfig.Machines.AdvancedInserter.energyCapacity) {
            if (!simulate) {
                int rec = Math.min(Config.IIConfig.Machines.AdvancedInserter.energyCapacity - this.energyStorage, Config.IIConfig.Machines.AdvancedInserter.energyUsage);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(Config.IIConfig.Machines.AdvancedInserter.energyCapacity - this.energyStorage, Config.IIConfig.Machines.AdvancedInserter.energyUsage);
        }
        return 0;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        int tc = this.getTargetedConnector(target);
        return this.canAttach(cableType, tc);
    }

    private boolean canAttach(WireType toAttach, int conn) {
        String attachCat = toAttach.getCategory();
        if (attachCat == null) {
            return false;
        }
        if (conn == 0) {
            return attachCat.equals("DATA") && this.limitType == null;
        }
        if (conn == 1) {
            return this.acceptablePowerWires.contains(attachCat) && this.secondCable == null;
        }
        return false;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                if (this.limitType != null) break;
                DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
                this.limitType = cableType;
                break;
            }
            case 1: {
                if (this.secondCable != null) break;
                this.secondCable = cableType;
            }
        }
        this.markContainingBlockForUpdate(null);
    }

    public WireType getCableLimiter(TargetingInfo target) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                return this.limitType;
            }
            case 1: {
                return this.secondCable;
            }
        }
        return null;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.secondCable = null;
        }
        if (type == this.limitType) {
            this.wireNetwork.removeFromNetwork(this);
            this.limitType = null;
        }
        if (type == this.secondCable) {
            this.secondCable = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        boolean right = con.cableType == this.limitType;
        return this.getConnectionOffset(con, right);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getConnectionOffset(con, this.getTargetedConnector(target) == 0);
    }

    private Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, boolean data) {
        if (data) {
            return new Vec3d(0.875, 0.5, 0.875);
        }
        return new Vec3d(0.125, (double)0.475f, 0.125);
    }

    public int getTargetedConnector(TargetingInfo target) {
        if (target.hitX < 1.0f && (double)target.hitX > 0.75 && target.hitZ < 1.0f && (double)target.hitZ > 0.75) {
            return 0;
        }
        return 1;
    }

    public WireType getLimiter(int side) {
        if (side == 0) {
            return this.limitType;
        }
        return this.secondCable;
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("pickProgress")) {
            this.pickProgress = message.func_74762_e("pickProgress");
        }
        if (message.func_74764_b("nextPickProgress")) {
            this.nextPickProgress = message.func_74762_e("nextPickProgress");
        }
        if (message.func_74764_b("nextPickProgress")) {
            this.nextPickProgress = message.func_74762_e("nextPickProgress");
        }
        if (message.func_74764_b("nextDirection")) {
            this.nextDirection = message.func_74762_e("nextDirection");
        }
        if (message.func_74764_b("energyStorage")) {
            this.energyStorage = message.func_74762_e("energyStorage");
        }
        if (message.func_74764_b("outputFacing")) {
            this.outputFacing = EnumFacing.func_82600_a((int)message.func_74762_e("outputFacing"));
        }
        if (message.func_74764_b("inputFacing")) {
            this.inputFacing = EnumFacing.func_82600_a((int)message.func_74762_e("inputFacing"));
        }
        if (message.func_74764_b("canPickBlocks")) {
            this.canPickBlocks = message.func_74767_n("canPickBlocks");
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)1);
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)1);
        this.filters = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("filters", 10), (int)10);
        this.filterMode = nbt.func_74779_i("filterMode");
        this.filterItemMode = nbt.func_74779_i("filterItemMode");
        this.itemsToTake = nbt.func_74762_e("itemsToTake");
        this.itemTakeMode = nbt.func_74779_i("itemTakeMode");
        this.pickProgress = nbt.func_74762_e("pickProgress");
        this.armDirection = nbt.func_74762_e("armDirection");
        this.nextPickProgress = nbt.func_74762_e("nextPickProgress");
        this.nextDirection = nbt.func_74762_e("nextDirection");
        this.outputFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("outputFacing"));
        this.inputFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("inputFacing"));
        this.secondCable = nbt.func_74764_b("secondCable") ? ApiUtils.getWireTypeFromNBT((NBTTagCompound)nbt, (String)"secondCable") : null;
        this.energyStorage = nbt.func_74762_e("energyStorage");
        this.canPickBlocks = nbt.func_74767_n("canPickBlocks");
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        nbt.func_74782_a("filters", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.filters));
        nbt.func_74778_a("filterMode", this.filterMode);
        nbt.func_74778_a("filterItemMode", this.filterItemMode);
        nbt.func_74768_a("itemsToTake", this.itemsToTake);
        nbt.func_74778_a("itemTakeMode", this.itemTakeMode);
        nbt.func_74768_a("pickProgress", this.pickProgress);
        nbt.func_74768_a("armDirection", this.armDirection);
        nbt.func_74768_a("nextPickProgress", this.nextPickProgress);
        nbt.func_74768_a("nextDirection", this.nextDirection);
        nbt.func_74768_a("outputFacing", this.outputFacing.ordinal());
        nbt.func_74768_a("inputFacing", this.inputFacing.ordinal());
        if (this.secondCable != null) {
            nbt.func_74778_a("secondCable", this.secondCable.getUniqueName());
        }
        nbt.func_74768_a("energyStorage", this.energyStorage);
        nbt.func_74757_a("canPickBlocks", this.canPickBlocks);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f};
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.receiveMessageFromServer(stack.func_77978_p());
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates(int slot) {
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.armDirection > 360) {
            this.armDirection = 0;
        }
        if (this.pickProgress > 99) {
            this.pickProgress = 100;
        }
        if (this.pickProgress < 1) {
            this.pickProgress = 0;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
        }
        if (this.energyStorage > Config.IIConfig.Machines.AdvancedInserter.energyUsage && this.armDirection != this.nextDirection || this.pickProgress != this.nextPickProgress) {
            if (this.pickProgress != this.nextPickProgress) {
                if (this.pickProgress < this.nextPickProgress) {
                    this.pickProgress = (int)((float)this.pickProgress + 100.0f / (float)Config.IIConfig.Machines.AdvancedInserter.grabTime);
                } else if (this.pickProgress > this.nextPickProgress) {
                    this.pickProgress = (int)((float)this.pickProgress - 100.0f / (float)Config.IIConfig.Machines.AdvancedInserter.grabTime);
                }
                if ((float)Math.round((float)this.pickProgress / 10.0f) * 10.0f == (float)Math.round((float)this.nextPickProgress / 10.0f) * 10.0f) {
                    this.pickProgress = this.nextPickProgress;
                }
            } else if (this.energyStorage > Config.IIConfig.Machines.AdvancedInserter.energyUsage && this.armDirection != this.nextDirection) {
                this.armDirection += Math.round(90.0f / (float)Config.IIConfig.Machines.AdvancedInserter.rotateTime);
                if ((float)Math.round((float)this.armDirection / 10.0f) * 10.0f == (float)Math.round((float)this.nextDirection / 10.0f) * 10.0f) {
                    this.armDirection = this.nextDirection;
                }
            }
        } else {
            int prevDirection = this.nextDirection;
            int prevPickProgress = this.nextPickProgress;
            if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.itemsToTake > 0 && this.outputFacing != EnumFacing.UP && this.inputFacing != EnumFacing.UP && this.energyStorage >= Config.IIConfig.Machines.AdvancedInserter.energyUsage) {
                IItemHandler cap;
                if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                    if (this.nextDirection != this.armDirection && this.armDirection != Math.round(this.inputFacing.func_185119_l())) {
                        this.nextPickProgress = 100;
                        this.nextDirection = Math.round(this.inputFacing.func_185119_l());
                    } else if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(this.outputFacing)) && this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.outputFacing, 2)) != null && this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.outputFacing, 2)).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                        if (this.nextPickProgress == 0) {
                            cap = (IItemHandler)this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.outputFacing, 2)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.outputFacing.func_176734_d());
                            ItemStack stack = this.insertionHandler.extractItem(0, 1, false);
                            for (int i = 0; i < cap.getSlots(); ++i) {
                                if (stack.func_190926_b()) continue;
                                if ((stack = cap.insertItem(i, stack, false)).func_190926_b()) {
                                    --this.itemsToTake;
                                    this.nextPickProgress = 100;
                                    this.nextDirection = Math.round(this.inputFacing.func_185119_l());
                                    continue;
                                }
                                this.nextPickProgress = 0;
                                this.pickProgress = 0;
                            }
                            this.energyStorage -= Config.IIConfig.Machines.AdvancedInserter.energyUsage;
                        } else {
                            this.nextPickProgress = 0;
                        }
                    }
                } else if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(this.inputFacing)) && !this.field_145850_b.func_72872_a(EntityMinecart.class, new AxisAlignedBB(this.field_174879_c).func_186670_a(new BlockPos(0, 0, 0).func_177967_a(this.inputFacing, 2))).isEmpty()) {
                    if (this.nextDirection != this.armDirection && this.armDirection != Math.round(this.outputFacing.func_185119_l())) {
                        this.nextPickProgress = 100;
                        this.nextDirection = Math.round(this.outputFacing.func_185119_l());
                    } else if (this.canPickBlocks && !this.field_145850_b.func_72872_a(EntityMinecart.class, new AxisAlignedBB(this.field_174879_c).func_186670_a(new BlockPos(0, 0, 0).func_177967_a(this.inputFacing, 2))).isEmpty()) {
                        List entities = this.field_145850_b.func_72872_a(EntityMinecart.class, new AxisAlignedBB(this.field_174879_c).func_186670_a(new BlockPos(0, 0, 0).func_177967_a(this.inputFacing, 2)));
                        IMinecartBlockPickable cart = null;
                        boolean right = false;
                        for (Entity item : entities) {
                            if (!(item instanceof IMinecartBlockPickable)) continue;
                            right = true;
                            cart = (IMinecartBlockPickable)item;
                            break;
                        }
                        if (right && this.nextPickProgress == 0 && cart != null) {
                            ItemStack stack = (ItemStack)cart.getBlockForPickup().func_76341_a();
                            this.insertionHandler.insertItem(0, stack, false);
                            this.nextPickProgress = 100;
                            this.nextDirection = Math.round(this.outputFacing.func_185119_l());
                            this.energyStorage -= Config.IIConfig.Machines.AdvancedInserter.energyUsage;
                        } else {
                            this.nextPickProgress = 0;
                        }
                    }
                } else if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(this.inputFacing)) && this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.inputFacing, 2)) != null && this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.inputFacing, 2)).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inputFacing.func_176734_d())) {
                    if (this.nextPickProgress == 0) {
                        cap = (IItemHandler)this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.inputFacing, 2)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inputFacing.func_176734_d());
                        boolean done = false;
                        for (int i = 0; i < cap.getSlots(); ++i) {
                            if (done || cap.getStackInSlot(i).func_190926_b() || !this.canTakeItem(cap.getStackInSlot(i))) continue;
                            ItemStack stack = cap.extractItem(i, 1, false);
                            this.insertionHandler.insertItem(0, stack, false);
                            this.nextPickProgress = 100;
                            this.nextDirection = Math.round(this.outputFacing.func_185119_l());
                            this.energyStorage -= Config.IIConfig.Machines.AdvancedInserter.energyUsage;
                            done = true;
                        }
                    } else {
                        this.nextPickProgress = 0;
                    }
                }
            }
            if (prevDirection != this.nextDirection || prevPickProgress != this.nextPickProgress) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("nextDirection", this.nextDirection);
                nbt.func_74768_a("nextPickProgress", this.nextPickProgress);
                nbt.func_74768_a("armDirection", this.armDirection);
                nbt.func_74768_a("pickProgress", this.pickProgress);
                nbt.func_74768_a("energyStorage", this.energyStorage);
                nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
                ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 24));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleSounds() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
            if (this.armDirection != this.nextDirection) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.func_174877_v(), IISounds.inserter_backward, SoundCategory.BLOCKS, 0.25f, 1.0f);
            } else if (this.pickProgress != this.nextPickProgress) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.func_174877_v(), IISounds.inserter_forward, SoundCategory.BLOCKS, 0.25f, 1.0f);
            }
        }
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        EnumFacing hitside = null;
        if (Utils.isPointInRectangle(0.25, 0.75, 0.75, 1.0, hitX, hitZ)) {
            hitside = EnumFacing.SOUTH;
        } else if (Utils.isPointInRectangle(0.25, 0.0, 0.75, 0.25, hitX, hitZ)) {
            hitside = EnumFacing.NORTH;
        } else if (Utils.isPointInRectangle(0.75, 0.25, 1.0, 0.75, hitX, hitZ)) {
            hitside = EnumFacing.EAST;
        } else if (Utils.isPointInRectangle(0.0, 0.25, 0.25, 0.75, hitX, hitZ)) {
            hitside = EnumFacing.WEST;
        }
        if (hitside != null) {
            if (player.func_70093_af()) {
                if (this.inputFacing == hitside) {
                    this.inputFacing = EnumFacing.UP;
                }
                this.outputFacing = hitside;
            } else {
                if (this.outputFacing == hitside) {
                    this.outputFacing = EnumFacing.UP;
                }
                this.inputFacing = hitside;
            }
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("inputFacing", this.inputFacing.ordinal());
        nbt.func_74768_a("outputFacing", this.outputFacing.ordinal());
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 24));
        return true;
    }

    @Override
    public DataWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void setNetwork(DataWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public void onChange() {
        if (!this.func_145837_r()) {
            this.func_70296_d();
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        if (packet.getPacketVariable(Character.valueOf('m')).getName().equals("string")) {
            this.itemTakeMode = ((DataPacketTypeString)packet.getPacketVariable((Character)Character.valueOf((char)'m'))).value;
        }
        if (packet.getPacketVariable(Character.valueOf('b')).getName().equals("boolean")) {
            this.canPickBlocks = ((DataPacketTypeBoolean)packet.getPacketVariable((Character)Character.valueOf((char)'b'))).value;
        }
        if (packet.getPacketVariable(Character.valueOf('c')).getName().equals("integer")) {
            int items = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'c'))).value;
            int n = this.itemsToTake = this.itemTakeMode.equals("add") ? this.itemsToTake + items : items;
        }
        if (packet.getPacketVariable(Character.valueOf('f')).getName().equals("string")) {
            this.filterMode = ((DataPacketTypeString)packet.getPacketVariable((Character)Character.valueOf((char)'f'))).value;
        }
        if (packet.getPacketVariable(Character.valueOf('g')).getName().equals("string")) {
            this.filterItemMode = ((DataPacketTypeString)packet.getPacketVariable((Character)Character.valueOf((char)'g'))).value;
        }
        if (packet.getPacketVariable(Character.valueOf('w')).getName().equals("string")) {
            this.minecartMode = ((DataPacketTypeString)packet.getPacketVariable((Character)Character.valueOf((char)'w'))).value;
        }
        int i = 0;
        for (char c : new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'}) {
            if (packet.getPacketVariable(Character.valueOf(c)).getName().equals("itemstack")) {
                this.filters.set(i, (Object)((DataPacketTypeItemStack)packet.getPacketVariable((Character)Character.valueOf((char)c))).value);
            }
            ++i;
        }
    }

    @Override
    public void sendPacket(DataPacket packet) {
    }

    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, IIBlockTypes_Connector.ADVANCED_INSERTER.getMeta());
        ItemNBTHelper.setInt((ItemStack)stack, (String)"outputFacing", (int)this.outputFacing.ordinal());
        ItemNBTHelper.setInt((ItemStack)stack, (String)"inputFacing", (int)this.inputFacing.ordinal());
        return stack;
    }

    public boolean canTakeItem(ItemStack stack) {
        if (this.filterMode.equals("none")) {
            return true;
        }
        boolean equal = false;
        for (ItemStack s : this.filters) {
            block6 : switch (this.filterItemMode) {
                case "exact": {
                    equal = stack.func_77969_a(s);
                    break;
                }
                case "item": {
                    equal = stack.func_185136_b(s);
                    break;
                }
                case "oredict": {
                    for (String name : OreDictionary.getOreNames()) {
                        if (!blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)name) || !blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)s, (String)name)) continue;
                        equal = true;
                        break block6;
                    }
                    break;
                }
                case "nbt": {
                    equal = blusunrize.immersiveengineering.common.util.Utils.compareItemNBT((ItemStack)s, (ItemStack)stack);
                }
            }
            if (!equal) continue;
            if (this.filterItemMode.equals("whitelist")) {
                return true;
            }
            if (!this.filterItemMode.equals("blacklist")) continue;
            return false;
        }
        return false;
    }
}

