/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.rotary;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.network.MessageObstructedConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.rotary.IModelMotorBelt;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorBeltConnector;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorGear;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltData;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltType;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;
import pl.pabilo8.immersiveintelligence.common.blocks.rotary.TileEntityMechanicalConnectable;

public class RotaryUtils {
    public static final String BELT_CATEGORY = "MOTOR_BELT";
    public static Map<Predicate<TileEntity>, Function<Float, Float>> ie_rotational_blocks_torque = new HashMap<Predicate<TileEntity>, Function<Float, Float>>();
    public static final float DEFAULT_OUTPUT = 2.0f;

    public static boolean canConnect(TileEntity start, TileEntity end, WireType wire) {
        if (!(start instanceof IMotorBeltConnector) || !(end instanceof IMotorBeltConnector)) {
            return false;
        }
        if (start.func_145831_w() != end.func_145831_w()) {
            return false;
        }
        if (!(wire instanceof MotorBeltType)) {
            return false;
        }
        TileEntity conn_start = (TileEntity)((IMotorBeltConnector)start);
        TileEntity conn_end = (TileEntity)((IMotorBeltConnector)end);
        return RotaryUtils.canConnectOnX((TileEntity)((IMotorBeltConnector)start), (TileEntity)((IMotorBeltConnector)end)) || RotaryUtils.canConnectOnZ((TileEntity)((IMotorBeltConnector)start), (TileEntity)((IMotorBeltConnector)end));
    }

    public static EnumActionResult doCoilUse(IWireCoil coil, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            ItemStack stack = player.func_184586_b(hand);
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            WireType wire = coil.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, target);
            BlockPos offset = pos.func_177973_b((Vec3i)masterPos);
            tileEntity = world.func_175625_s(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return EnumActionResult.PASS;
            }
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(wire, target, (Vec3i)offset) || !coil.canConnectCable(stack, tileEntity)) {
                ImmersiveIntelligence.logger.info("onie");
                if (tileEntity instanceof TileEntityMechanicalConnectable) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.wrongBelt", new Object[0]), true);
                } else if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"linkingPos")) {
                    if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"tries") && !Utils.hasUnlockedIIAdvancement(player, "main/secret_connect_wire")) {
                        int tries = ItemNBTHelper.getInt((ItemStack)stack, (String)"tries");
                        if (tries < 5) {
                            ItemNBTHelper.setInt((ItemStack)stack, (String)"tries", (int)(++tries));
                        } else {
                            Utils.unlockIIAdvancement(player, "main/secret_connect_wire");
                            ItemNBTHelper.remove((ItemStack)stack, (String)"tries");
                        }
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.wrongCable" + tries, new Object[0]), true);
                    } else if (Utils.hasUnlockedIIAdvancement(player, "main/secret_connect_wire")) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.itsBoringGetALife", new Object[0]), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.wrongCable", new Object[0]), true);
                        ItemNBTHelper.setInt((ItemStack)stack, (String)"tries", (int)0);
                    }
                }
                ImmersiveIntelligence.logger.info("onie2");
                return EnumActionResult.FAIL;
            }
            if (!world.field_72995_K) {
                if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"linkingPos")) {
                    ItemNBTHelper.setIntArray((ItemStack)stack, (String)"linkingPos", (int[])new int[]{world.field_73011_w.getDimension(), masterPos.func_177958_n(), masterPos.func_177956_o(), masterPos.func_177952_p(), offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()});
                    NBTTagCompound targetNbt = new NBTTagCompound();
                    target.writeToNBT(targetNbt);
                    ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"targettingInfo", (NBTTagCompound)targetNbt);
                } else {
                    int[] array = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"linkingPos");
                    BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                    Vec3i offsetLink = BlockPos.field_177959_e;
                    if (array.length == 7) {
                        offsetLink = new Vec3i(array[4], array[5], array[6]);
                    }
                    TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
                    int distanceSq = (int)Math.ceil(linkPos.func_177951_i((Vec3i)masterPos));
                    int maxLengthSq = coil.getMaxLength(stack);
                    maxLengthSq *= maxLengthSq;
                    if (array[0] != world.field_73011_w.getDimension()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.wrongDimension", new Object[0]), true);
                    } else if (linkPos.equals((Object)masterPos)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.sameConnection", new Object[0]), true);
                    } else if (distanceSq > maxLengthSq) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.tooFar", new Object[0]), true);
                    } else {
                        TargetingInfo targetLink = TargetingInfo.readFromNBT((NBTTagCompound)ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"targettingInfo"));
                        if (!(tileEntityLinkingPos instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(wire, targetLink, offsetLink) && ((IImmersiveConnectable)tileEntityLinkingPos).getConnectionMaster(wire, targetLink).equals((Object)linkPos) && coil.canConnectCable(stack, tileEntityLinkingPos))) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.invalidPoint", new Object[0]), true);
                        } else {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            boolean connectionExists = false;
                            Set outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, blusunrize.immersiveengineering.common.util.Utils.toCC((Object)nodeHere));
                            if (outputs != null) {
                                for (ImmersiveNetHandler.Connection con : outputs) {
                                    if (!con.end.equals((Object)blusunrize.immersiveengineering.common.util.Utils.toCC((Object)nodeLink))) continue;
                                    connectionExists = true;
                                }
                            }
                            if (connectionExists) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.connectionExists", new Object[0]), true);
                            } else {
                                HashSet ignore = new HashSet();
                                ignore.addAll(nodeHere.getIgnored(nodeLink));
                                ignore.addAll(nodeLink.getIgnored(nodeHere));
                                ImmersiveNetHandler.Connection tmpConn = new ImmersiveNetHandler.Connection(blusunrize.immersiveengineering.common.util.Utils.toCC((Object)nodeHere), blusunrize.immersiveengineering.common.util.Utils.toCC((Object)nodeLink), wire, (int)Math.sqrt(distanceSq));
                                Vec3d start = nodeHere.getConnectionOffset(tmpConn, target, (Vec3i)pos.func_177973_b((Vec3i)masterPos));
                                Vec3d end = nodeLink.getConnectionOffset(tmpConn, targetLink, offsetLink).func_72441_c((double)(linkPos.func_177958_n() - masterPos.func_177958_n()), (double)(linkPos.func_177956_o() - masterPos.func_177956_o()), (double)(linkPos.func_177952_p() - masterPos.func_177952_p()));
                                BlockPos.MutableBlockPos failedReason = new BlockPos.MutableBlockPos();
                                boolean canSee = ApiUtils.raytraceAlongCatenaryRelative((ImmersiveNetHandler.Connection)tmpConn, p -> {
                                    if (ignore.contains(p.getLeft())) {
                                        return false;
                                    }
                                    IBlockState state = world.func_180495_p((BlockPos)p.getLeft());
                                    if (ApiUtils.preventsConnection((World)world, (BlockPos)((BlockPos)p.getLeft()), (IBlockState)state, (Vec3d)((Vec3d)p.getMiddle()), (Vec3d)((Vec3d)p.getRight()))) {
                                        failedReason.func_189533_g((Vec3i)p.getLeft());
                                        return true;
                                    }
                                    return false;
                                }, p -> {}, (Vec3d)start, (Vec3d)end);
                                if (canSee) {
                                    ImmersiveNetHandler.Connection conn = ImmersiveNetHandler.INSTANCE.addAndGetConnection(world, blusunrize.immersiveengineering.common.util.Utils.toCC((Object)nodeHere), blusunrize.immersiveengineering.common.util.Utils.toCC((Object)nodeLink), (int)Math.sqrt(distanceSq), wire);
                                    nodeHere.connectCable(wire, target, nodeLink, (Vec3i)offset);
                                    nodeLink.connectCable(wire, targetLink, nodeHere, offsetLink);
                                    ImmersiveNetHandler.INSTANCE.addBlockData(world, conn);
                                    IESaveData.setDirty((int)world.field_73011_w.getDimension());
                                    Utils.unlockIIAdvancement(player, "main/connect_belt");
                                    if (!player.field_71075_bZ.field_75098_d) {
                                        coil.consumeWire(stack, (int)Math.sqrt(distanceSq));
                                    }
                                    ((TileEntity)nodeHere).func_70296_d();
                                    world.func_175641_c(masterPos, ((TileEntity)nodeHere).func_145838_q(), -1, 0);
                                    IBlockState state = world.func_180495_p(masterPos);
                                    world.func_184138_a(masterPos, state, state, 3);
                                    ((TileEntity)nodeLink).func_70296_d();
                                    world.func_175641_c(linkPos, ((TileEntity)nodeLink).func_145838_q(), -1, 0);
                                    state = world.func_180495_p(linkPos);
                                    world.func_184138_a(linkPos, state, state, 3);
                                } else {
                                    player.func_146105_b((ITextComponent)new TextComponentTranslation("rotary.immersiveintelligence.belt_system.cantSee", new Object[0]), true);
                                    ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageObstructedConnection(tmpConn, (BlockPos)failedReason, player.field_70170_p), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
                                }
                            }
                        }
                    }
                    ItemNBTHelper.remove((ItemStack)stack, (String)"linkingPos");
                    ItemNBTHelper.remove((ItemStack)stack, (String)"targettingInfo");
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static int getRPMMax() {
        return Config.IIConfig.rpmRealTime ? 1200 : 16;
    }

    private static <T extends TileEntity> boolean canConnectOnX(T conn_start, T conn_end) {
        return conn_start.func_174877_v().func_177952_p() == conn_start.func_174877_v().func_177952_p() && ((IMotorBeltConnector)conn_start).getConnectionAxis() == EnumFacing.Axis.X && ((IMotorBeltConnector)conn_end).getConnectionAxis() == EnumFacing.Axis.X;
    }

    private static <T extends TileEntity> boolean canConnectOnZ(T conn_start, T conn_end) {
        return conn_start.func_174877_v().func_177958_n() == conn_start.func_174877_v().func_177958_n() && ((IMotorBeltConnector)conn_start).getConnectionAxis() == EnumFacing.Axis.Z && ((IMotorBeltConnector)conn_end).getConnectionAxis() == EnumFacing.Axis.Z;
    }

    public static boolean isMechanicalBelt(WireType wire) {
        return wire.getCategory() != null && wire.getCategory().equals(BELT_CATEGORY);
    }

    public static float getMaxRPM(NonNullList<ItemStack> inventory, float highest) {
        for (ItemStack stack : inventory) {
            if (!(stack.func_77973_b() instanceof IMotorGear) || !((float)((IMotorGear)stack.func_77973_b()).getGearMaxRPM(stack) > highest)) continue;
            highest = ((IMotorGear)stack.func_77973_b()).getGearMaxRPM(stack);
        }
        return highest;
    }

    public static float getMaxRPM(NonNullList<ItemStack> inventory) {
        return RotaryUtils.getMaxRPM(inventory, 1.0f);
    }

    public static float getMaxTorque(NonNullList<ItemStack> inventory, float highest) {
        for (ItemStack stack : inventory) {
            if (!(stack.func_77973_b() instanceof IMotorGear) || !((float)((IMotorGear)stack.func_77973_b()).getGearMaxTorque(stack) > highest)) continue;
            highest = ((IMotorGear)stack.func_77973_b()).getGearMaxTorque(stack);
        }
        return highest;
    }

    public static float getMaxTorque(NonNullList<ItemStack> inventory) {
        return RotaryUtils.getMaxTorque(inventory, 1.0f);
    }

    public static void damageGears(NonNullList<ItemStack> inventory, IRotaryEnergy energy) {
        for (ItemStack stack : inventory) {
            if (!(stack.func_77973_b() instanceof IMotorGear) || energy.getRotationSpeed() <= 0.0f || energy.getTorque() <= 0.0f) continue;
            IMotorGear gear = (IMotorGear)stack.func_77973_b();
            if ((float)gear.getGearMaxTorque(stack) < energy.getTorque() && (float)gear.getGearMaxRPM(stack) < energy.getRotationSpeed()) {
                gear.damageGear(stack, 8);
            } else if ((float)gear.getGearMaxRPM(stack) < energy.getRotationSpeed()) {
                gear.damageGear(stack, 2);
            } else if ((float)gear.getGearMaxTorque(stack) < energy.getTorque()) {
                gear.damageGear(stack, 2);
            }
            gear.damageGear(stack, 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void tessellateMotorBelt(MotorBeltData data, double rpm, double world_rpm) {
        Vec3d point2;
        Vec3d point;
        int i;
        if (data == null) {
            return;
        }
        IModelMotorBelt model = data.model;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)data.offset.field_72450_a, (double)data.offset.field_72448_b, (double)data.offset.field_72449_c);
        ClientUtils.bindTexture((String)data.texture);
        double speed = Math.abs(world_rpm * rpm * (double)data.bs) % 1.0;
        model.setRotation(0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)((float)(data.radius + data.bt) * 0.0625f), (float)0.0f);
        for (i = 0; i < data.points.length - 1; ++i) {
            point = data.points[i];
            point2 = data.points[Math.min(i + 1, data.points.length - 1)];
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(point.field_72450_a * (1.0 - speed)), (double)(point.field_72448_b * (1.0 - speed)), (double)(point.field_72449_c * (1.0 - speed)));
            GlStateManager.func_179137_b((double)(point2.field_72450_a * speed), (double)(point2.field_72448_b * speed), (double)(point2.field_72449_c * speed));
            model.setRotation(data.slopes[i]);
            GlStateManager.func_179114_b((float)data.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            model.renderBelt();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)((float)(-data.radius - data.bt) * 0.0625f), (float)0.0f);
        for (i = data.points.length - 1; i > 0; --i) {
            point = data.points[i];
            point2 = data.points[Math.max(i - 1, 0)];
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(point.field_72450_a * (1.0 - speed)), (double)(point.field_72448_b * (1.0 - speed)), (double)(point.field_72449_c * (1.0 - speed)));
            GlStateManager.func_179137_b((double)(point2.field_72450_a * speed), (double)(point2.field_72448_b * speed), (double)(point2.field_72449_c * speed));
            model.setRotation((float)Math.PI + data.slopes[i]);
            GlStateManager.func_179114_b((float)data.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            model.renderBelt();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        model.setRotation(0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)data.points[0].field_72450_a, (double)data.points[0].field_72448_b, (double)data.points[0].field_72449_c);
        GlStateManager.func_179114_b((float)data.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)((double)data.angleFirst * (1.0 - speed))), (float)0.0f, (float)0.0f, (float)1.0f);
        for (i = 0; i < data.sidePointsFirst; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)((float)(data.radius + data.bt) * 0.0625f), (float)0.0f);
            model.renderBelt();
            GlStateManager.func_179121_F();
            GlStateManager.func_179114_b((float)data.angleFirst, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)data.points[data.points.length - 1].field_72450_a, (double)data.points[data.points.length - 1].field_72448_b, (double)data.points[data.points.length - 1].field_72449_c);
        GlStateManager.func_179114_b((float)data.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(data.angleSecond + (float)((double)(-data.angleSecond) * (1.0 + speed))), (float)0.0f, (float)0.0f, (float)1.0f);
        for (i = 0; i < data.sidePointsSecond; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)((float)(data.radius + data.bt) * 0.0625f), (float)0.0f);
            model.renderBelt();
            GlStateManager.func_179121_F();
            GlStateManager.func_179114_b((float)(-data.angleSecond), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderEnergyTooltip(ArrayList<String> tooltip, int mx, int my, int x, int y, RotaryStorage storage, int w, int h, int spacing, int iconSize, boolean iconsAbove, boolean tooltipIcons) {
        if (tooltipIcons) {
            int iconHeight;
            int xx = (int)((double)(spacing + w) + 0.5 * (double)spacing - (double)(iconSize / 2));
            int yy = iconsAbove ? y - iconSize : y + 2 * spacing + h;
            int n = iconHeight = iconsAbove ? spacing : -spacing;
            if (mx > xx && mx < xx + iconSize && my > yy && my < yy + iconHeight) {
                tooltip.add("rotary.immersiveintelligence.mechanical.speed");
                return;
            }
            if (mx > (xx = (int)((double)xx + ((double)spacing + 0.5 * (double)w))) && mx < xx + iconSize && my > yy && my < yy + iconHeight) {
                tooltip.add("rotary.immersiveintelligence.mechanical.torque");
                return;
            }
        }
        if (mx >= x + spacing && mx <= x + spacing + w && my >= y + spacing && my <= y + spacing + h) {
            tooltip.add(I18n.func_135052_a((String)"rotary.immersiveintelligence.mechanical.speed", (Object[])new Object[0]) + ": " + storage.getRotationSpeed() + " " + I18n.func_135052_a((String)"rotary.immersiveintelligence.mechanical.speed_unit", (Object[])new Object[0]));
        }
        if (mx >= x + w + 2 * spacing && mx <= x + 2 * w + 2 * spacing && my >= y + spacing && my <= y + spacing + h) {
            tooltip.add(I18n.func_135052_a((String)"rotary.immersiveintelligence.mechanical.torque", (Object[])new Object[0]) + ": " + storage.getTorque() + " " + I18n.func_135052_a((String)"rotary.immersiveintelligence.mechanical.torque_unit", (Object[])new Object[0]));
        }
    }

    public static void renderEnergyTooltip(ArrayList<String> tooltip, int mx, int my, int x, int y, RotaryStorage storage) {
        RotaryUtils.renderEnergyTooltip(tooltip, mx, my, x, y, storage, 7, 48, 2, 8, true, true);
    }

    public static void renderEnergyBars(int x, int y, int w, int h, int spacing, RotaryStorage storage, float maxRPM, float maxTorque) {
        int rpm = Math.round((float)h * Math.min(storage.getRotationSpeed() / maxRPM, 1.0f));
        int torque = Math.round((float)h * Math.min(storage.getTorque() / maxTorque, 1.0f));
        ClientUtils.drawGradientRect((int)(x + spacing), (int)(y + spacing + (h - rpm)), (int)(x + spacing + w), (int)(y + spacing + h), (int)-4909824, (int)-10482944);
        ClientUtils.drawGradientRect((int)(x + 2 * spacing + w), (int)(y + spacing + (h - torque)), (int)(x + 2 * w + 2 * spacing), (int)(y + spacing + h), (int)-16730847, (int)-16762368);
    }

    public static void renderEnergyBars(int x, int y, RotaryStorage storage, NonNullList<ItemStack> gears) {
        RotaryUtils.renderEnergyBars(x, y, 7, 48, 2, storage, RotaryUtils.getMaxRPM(gears), RotaryUtils.getMaxTorque(gears));
    }

    public static float getGearEffectiveness(NonNullList<ItemStack> inventory, float modifier) {
        float fraction = 1.0f / (float)(inventory.size() + 1);
        float effectiveness = 0.0f;
        for (ItemStack stack : inventory) {
            if (stack.func_190926_b()) continue;
            effectiveness += fraction;
        }
        return MathHelper.func_76131_a((float)(effectiveness * modifier + fraction), (float)0.0f, (float)1.0f);
    }

    public static float getTorqueForIEDevice(TileEntity t, double rotation) {
        for (Map.Entry<Predicate<TileEntity>, Function<Float, Float>> e : ie_rotational_blocks_torque.entrySet()) {
            if (!e.getKey().test(t)) continue;
            return e.getValue().apply(Float.valueOf((float)rotation)).floatValue();
        }
        return Config.IIConfig.MechanicalDevices.dynamo_default_torque;
    }
}

