/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.rotary;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorBeltConnector;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;

public class MotorBeltNetwork {
    public List<WeakReference<IMotorBeltConnector>> connectors = new ArrayList<WeakReference<IMotorBeltConnector>>();
    public List<ImmersiveNetHandler.Connection> connections = new ArrayList<ImmersiveNetHandler.Connection>();
    public float loss = 0.0f;
    private float rpm = 0.0f;
    private float torque = 0.0f;

    public static void updateConnectors(BlockPos start, World world, MotorBeltNetwork network) {
        int dimension = world.field_73011_w.getDimension();
        HashSet<BlockPos> open = new HashSet<BlockPos>();
        open.add(start);
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        network.connectors.clear();
        network.loss = 0.0f;
        while (!open.isEmpty()) {
            Iterator it = open.iterator();
            BlockPos next = (BlockPos)it.next();
            it.remove();
            IImmersiveConnectable iic = ApiUtils.toIIC((Object)next, (World)world);
            closed.add(next);
            Set connsAtBlock = ImmersiveNetHandler.INSTANCE.getConnections(dimension, next);
            if (connsAtBlock != null && iic != null) {
                for (ImmersiveNetHandler.Connection c : connsAtBlock) {
                    if (!iic.allowEnergyToPass(c) || !"MOTOR_BELT".equals(c.cableType.getCategory()) || closed.contains(c.end)) continue;
                    open.add(c.end);
                    network.connections.add(c);
                }
            }
            if (!(iic instanceof IMotorBeltConnector)) continue;
            ((IMotorBeltConnector)iic).setNetwork(network);
            network.connectors.add(new WeakReference<IMotorBeltConnector>((IMotorBeltConnector)iic));
        }
        network.updateValues();
    }

    public MotorBeltNetwork add(IMotorBeltConnector connector) {
        this.connectors.add(new WeakReference<IMotorBeltConnector>(connector));
        return this;
    }

    public void mergeNetwork(MotorBeltNetwork wireNetwork) {
        List<WeakReference<IMotorBeltConnector>> conns = null;
        if (this.connectors.size() > 0) {
            conns = this.connectors;
        } else if (wireNetwork.connectors.size() > 0) {
            conns = wireNetwork.connectors;
        }
        if (conns == null) {
            return;
        }
        IMotorBeltConnector start = null;
        for (WeakReference<IMotorBeltConnector> conn : conns) {
            if (conn.get() == null) continue;
            start = (IMotorBeltConnector)conn.get();
            break;
        }
        if (start != null) {
            BlockPos startPos = Utils.toCC(start);
            MotorBeltNetwork.updateConnectors(startPos, start.getConnectorWorld(), this);
        }
        this.updateValues();
    }

    public void removeFromNetwork(IMotorBeltConnector removedConnector) {
        Iterator<WeakReference<IMotorBeltConnector>> iterator = this.connectors.iterator();
        HashSet<MotorBeltNetwork> knownNets = new HashSet<MotorBeltNetwork>();
        while (iterator.hasNext()) {
            WeakReference<IMotorBeltConnector> conn = iterator.next();
            IMotorBeltConnector start = (IMotorBeltConnector)conn.get();
            if (start == null || knownNets.contains(start.getNetwork())) continue;
            MotorBeltNetwork newNet = new MotorBeltNetwork();
            MotorBeltNetwork.updateConnectors(Utils.toCC((Object)start), start.getConnectorWorld(), newNet);
            knownNets.add(newNet);
        }
    }

    public void updateValues() {
        IMotorBeltConnector connector;
        double oldRPM = this.rpm;
        this.rpm = 0.0f;
        this.torque = 0.0f;
        ArrayList<Float> rpm_values = new ArrayList<Float>();
        ArrayList<Float> torque_values = new ArrayList<Float>();
        for (WeakReference<IMotorBeltConnector> connectorRef : this.connectors) {
            connector = (IMotorBeltConnector)connectorRef.get();
            if (connector == null) continue;
            rpm_values.add(Float.valueOf(connector.getRotaryStorage().getRotationSpeed()));
            torque_values.add(Float.valueOf(connector.getRotaryStorage().getTorque()));
        }
        rpm_values.forEach(value -> {
            if (value.floatValue() > this.rpm) {
                this.rpm = value.floatValue();
            }
        });
        torque_values.forEach(value -> this.torque += value.floatValue());
        this.loss = 0.0f;
        for (ImmersiveNetHandler.Connection conn : this.connections) {
            this.loss += conn.getBaseLoss();
        }
        this.rpm = Math.max(0.0f, this.rpm - this.rpm * this.loss);
        for (WeakReference<IMotorBeltConnector> connectorRef : this.connectors) {
            connector = (IMotorBeltConnector)connectorRef.get();
            if (connector == null) continue;
            connector.onChange();
        }
    }

    public RotaryStorage getEnergyStorage() {
        return new RotaryStorage(this.torque, this.rpm);
    }

    public double getNetworkRPM() {
        return this.rpm;
    }

    public double getNetworkTorque() {
        return this.torque;
    }

    @SideOnly(value=Side.CLIENT)
    public void setClient(float rpm, float torque) {
        this.rpm = rpm;
        this.torque = torque;
    }
}

