/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.rotary;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.rotary.IModelMotorBelt;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltType;
import pl.pabilo8.immersiveintelligence.client.render.MechanicalConnectorRenderer;
import pl.pabilo8.immersiveintelligence.common.blocks.rotary.TileEntityMechanicalConnectable;

public class MotorBeltData {
    public IModelMotorBelt model;
    public int sidePointsFirst;
    public int sidePointsSecond;
    public int totalPoints;
    public int yaw;
    public int bt;
    public int radius;
    public float angleFirst;
    public float angleSecond;
    public float bs;
    public Vec3d[] points;
    public Vec3d offset;
    public float[] slopes;
    public String texture;

    public MotorBeltData(IModelMotorBelt model, int sidePointsFirst, int sidePointsSecond, int totalPoints, float angleFirst, float angleSecond, int yaw, Vec3d[] points, float[] slopes, Vec3d offset, String texture, int bt, int radius, float bs) {
        this.model = model;
        this.sidePointsFirst = sidePointsFirst;
        this.sidePointsSecond = sidePointsSecond;
        this.totalPoints = totalPoints;
        this.angleFirst = angleFirst;
        this.angleSecond = angleSecond;
        this.yaw = yaw;
        this.points = points;
        this.slopes = slopes;
        this.offset = offset;
        this.texture = texture;
        this.bt = bt;
        this.radius = radius;
        this.bs = bs;
    }

    @Nullable
    public static MotorBeltData createBeltData(ImmersiveNetHandler.Connection connection, TileEntityMechanicalConnectable start, TileEntityMechanicalConnectable end) {
        if (!(connection.cableType instanceof MotorBeltType) || start == null || end == null) {
            return null;
        }
        Vec3d offset = start.getConnectionOffset(connection);
        MotorBeltType type = (MotorBeltType)connection.cableType;
        IModelMotorBelt model = type.getModel();
        String texture = type.getTexture() + ".png";
        float bs = type.getWidth();
        int bt = type.getThickness();
        int radius = start.getRadius();
        if (connection.length <= 0) {
            return null;
        }
        int sidePointsFirst = (int)Math.ceil(Math.PI * (double)start.getRadius() / (double)type.getWidth());
        int sidePointsSecond = (int)Math.ceil(Math.PI * (double)end.getRadius() / (double)type.getWidth());
        int totalPoints = (int)Math.ceil(connection.horizontalLength * 16.0 / (double)type.getWidth());
        float angleFirst = 0.0f;
        float angleSecond = 0.0f;
        int yaw = 0;
        if (start.getConnectionAxis() == EnumFacing.Axis.X) {
            yaw = start.func_174877_v().func_177958_n() > end.func_174877_v().func_177958_n() ? -180 : 0;
        } else if (start.getConnectionAxis() == EnumFacing.Axis.Z) {
            int n = yaw = start.func_174877_v().func_177952_p() > end.func_174877_v().func_177952_p() ? 90 : -90;
        }
        if (sidePointsFirst > 0) {
            angleFirst = 180 / sidePointsFirst;
        }
        if (sidePointsSecond > 0) {
            angleSecond = 180 / sidePointsSecond;
        }
        Vec3d[] points = new Vec3d[totalPoints + 1];
        float[] slopes = new float[totalPoints + 1];
        for (int i = 0; i < totalPoints + 1; ++i) {
            try {
                points[i] = connection.getVecAt((double)i / (double)(connection.length * 16) * (double)type.getWidth());
                slopes[i] = (float)connection.getSlopeAt((double)i / (double)(connection.length * 16) * (double)type.getWidth());
                continue;
            }
            catch (NullPointerException n) {
                return null;
            }
        }
        MotorBeltData data = new MotorBeltData(model, sidePointsFirst, sidePointsSecond, totalPoints, angleFirst, angleSecond, yaw, points, slopes, offset, texture, bt, radius, bs);
        MechanicalConnectorRenderer.cache.put(connection, data);
        MechanicalConnectorRenderer.cache.put(ImmersiveNetHandler.INSTANCE.getReverseConnection(start.func_145831_w().field_73011_w.getDimension(), connection), null);
        return data;
    }
}

