/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.rotary;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public interface IRotaryEnergy {
    public float getTorque();

    public void setTorque(float var1);

    default public float getOutputTorque() {
        return this.getTorque();
    }

    public float getRotationSpeed();

    public void setRotationSpeed(float var1);

    default public float getOutputRotationSpeed() {
        return this.getRotationSpeed();
    }

    default public float getEnergy() {
        return this.getTorque() * this.getRotationSpeed();
    }

    public RotationSide getSide(@Nullable EnumFacing var1);

    default public boolean canBeMerged(IRotaryEnergy other) {
        return other.getOutputRotationSpeed() == this.getRotationSpeed();
    }

    default public float getCombinedTorque(IRotaryEnergy other) {
        return this.canBeMerged(other) ? this.getTorque() + other.getOutputTorque() : Math.min(this.getTorque(), other.getOutputTorque());
    }

    default public boolean grow(IRotaryEnergy other, float percent) {
        return this.grow(other.getOutputRotationSpeed(), other.getOutputTorque(), percent);
    }

    default public boolean grow(float other_speed, float other_torque, float percent) {
        float t = this.getTorque();
        float r = this.getRotationSpeed();
        if (other_torque >= this.getTorque()) {
            this.setTorque(Math.min(this.getTorque() + percent * other_torque, other_torque));
        } else {
            this.setTorque(Math.min(0.0f, Math.max(this.getTorque() - percent * other_torque, other_torque)));
        }
        if (other_speed >= this.getRotationSpeed()) {
            this.setRotationSpeed(Math.min(this.getRotationSpeed() + percent * other_speed, other_speed));
        } else {
            this.setRotationSpeed(Math.min(0.0f, Math.max(this.getRotationSpeed() - percent * other_speed, other_speed)));
        }
        return this.getTorque() != t || this.getRotationSpeed() != r;
    }

    default public boolean handleRotation(IRotaryEnergy other, EnumFacing facing) {
        if (other.getSide(facing).canOutput) {
            return this.grow(other, 0.01f);
        }
        return false;
    }

    default public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("speed", this.getRotationSpeed());
        nbt.func_74776_a("torque", this.getTorque());
        return nbt;
    }

    default public void fromNBT(NBTTagCompound nbt) {
        this.setRotationSpeed(nbt.func_74760_g("speed"));
        this.setTorque(nbt.func_74760_g("torque"));
    }

    public static enum RotationSide {
        INPUT(true, false),
        OUTPUT(false, true),
        BOTH(true, true),
        NONE(false, false);

        private boolean canInput;
        private boolean canOutput;

        private RotationSide(boolean canInput, boolean canOutput) {
            this.canInput = canInput;
            this.canOutput = canOutput;
        }

        public boolean canInput() {
            return this.canInput;
        }

        public boolean canOutput() {
            return this.canOutput;
        }
    }
}

