/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;

public class DataWireNetwork {
    public List<WeakReference<IDataConnector>> connectors = new ArrayList<WeakReference<IDataConnector>>();

    public DataWireNetwork add(IDataConnector connector) {
        this.connectors.add(new WeakReference<IDataConnector>(connector));
        return this;
    }

    public void mergeNetwork(DataWireNetwork wireNetwork) {
        List<WeakReference<IDataConnector>> conns = null;
        if (this.connectors.size() > 0) {
            conns = this.connectors;
        } else if (wireNetwork.connectors.size() > 0) {
            conns = wireNetwork.connectors;
        }
        if (conns == null) {
            return;
        }
        IDataConnector start = null;
        for (WeakReference<IDataConnector> conn : conns) {
            if (conn.get() == null) continue;
            start = (IDataConnector)conn.get();
            break;
        }
        if (start != null) {
            BlockPos startPos = Utils.toCC(start);
            DataWireNetwork.updateConnectors(startPos, start.getConnectorWorld(), this);
        }
    }

    public void removeFromNetwork(IDataConnector removedConnector) {
        Iterator<WeakReference<IDataConnector>> iterator = this.connectors.iterator();
        HashSet<DataWireNetwork> knownNets = new HashSet<DataWireNetwork>();
        while (iterator.hasNext()) {
            WeakReference<IDataConnector> conn = iterator.next();
            IDataConnector start = (IDataConnector)conn.get();
            if (start == null || knownNets.contains(start.getNetwork())) continue;
            DataWireNetwork newNet = new DataWireNetwork();
            DataWireNetwork.updateConnectors(Utils.toCC((Object)start), start.getConnectorWorld(), newNet);
            knownNets.add(newNet);
        }
    }

    public static void updateConnectors(BlockPos start, World world, DataWireNetwork network) {
        int dimension = world.field_73011_w.getDimension();
        HashSet<BlockPos> open = new HashSet<BlockPos>();
        open.add(start);
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        network.connectors.clear();
        while (!open.isEmpty()) {
            Iterator it = open.iterator();
            BlockPos next = (BlockPos)it.next();
            it.remove();
            IImmersiveConnectable iic = ApiUtils.toIIC((Object)next, (World)world);
            closed.add(next);
            Set connsAtBlock = ImmersiveNetHandler.INSTANCE.getConnections(dimension, next);
            if (iic instanceof IDataConnector) {
                ((IDataConnector)iic).setNetwork(network);
                network.connectors.add(new WeakReference<IDataConnector>((IDataConnector)iic));
            }
            if (connsAtBlock == null || iic == null) continue;
            for (ImmersiveNetHandler.Connection c : connsAtBlock) {
                if (!iic.allowEnergyToPass(c) || closed.contains(c.end)) continue;
                open.add(c.end);
            }
        }
    }

    public void sendPacket(DataPacket packet, IDataConnector sender) {
        for (WeakReference<IDataConnector> connectorRef : this.connectors) {
            IDataConnector connector = (IDataConnector)connectorRef.get();
            if (connector == null || connector.equals(sender)) continue;
            connector.onPacketReceive(packet);
        }
    }
}

