/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeArray;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataPacket {
    public Map<Character, IDataType> variables = new HashMap<Character, IDataType>();
    public static final char[] varCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    public static final Map<String, Class> varTypes = new HashMap<String, Class>();

    public IDataType getPacketVariable(Character name) {
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        return new DataPacketTypeNull();
    }

    public boolean setVariable(Character c, IDataType type) {
        if (ArrayUtils.contains((char[])varCharacters, (char)c.charValue())) {
            if (this.variables.containsKey(c)) {
                this.variables.remove(c);
            }
            this.variables.put(c, type);
            return true;
        }
        return false;
    }

    public void removeAllVariables() {
        for (char c : varCharacters) {
            this.removeVariable(Character.valueOf(c));
        }
    }

    public boolean removeVariable(Character c) {
        if (ArrayUtils.contains((char[])varCharacters, (char)c.charValue())) {
            if (this.variables.containsKey(c)) {
                this.variables.remove(c);
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<Character, IDataType> entry : this.variables.entrySet()) {
            nbt.func_74782_a(String.valueOf(entry.getKey()), (NBTBase)entry.getValue().valueToNBT());
        }
        return nbt;
    }

    public void fromNBT(NBTTagCompound nbt) {
        this.variables.clear();
        char[] cArray = varCharacters;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            NBTTagCompound n2;
            String type;
            Character c = Character.valueOf(cArray[i]);
            if (!nbt.func_74764_b(String.valueOf(c)) || !varTypes.containsKey(type = (n2 = nbt.func_74775_l(String.valueOf(c))).func_74779_i("Type"))) continue;
            IDataType data = null;
            try {
                data = (IDataType)varTypes.get(type).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            if (data == null) continue;
            data.valueFromNBT(n2);
            this.variables.put(c, data);
        }
    }

    public DataPacket clone() {
        DataPacket packet = new DataPacket();
        packet.fromNBT(this.toNBT());
        return packet;
    }

    static {
        varTypes.put("null", DataPacketTypeNull.class);
        varTypes.put("integer", DataPacketTypeInteger.class);
        varTypes.put("string", DataPacketTypeString.class);
        varTypes.put("boolean", DataPacketTypeBoolean.class);
        varTypes.put("accessor", DataPacketTypeAccessor.class);
        varTypes.put("expression", DataPacketTypeExpression.class);
        varTypes.put("itemstack", DataPacketTypeItemStack.class);
        varTypes.put("array", DataPacketTypeArray.class);
    }
}

