/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.utils.IPrecissionTool;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIAssemblyScheme;

public class PrecissionAssemblerRecipe
extends MultiblockRecipe {
    public float energyModifier = 1.0f;
    public float timeModifier = 1.0f;
    public ItemStack output;
    public ItemStack trashOutput;
    public IngredientStack[] inputs;
    public String[] tools;
    public String[] animations;
    public static HashMap<String, IPrecissionTool> toolMap = new HashMap();
    public static ArrayList<PrecissionAssemblerRecipe> recipeList = new ArrayList();
    int totalProcessTime;
    int totalProcessEnergy;

    public PrecissionAssemblerRecipe(ItemStack itemOutput, ItemStack trash, Object[] itemInputs, String[] tools, String[] animations, int energy, float timeMultiplier) {
        this.output = itemOutput;
        this.trashOutput = trash;
        this.inputs = new IngredientStack[itemInputs.length];
        for (int io = 0; io < itemInputs.length; ++io) {
            this.inputs[io] = ApiUtils.createIngredientStack((Object)itemInputs[io]);
        }
        int processDuration = 2 * Config.IIConfig.Machines.PrecissionAssembler.hatchTime;
        for (String animation : animations) {
            String[] split = animation.split(" ");
            if (split.length < 2 || split[0] == null || !toolMap.containsKey(split[0])) continue;
            processDuration += toolMap.get(split[0]).getWorkTime(split[0]);
        }
        this.tools = tools;
        this.animations = animations;
        this.totalProcessEnergy = (int)Math.floor((float)energy * this.energyModifier);
        this.timeModifier = timeMultiplier;
        this.totalProcessTime = (int)Math.floor((float)processDuration * this.timeModifier);
        this.inputList = Lists.newArrayList((Object[])this.inputs);
        this.outputList = ListUtils.fromItem((ItemStack)this.output);
        this.outputList.add((Object)this.trashOutput);
    }

    public static PrecissionAssemblerRecipe addRecipe(ItemStack itemOutput, ItemStack trash, Object[] itemInputs, String[] tools, String[] animations, int energy, float timeMultiplier) {
        PrecissionAssemblerRecipe r = new PrecissionAssemblerRecipe(itemOutput, trash, itemInputs, tools, animations, energy, timeMultiplier);
        recipeList.add(r);
        return r;
    }

    public static List<PrecissionAssemblerRecipe> removeRecipesForOutput(ItemStack stack) {
        ArrayList<PrecissionAssemblerRecipe> list = new ArrayList<PrecissionAssemblerRecipe>();
        Iterator<PrecissionAssemblerRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            PrecissionAssemblerRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static PrecissionAssemblerRecipe findRecipe(ItemStack[] item_input, ItemStack scheme, ItemStack[] tools) {
        if (!(scheme.func_77973_b() instanceof ItemIIAssemblyScheme)) {
            return null;
        }
        for (PrecissionAssemblerRecipe recipe : recipeList) {
            if (!Objects.equals((Object)CommonProxy.item_assembly_scheme.getRecipeForStack(scheme), (Object)recipe)) continue;
            boolean jawohl = true;
            if (recipe.inputs.length > item_input.length) continue;
            for (int i = 0; i < recipe.inputs.length; ++i) {
                if (recipe.inputs[i].matches((Object)item_input[i])) continue;
                jawohl = false;
                break;
            }
            if (jawohl && tools.length < recipe.tools.length) continue;
            if (jawohl) {
                ArrayList<String> neededTools = new ArrayList<String>();
                neededTools.addAll(Arrays.asList(recipe.tools));
                ArrayList<String> availableTools = new ArrayList<String>();
                for (ItemStack toolstack : tools) {
                    if (toolstack.func_190926_b() || !(toolstack.func_77973_b() instanceof IPrecissionTool)) continue;
                    availableTools.add(((IPrecissionTool)toolstack.func_77973_b()).getPrecissionToolType(toolstack));
                }
                for (String tool : neededTools) {
                    if (!jawohl) break;
                    if (availableTools.contains(tool)) {
                        availableTools.remove(tool);
                        continue;
                    }
                    jawohl = false;
                }
            }
            if (!jawohl) continue;
            return recipe;
        }
        return null;
    }

    public static List<PrecissionAssemblerRecipe> findIncompleteBathingRecipe(ItemStack[] item_input, ItemStack scheme) {
        if (item_input == null || item_input.length == 0 || scheme == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        block0: for (PrecissionAssemblerRecipe recipe : recipeList) {
            if (scheme.func_77973_b() instanceof ItemIIAssemblyScheme && CommonProxy.item_assembly_scheme.getRecipeForStack(scheme) != null && ((Object)((Object)CommonProxy.item_assembly_scheme.getRecipeForStack(scheme))).equals((Object)recipe)) {
                list.add(recipe);
                continue;
            }
            for (int i = 0; i < recipe.inputs.length; ++i) {
                if (!recipe.inputs[i].matches((Object)item_input[i])) continue;
                list.add(recipe);
                continue block0;
            }
        }
        return list;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (IngredientStack ingr : this.inputs) {
            list.func_74742_a((NBTBase)ingr.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("inputs", (NBTBase)list);
        return nbt;
    }

    public static PrecissionAssemblerRecipe loadFromNBT(NBTTagCompound nbt) {
        return null;
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public static void registerToolType(String name, IPrecissionTool tool) {
        toolMap.put(name, tool);
    }

    public static ItemStack getExampleToolStack(String name) {
        if (toolMap.containsKey(name)) {
            return toolMap.get(name).getToolPresentationStack(name);
        }
        return ItemStack.field_190927_a;
    }
}

