/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BathingRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack itemInput;
    public final ItemStack itemOutput;
    public final FluidStack fluidInput;
    public static ArrayList<BathingRecipe> recipeList = new ArrayList();
    int totalProcessTime;
    int totalProcessEnergy;

    public BathingRecipe(ItemStack itemOutput, Object itemInput, FluidStack fluidInput, int energy, int time) {
        this.itemOutput = itemOutput;
        this.itemInput = ApiUtils.createIngredientStack((Object)itemInput);
        this.fluidInput = fluidInput;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.fluidInputList = Collections.singletonList(this.fluidInput);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.itemInput});
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{itemOutput});
    }

    public static BathingRecipe addRecipe(ItemStack itemOutput, IngredientStack itemInput, FluidStack fluidInput, int energy, int time) {
        BathingRecipe r = new BathingRecipe(itemOutput, itemInput, fluidInput, energy, time);
        recipeList.add(r);
        return r;
    }

    public static List<BathingRecipe> removeRecipesForOutput(ItemStack stack) {
        ArrayList<BathingRecipe> list = new ArrayList<BathingRecipe>();
        Iterator<BathingRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            BathingRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.itemOutput, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static BathingRecipe findRecipe(ItemStack item_input, FluidStack fluid_input) {
        for (BathingRecipe recipe : recipeList) {
            if (!recipe.itemInput.matchesItemStack(item_input) || !fluid_input.isFluidEqual(recipe.fluidInput) || fluid_input.amount < recipe.fluidInput.amount) continue;
            return recipe;
        }
        return null;
    }

    public static List<BathingRecipe> findIncompleteBathingRecipe(ItemStack item_input, FluidStack fluid_input) {
        if (item_input == null || fluid_input == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (BathingRecipe recipe : recipeList) {
            if (!recipe.itemInput.matchesItemStack(item_input) && !fluid_input.isFluidEqual(recipe.fluidInput)) continue;
            list.add(recipe);
            break;
        }
        return list;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item_input", (NBTBase)this.itemInput.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("fluid_input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static BathingRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack item_input = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("item_input"));
        FluidStack fluid_input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid_input"));
        return BathingRecipe.findRecipe(item_input.stack, fluid_input);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }
}

