/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageBlockDamageSync;

public class PenetrationHelper {
    public static void dealBlockDamage(World world, float bulletDamage, DimensionBlockPos pos, float hp, PenetrationRegistry.IPenetrationHandler pen) {
        float newHp = hp - bulletDamage;
        if (newHp > 0.0f) {
            PenetrationRegistry.blockDamage.replace(pos, Float.valueOf(newHp));
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBlockDamageSync(newHp / (pen.getIntegrity() / pen.getDensity()), pos), Utils.targetPointFromPos((BlockPos)pos, world, 32));
        } else if (newHp <= 0.0f) {
            PenetrationRegistry.blockDamage.remove(pos);
            world.func_175655_b((BlockPos)pos, false);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBlockDamageSync(-1.0f, pos), Utils.targetPointFromPos((BlockPos)pos, world, 32));
        }
    }

    public static void registerMetalMaterial(PenetrationRegistry.IPenetrationHandler handler, String name) {
        PenetrationHelper.registerMetalMaterial(handler, name, true, true, true);
    }

    public static void registerMetalMaterial(PenetrationRegistry.IPenetrationHandler handler, String name, boolean hasSlab, boolean hasSheetMetal, boolean hasSheetmetalSlab) {
        PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "block" + Utils.toCamelCase(name, false)), handler);
        if (hasSlab) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "slab" + Utils.toCamelCase(name, false)), handler);
        }
        if (hasSheetMetal) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "blockSheetmetal" + Utils.toCamelCase(name, false)), handler);
        }
        if (hasSheetmetalSlab) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "slabSheetmetal" + Utils.toCamelCase(name, false)), handler);
        }
    }

    public static void batchRegisterHandler(PenetrationRegistry.IPenetrationHandler handler, Block ... blocks) {
        for (Block b : blocks) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> iBlockState.func_177230_c() == b, handler);
        }
    }

    public static void supress(World world, double posX, double posY, double posZ, float supressionRadius, int suppressionPower) {
        List entities = world.func_72872_a(EntityLiving.class, new AxisAlignedBB(posX, posY, posZ, posX + 1.0, posY + 1.0, posZ + 1.0).func_186662_g((double)supressionRadius));
        for (EntityLivingBase entity : entities) {
            PotionEffect effect = entity.func_70660_b(IIPotions.suppression);
            if (effect == null) {
                effect = new PotionEffect(IIPotions.suppression, 120, suppressionPower, false, false);
            } else {
                effect.field_76460_b = 10;
                effect.func_76452_a(new PotionEffect(IIPotions.suppression, 120, Math.min(255, effect.func_76458_c() + suppressionPower)));
            }
            ImmersiveIntelligence.logger.info(entity.toString() + " / " + effect.field_76460_b + " / " + effect.func_76458_c());
            entity.func_70690_d(effect);
        }
    }

    public static void breakArmour(Entity entity, int damageToArmour) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)entity;
            PotionEffect effect = ent.func_70660_b(IIPotions.suppression);
            if (effect == null) {
                effect = new PotionEffect(IIPotions.suppression, 60, damageToArmour, false, false);
            } else {
                effect.field_76460_b = 10;
                effect.func_76452_a(new PotionEffect(IIPotions.suppression, 60, Math.min(255, effect.func_76458_c() + damageToArmour)));
                ImmersiveIntelligence.logger.info(ent.toString() + " / " + effect.field_76460_b + " / " + effect.func_76458_c());
            }
            for (ItemStack stack : ent.func_184193_aE()) {
                stack.func_77972_a(damageToArmour, ent);
            }
            ent.func_70690_d(effect);
        }
    }
}

